/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import java.util.Objects;

public class PackageIdentifier {
    private static final String PACKAGE_NAME_FIELD = "packageName";
    private static final String SHA256_CERTIFICATE_FIELD = "sha256Certificate";
    private final Bundle mBundle;

    public PackageIdentifier(String packageName, byte[] sha256Certificate) {
        this.mBundle = new Bundle();
        this.mBundle.putString(PACKAGE_NAME_FIELD, packageName);
        this.mBundle.putByteArray(SHA256_CERTIFICATE_FIELD, sha256Certificate);
    }

    public PackageIdentifier(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public String getPackageName() {
        return Objects.requireNonNull(this.mBundle.getString(PACKAGE_NAME_FIELD));
    }

    public byte[] getSha256Certificate() {
        return Objects.requireNonNull(this.mBundle.getByteArray(SHA256_CERTIFICATE_FIELD));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PackageIdentifier)) {
            return false;
        }
        PackageIdentifier other = (PackageIdentifier)obj;
        return BundleUtil.deepEquals(this.mBundle, other.mBundle);
    }

    public int hashCode() {
        return BundleUtil.deepHashCode(this.mBundle);
    }
}

