/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import com.android.internal.lang.System_Delegate;
import java.util.Objects;

public class ReportUsageRequest {
    private final String mNamespace;
    private final String mDocumentId;
    private final long mUsageTimestampMillis;

    ReportUsageRequest(String namespace, String documentId, long usageTimestampMillis) {
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mDocumentId = Objects.requireNonNull(documentId);
        this.mUsageTimestampMillis = usageTimestampMillis;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getDocumentId() {
        return this.mDocumentId;
    }

    public long getUsageTimestampMillis() {
        return this.mUsageTimestampMillis;
    }

    public static class Builder {
        private final String mNamespace;
        private final String mDocumentId;
        private Long mUsageTimestampMillis;

        public Builder(String namespace, String documentId) {
            this.mNamespace = Objects.requireNonNull(namespace);
            this.mDocumentId = Objects.requireNonNull(documentId);
        }

        public Builder setUsageTimestampMillis(long usageTimestampMillis) {
            this.mUsageTimestampMillis = usageTimestampMillis;
            return this;
        }

        public ReportUsageRequest build() {
            if (this.mUsageTimestampMillis == null) {
                this.mUsageTimestampMillis = System_Delegate.currentTimeMillis();
            }
            return new ReportUsageRequest(this.mNamespace, this.mDocumentId, this.mUsageTimestampMillis);
        }
    }
}

