/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.Migrator;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.internal.util.Preconditions;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SetSchemaRequest {
    private final Set<AppSearchSchema> mSchemas;
    private final Set<String> mSchemasNotDisplayedBySystem;
    private final Map<String, Set<PackageIdentifier>> mSchemasVisibleToPackages;
    private final Map<String, Migrator> mMigrators;
    private final boolean mForceOverride;
    private final int mVersion;

    SetSchemaRequest(Set<AppSearchSchema> schemas, Set<String> schemasNotDisplayedBySystem, Map<String, Set<PackageIdentifier>> schemasVisibleToPackages, Map<String, Migrator> migrators, boolean forceOverride, int version) {
        this.mSchemas = Objects.requireNonNull(schemas);
        this.mSchemasNotDisplayedBySystem = Objects.requireNonNull(schemasNotDisplayedBySystem);
        this.mSchemasVisibleToPackages = Objects.requireNonNull(schemasVisibleToPackages);
        this.mMigrators = Objects.requireNonNull(migrators);
        this.mForceOverride = forceOverride;
        this.mVersion = version;
    }

    public Set<AppSearchSchema> getSchemas() {
        return Collections.unmodifiableSet(this.mSchemas);
    }

    public Set<String> getSchemasNotDisplayedBySystem() {
        return Collections.unmodifiableSet(this.mSchemasNotDisplayedBySystem);
    }

    public Map<String, Set<PackageIdentifier>> getSchemasVisibleToPackages() {
        ArrayMap<String, Set<PackageIdentifier>> copy = new ArrayMap<String, Set<PackageIdentifier>>();
        for (String key : this.mSchemasVisibleToPackages.keySet()) {
            copy.put(key, new ArraySet(this.mSchemasVisibleToPackages.get(key)));
        }
        return copy;
    }

    public Map<String, Migrator> getMigrators() {
        return Collections.unmodifiableMap(this.mMigrators);
    }

    public Map<String, Set<PackageIdentifier>> getSchemasVisibleToPackagesInternal() {
        return this.mSchemasVisibleToPackages;
    }

    public boolean isForceOverride() {
        return this.mForceOverride;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public static class Builder {
        private static final int DEFAULT_VERSION = 1;
        private ArraySet<AppSearchSchema> mSchemas = new ArraySet();
        private ArraySet<String> mSchemasNotDisplayedBySystem = new ArraySet();
        private ArrayMap<String, Set<PackageIdentifier>> mSchemasVisibleToPackages = new ArrayMap();
        private ArrayMap<String, Migrator> mMigrators = new ArrayMap();
        private boolean mForceOverride = false;
        private int mVersion = 1;
        private boolean mBuilt = false;

        public Builder addSchemas(AppSearchSchema ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addSchemas(Arrays.asList(schemas));
        }

        public Builder addSchemas(Collection<AppSearchSchema> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemas);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSchemaTypeDisplayedBySystem(String schemaType, boolean displayed) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            if (displayed) {
                this.mSchemasNotDisplayedBySystem.remove(schemaType);
            } else {
                this.mSchemasNotDisplayedBySystem.add(schemaType);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSchemaTypeVisibilityForPackage(String schemaType, boolean visible, PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(packageIdentifier);
            this.resetIfBuilt();
            Set<PackageIdentifier> packageIdentifiers = this.mSchemasVisibleToPackages.get(schemaType);
            if (visible) {
                if (packageIdentifiers == null) {
                    packageIdentifiers = new ArraySet<PackageIdentifier>();
                }
                packageIdentifiers.add(packageIdentifier);
                this.mSchemasVisibleToPackages.put(schemaType, packageIdentifiers);
            } else {
                if (packageIdentifiers == null) {
                    return this;
                }
                packageIdentifiers.remove(packageIdentifier);
                if (packageIdentifiers.isEmpty()) {
                    this.mSchemasVisibleToPackages.remove(schemaType);
                }
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMigrator(String schemaType, Migrator migrator) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(migrator);
            this.resetIfBuilt();
            this.mMigrators.put(schemaType, migrator);
            return this;
        }

        public Builder setMigrators(Map<String, Migrator> migrators) {
            Objects.requireNonNull(migrators);
            this.resetIfBuilt();
            this.mMigrators.putAll(migrators);
            return this;
        }

        public Builder setForceOverride(boolean forceOverride) {
            this.resetIfBuilt();
            this.mForceOverride = forceOverride;
            return this;
        }

        public Builder setVersion(int version) {
            Preconditions.checkArgument(version >= 1, "Version must be a positive number.");
            this.resetIfBuilt();
            this.mVersion = version;
            return this;
        }

        public SetSchemaRequest build() {
            ArraySet<String> referencedSchemas = new ArraySet<String>(this.mSchemasNotDisplayedBySystem);
            referencedSchemas.addAll(this.mSchemasVisibleToPackages.keySet());
            for (AppSearchSchema schema : this.mSchemas) {
                referencedSchemas.remove(schema.getSchemaType());
            }
            if (!referencedSchemas.isEmpty()) {
                throw new IllegalArgumentException("Schema types " + referencedSchemas + " referenced, but were not added.");
            }
            if (this.mSchemas.isEmpty() && this.mVersion != 1) {
                throw new IllegalArgumentException("Cannot set version to the request if schema is empty.");
            }
            this.mBuilt = true;
            return new SetSchemaRequest(this.mSchemas, this.mSchemasNotDisplayedBySystem, this.mSchemasVisibleToPackages, this.mMigrators, this.mForceOverride, this.mVersion);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                ArrayMap schemasVisibleToPackages = new ArrayMap(this.mSchemasVisibleToPackages.size());
                for (Map.Entry<String, Set<PackageIdentifier>> entry : this.mSchemasVisibleToPackages.entrySet()) {
                    schemasVisibleToPackages.put(entry.getKey(), new ArraySet(entry.getValue()));
                }
                this.mSchemasVisibleToPackages = schemasVisibleToPackages;
                this.mSchemas = new ArraySet<AppSearchSchema>(this.mSchemas);
                this.mSchemasNotDisplayedBySystem = new ArraySet<String>(this.mSchemasNotDisplayedBySystem);
                this.mMigrators = new ArrayMap<String, Migrator>(this.mMigrators);
                this.mBuilt = false;
            }
        }
    }
}

