/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.app.appsearch.internal.util.Preconditions;
import android.os.Bundle;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SetSchemaResponse {
    private static final String DELETED_TYPES_FIELD = "deletedTypes";
    private static final String INCOMPATIBLE_TYPES_FIELD = "incompatibleTypes";
    private static final String MIGRATED_TYPES_FIELD = "migratedTypes";
    private final Bundle mBundle;
    private final List<MigrationFailure> mMigrationFailures;
    private Set<String> mDeletedTypes;
    private Set<String> mMigratedTypes;
    private Set<String> mIncompatibleTypes;

    SetSchemaResponse(Bundle bundle, List<MigrationFailure> migrationFailures) {
        this.mBundle = Objects.requireNonNull(bundle);
        this.mMigrationFailures = Objects.requireNonNull(migrationFailures);
    }

    SetSchemaResponse(Bundle bundle) {
        this(bundle, Collections.emptyList());
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public List<MigrationFailure> getMigrationFailures() {
        return Collections.unmodifiableList(this.mMigrationFailures);
    }

    public Set<String> getDeletedTypes() {
        if (this.mDeletedTypes == null) {
            this.mDeletedTypes = new ArraySet<String>((Collection)Objects.requireNonNull(this.mBundle.getStringArrayList(DELETED_TYPES_FIELD)));
        }
        return Collections.unmodifiableSet(this.mDeletedTypes);
    }

    public Set<String> getMigratedTypes() {
        if (this.mMigratedTypes == null) {
            this.mMigratedTypes = new ArraySet<String>((Collection)Objects.requireNonNull(this.mBundle.getStringArrayList(MIGRATED_TYPES_FIELD)));
        }
        return Collections.unmodifiableSet(this.mMigratedTypes);
    }

    public Set<String> getIncompatibleTypes() {
        if (this.mIncompatibleTypes == null) {
            this.mIncompatibleTypes = new ArraySet<String>((Collection)Objects.requireNonNull(this.mBundle.getStringArrayList(INCOMPATIBLE_TYPES_FIELD)));
        }
        return Collections.unmodifiableSet(this.mIncompatibleTypes);
    }

    public Builder toBuilder() {
        return new Builder().addDeletedTypes(this.getDeletedTypes()).addIncompatibleTypes(this.getIncompatibleTypes()).addMigratedTypes(this.getMigratedTypes()).addMigrationFailures(this.mMigrationFailures);
    }

    public static class MigrationFailure {
        private static final String SCHEMA_TYPE_FIELD = "schemaType";
        private static final String NAMESPACE_FIELD = "namespace";
        private static final String DOCUMENT_ID_FIELD = "id";
        private static final String ERROR_MESSAGE_FIELD = "errorMessage";
        private static final String RESULT_CODE_FIELD = "resultCode";
        private final Bundle mBundle;

        public MigrationFailure(String namespace, String documentId, String schemaType, AppSearchResult<?> failedResult) {
            this.mBundle = new Bundle();
            this.mBundle.putString(NAMESPACE_FIELD, Objects.requireNonNull(namespace));
            this.mBundle.putString(DOCUMENT_ID_FIELD, Objects.requireNonNull(documentId));
            this.mBundle.putString(SCHEMA_TYPE_FIELD, Objects.requireNonNull(schemaType));
            Objects.requireNonNull(failedResult);
            Preconditions.checkArgument(!failedResult.isSuccess(), "failedResult was actually successful");
            this.mBundle.putString(ERROR_MESSAGE_FIELD, failedResult.getErrorMessage());
            this.mBundle.putInt(RESULT_CODE_FIELD, failedResult.getResultCode());
        }

        MigrationFailure(Bundle bundle) {
            this.mBundle = Objects.requireNonNull(bundle);
        }

        public Bundle getBundle() {
            return this.mBundle;
        }

        public String getNamespace() {
            return this.mBundle.getString(NAMESPACE_FIELD, "");
        }

        public String getDocumentId() {
            return this.mBundle.getString(DOCUMENT_ID_FIELD, "");
        }

        public String getSchemaType() {
            return this.mBundle.getString(SCHEMA_TYPE_FIELD, "");
        }

        public AppSearchResult<Void> getAppSearchResult() {
            return AppSearchResult.newFailedResult(this.mBundle.getInt(RESULT_CODE_FIELD), this.mBundle.getString(ERROR_MESSAGE_FIELD, ""));
        }

        public String toString() {
            return "MigrationFailure { schemaType: " + this.getSchemaType() + ", namespace: " + this.getNamespace() + ", documentId: " + this.getDocumentId() + ", appSearchResult: " + this.getAppSearchResult().toString() + "}";
        }
    }

    public static class Builder {
        private List<MigrationFailure> mMigrationFailures = new ArrayList<MigrationFailure>();
        private ArrayList<String> mDeletedTypes = new ArrayList();
        private ArrayList<String> mMigratedTypes = new ArrayList();
        private ArrayList<String> mIncompatibleTypes = new ArrayList();
        private boolean mBuilt = false;

        public Builder addMigrationFailures(Collection<MigrationFailure> migrationFailures) {
            Objects.requireNonNull(migrationFailures);
            this.resetIfBuilt();
            this.mMigrationFailures.addAll(migrationFailures);
            return this;
        }

        public Builder addMigrationFailure(MigrationFailure migrationFailure) {
            Objects.requireNonNull(migrationFailure);
            this.resetIfBuilt();
            this.mMigrationFailures.add(migrationFailure);
            return this;
        }

        public Builder addDeletedTypes(Collection<String> deletedTypes) {
            Objects.requireNonNull(deletedTypes);
            this.resetIfBuilt();
            this.mDeletedTypes.addAll(deletedTypes);
            return this;
        }

        public Builder addDeletedType(String deletedType) {
            Objects.requireNonNull(deletedType);
            this.resetIfBuilt();
            this.mDeletedTypes.add(deletedType);
            return this;
        }

        public Builder addIncompatibleTypes(Collection<String> incompatibleTypes) {
            Objects.requireNonNull(incompatibleTypes);
            this.resetIfBuilt();
            this.mIncompatibleTypes.addAll(incompatibleTypes);
            return this;
        }

        public Builder addIncompatibleType(String incompatibleType) {
            Objects.requireNonNull(incompatibleType);
            this.resetIfBuilt();
            this.mIncompatibleTypes.add(incompatibleType);
            return this;
        }

        public Builder addMigratedTypes(Collection<String> migratedTypes) {
            Objects.requireNonNull(migratedTypes);
            this.resetIfBuilt();
            this.mMigratedTypes.addAll(migratedTypes);
            return this;
        }

        public Builder addMigratedType(String migratedType) {
            Objects.requireNonNull(migratedType);
            this.resetIfBuilt();
            this.mMigratedTypes.add(migratedType);
            return this;
        }

        public SetSchemaResponse build() {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList(SetSchemaResponse.INCOMPATIBLE_TYPES_FIELD, this.mIncompatibleTypes);
            bundle.putStringArrayList(SetSchemaResponse.DELETED_TYPES_FIELD, this.mDeletedTypes);
            bundle.putStringArrayList(SetSchemaResponse.MIGRATED_TYPES_FIELD, this.mMigratedTypes);
            this.mBuilt = true;
            return new SetSchemaResponse(bundle, this.mMigrationFailures);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mMigrationFailures = new ArrayList<MigrationFailure>(this.mMigrationFailures);
                this.mDeletedTypes = new ArrayList<String>(this.mDeletedTypes);
                this.mMigratedTypes = new ArrayList<String>(this.mMigratedTypes);
                this.mIncompatibleTypes = new ArrayList<String>(this.mIncompatibleTypes);
                this.mBuilt = false;
            }
        }
    }
}

