/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.app.appsearch.AppSearchResult;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class AppSearchResultParcel<ValueType>
implements Parcelable {
    private final AppSearchResult<ValueType> mResult;
    public static final Parcelable.Creator<AppSearchResultParcel<?>> CREATOR = new Parcelable.Creator<AppSearchResultParcel<?>>(){

        @Override
        public AppSearchResultParcel<?> createFromParcel(Parcel in) {
            return new AppSearchResultParcel(in);
        }

        public AppSearchResultParcel<?>[] newArray(int size) {
            return new AppSearchResultParcel[size];
        }
    };

    public AppSearchResultParcel(AppSearchResult<ValueType> result) {
        this.mResult = Objects.requireNonNull(result);
    }

    private AppSearchResultParcel(Parcel in) {
        int resultCode = in.readInt();
        Object resultValue = in.readValue(null);
        String errorMessage = in.readString();
        this.mResult = resultCode == 0 ? AppSearchResult.newSuccessfulResult(resultValue) : AppSearchResult.newFailedResult(resultCode, errorMessage);
    }

    public AppSearchResult<ValueType> getResult() {
        return this.mResult;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mResult.getResultCode());
        if (this.mResult.isSuccess()) {
            dest.writeValue(this.mResult.getResultValue());
        } else {
            dest.writeValue(null);
        }
        dest.writeString(this.mResult.getErrorMessage());
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

