/*
 * Decompiled with CFR 0.152.
 */
package android.app.assist;

import android.annotation.SystemApi;
import android.os.IBinder;
import android.os.Parcel;
import com.android.internal.annotations.Immutable;

@SystemApi
@Immutable
public class ActivityId {
    private final int mTaskId;
    private final IBinder mActivityId;

    public ActivityId(int taskId, IBinder activityId) {
        this.mTaskId = taskId;
        this.mActivityId = activityId;
    }

    public ActivityId(Parcel source) {
        this.mTaskId = source.readInt();
        this.mActivityId = source.readStrongBinder();
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public IBinder getToken() {
        return this.mActivityId;
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeInt(this.mTaskId);
        dest.writeStrongBinder(this.mActivityId);
    }

    public String toString() {
        return "ActivityId { taskId = " + this.mTaskId + ", activityId = " + this.mActivityId + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityId that = (ActivityId)o;
        if (this.mTaskId != that.mTaskId) {
            return false;
        }
        return this.mActivityId != null ? this.mActivityId.equals(that.mActivityId) : that.mActivityId == null;
    }

    public int hashCode() {
        int result = this.mTaskId;
        result = 31 * result + (this.mActivityId != null ? this.mActivityId.hashCode() : 0);
        return result;
    }
}

