/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataOutput {
    private final long mQuota;
    private final int mTransportFlags;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    long mBackupWriter;

    @SystemApi
    public BackupDataOutput(FileDescriptor fd) {
        this(fd, -1L, 0);
    }

    @SystemApi
    public BackupDataOutput(FileDescriptor fd, long quota) {
        this(fd, quota, 0);
    }

    public BackupDataOutput(FileDescriptor fd, long quota, int transportFlags) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.mQuota = quota;
        this.mTransportFlags = transportFlags;
        this.mBackupWriter = BackupDataOutput.ctor(fd);
        if (this.mBackupWriter == 0L) {
            throw new RuntimeException("Native initialization failed with fd=" + fd);
        }
    }

    public long getQuota() {
        return this.mQuota;
    }

    public int getTransportFlags() {
        return this.mTransportFlags;
    }

    public int writeEntityHeader(String key, int dataSize) throws IOException {
        int result = BackupDataOutput.writeEntityHeader_native(this.mBackupWriter, key, dataSize);
        if (result >= 0) {
            return result;
        }
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public int writeEntityData(byte[] data, int size) throws IOException {
        int result = BackupDataOutput.writeEntityData_native(this.mBackupWriter, data, size);
        if (result >= 0) {
            return result;
        }
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public void setKeyPrefix(String keyPrefix) {
        BackupDataOutput.setKeyPrefix_native(this.mBackupWriter, keyPrefix);
    }

    protected void finalize() throws Throwable {
        try {
            BackupDataOutput.dtor(this.mBackupWriter);
        }
        finally {
            super.finalize();
        }
    }

    private static long ctor(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeL("android.app.backup.BackupDataOutput#ctor(Ljava/io/FileDescriptor;)J", true, null);
    }

    private static void dtor(long l) {
        OverrideMethod.invokeV("android.app.backup.BackupDataOutput#dtor(J)V", true, null);
    }

    private static int writeEntityHeader_native(long l, String string2, int n) {
        return OverrideMethod.invokeI("android.app.backup.BackupDataOutput#writeEntityHeader_native(JLjava/lang/String;I)I", true, null);
    }

    private static int writeEntityData_native(long l, byte[] byArray, int n) {
        return OverrideMethod.invokeI("android.app.backup.BackupDataOutput#writeEntityData_native(J[BI)I", true, null);
    }

    private static void setKeyPrefix_native(long l, String string2) {
        OverrideMethod.invokeV("android.app.backup.BackupDataOutput#setKeyPrefix_native(JLjava/lang/String;)V", true, null);
    }
}

