/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IFullBackupRestoreObserver
extends IInterface {
    public void onStartBackup() throws RemoteException;

    public void onBackupPackage(String var1) throws RemoteException;

    public void onEndBackup() throws RemoteException;

    public void onStartRestore() throws RemoteException;

    public void onRestorePackage(String var1) throws RemoteException;

    public void onEndRestore() throws RemoteException;

    public void onTimeout() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFullBackupRestoreObserver {
        public static final String DESCRIPTOR = "android.app.backup.IFullBackupRestoreObserver";
        static final int TRANSACTION_onStartBackup = 1;
        static final int TRANSACTION_onBackupPackage = 2;
        static final int TRANSACTION_onEndBackup = 3;
        static final int TRANSACTION_onStartRestore = 4;
        static final int TRANSACTION_onRestorePackage = 5;
        static final int TRANSACTION_onEndRestore = 6;
        static final int TRANSACTION_onTimeout = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IFullBackupRestoreObserver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IFullBackupRestoreObserver) {
                return (IFullBackupRestoreObserver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStartBackup";
                }
                case 2: {
                    return "onBackupPackage";
                }
                case 3: {
                    return "onEndBackup";
                }
                case 4: {
                    return "onStartRestore";
                }
                case 5: {
                    return "onRestorePackage";
                }
                case 6: {
                    return "onEndRestore";
                }
                case 7: {
                    return "onTimeout";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.onStartBackup();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onBackupPackage(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onEndBackup();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.onStartRestore();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onRestorePackage(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.onEndRestore();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.onTimeout();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IFullBackupRestoreObserver impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IFullBackupRestoreObserver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IFullBackupRestoreObserver {
            private IBinder mRemote;
            public static IFullBackupRestoreObserver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onStartBackup() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartBackup();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackupPackage(String name) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBackupPackage(name);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onEndBackup() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEndBackup();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onStartRestore() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartRestore();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRestorePackage(String name) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRestorePackage(name);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onEndRestore() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEndRestore();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onTimeout() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTimeout();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFullBackupRestoreObserver {
        @Override
        public void onStartBackup() throws RemoteException {
        }

        @Override
        public void onBackupPackage(String name) throws RemoteException {
        }

        @Override
        public void onEndBackup() throws RemoteException {
        }

        @Override
        public void onStartRestore() throws RemoteException {
        }

        @Override
        public void onRestorePackage(String name) throws RemoteException {
        }

        @Override
        public void onEndRestore() throws RemoteException {
        }

        @Override
        public void onTimeout() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

