/*
 * Decompiled with CFR 0.152.
 */
package android.app.compat;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.compat.ChangeIdStateCache;
import android.app.compat.ChangeIdStateQuery;
import android.app.compat.PackageOverride;
import android.compat.Compatibility;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import com.android.internal.compat.CompatibilityOverrideConfig;
import com.android.internal.compat.CompatibilityOverridesToRemoveConfig;
import com.android.internal.compat.IPlatformCompat;
import java.util.Map;
import java.util.Set;

@SystemApi
public class CompatChanges {
    private static final ChangeIdStateCache QUERY_CACHE = new ChangeIdStateCache();

    private CompatChanges() {
    }

    public static boolean isChangeEnabled(long changeId) {
        return Compatibility.isChangeEnabled(changeId);
    }

    @RequiresPermission(allOf={"android.permission.READ_COMPAT_CHANGE_CONFIG", "android.permission.LOG_COMPAT_CHANGE"})
    public static boolean isChangeEnabled(long changeId, String packageName, UserHandle user) {
        return (Boolean)QUERY_CACHE.query(ChangeIdStateQuery.byPackageName(changeId, packageName, user.getIdentifier()));
    }

    @RequiresPermission(allOf={"android.permission.READ_COMPAT_CHANGE_CONFIG", "android.permission.LOG_COMPAT_CHANGE"})
    public static boolean isChangeEnabled(long changeId, int uid) {
        return (Boolean)QUERY_CACHE.query(ChangeIdStateQuery.byUid(changeId, uid));
    }

    @RequiresPermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public static void putPackageOverrides(String packageName, Map<Long, PackageOverride> overrides) {
        IPlatformCompat platformCompat = IPlatformCompat.Stub.asInterface(ServiceManager.getService("platform_compat"));
        CompatibilityOverrideConfig config = new CompatibilityOverrideConfig(overrides);
        try {
            platformCompat.putOverridesOnReleaseBuilds(config, packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public static void removePackageOverrides(String packageName, Set<Long> overridesToRemove) {
        IPlatformCompat platformCompat = IPlatformCompat.Stub.asInterface(ServiceManager.getService("platform_compat"));
        CompatibilityOverridesToRemoveConfig config = new CompatibilityOverridesToRemoveConfig(overridesToRemove);
        try {
            platformCompat.removeOverridesOnReleaseBuilds(config, packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }
}

