/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.SystemApi;
import android.app.smartspace.SmartspaceTarget;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class SmartspaceTargetEvent
implements Parcelable {
    public static final int EVENT_TARGET_INTERACTION = 1;
    public static final int EVENT_TARGET_SHOWN = 2;
    public static final int EVENT_TARGET_HIDDEN = 3;
    public static final int EVENT_TARGET_DISMISS = 4;
    public static final int EVENT_TARGET_BLOCK = 5;
    public static final int EVENT_UI_SURFACE_SHOWN = 6;
    public static final int EVENT_UI_SURFACE_HIDDEN = 7;
    public static final Parcelable.Creator<SmartspaceTargetEvent> CREATOR = new Parcelable.Creator<SmartspaceTargetEvent>(){

        @Override
        public SmartspaceTargetEvent createFromParcel(Parcel parcel) {
            return new SmartspaceTargetEvent(parcel);
        }

        public SmartspaceTargetEvent[] newArray(int size) {
            return new SmartspaceTargetEvent[size];
        }
    };
    private final SmartspaceTarget mSmartspaceTarget;
    private final String mSmartspaceActionId;
    private final int mEventType;

    private SmartspaceTargetEvent(SmartspaceTarget smartspaceTarget, String smartspaceActionId, int eventType) {
        this.mSmartspaceTarget = smartspaceTarget;
        this.mSmartspaceActionId = smartspaceActionId;
        this.mEventType = eventType;
    }

    private SmartspaceTargetEvent(Parcel parcel) {
        this.mSmartspaceTarget = (SmartspaceTarget)parcel.readParcelable(null);
        this.mSmartspaceActionId = parcel.readString();
        this.mEventType = parcel.readInt();
    }

    public SmartspaceTarget getSmartspaceTarget() {
        return this.mSmartspaceTarget;
    }

    public String getSmartspaceActionId() {
        return this.mSmartspaceActionId;
    }

    public int getEventType() {
        return this.mEventType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mSmartspaceTarget, flags);
        dest.writeString(this.mSmartspaceActionId);
        dest.writeInt(this.mEventType);
    }

    public String toString() {
        return "SmartspaceTargetEvent{mSmartspaceTarget=" + this.mSmartspaceTarget + ", mSmartspaceActionId='" + this.mSmartspaceActionId + '\'' + ", mEventType=" + this.mEventType + '}';
    }

    @SystemApi
    public static class Builder {
        private final int mEventType;
        private SmartspaceTarget mSmartspaceTarget;
        private String mSmartspaceActionId;

        public Builder(int eventType) {
            this.mEventType = eventType;
        }

        public Builder setSmartspaceTarget(SmartspaceTarget smartspaceTarget) {
            this.mSmartspaceTarget = smartspaceTarget;
            return this;
        }

        public Builder setSmartspaceActionId(String smartspaceActionId) {
            this.mSmartspaceActionId = smartspaceActionId;
            return this;
        }

        public SmartspaceTargetEvent build() {
            return new SmartspaceTargetEvent(this.mSmartspaceTarget, this.mSmartspaceActionId, this.mEventType);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }
}

