/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.app.time.ExternalTimeSuggestion;
import android.app.time.TimeCapabilitiesAndConfig;
import android.app.time.TimeConfiguration;
import android.app.timedetector.GnssTimeSuggestion;
import android.app.timedetector.ManualTimeSuggestion;
import android.app.timedetector.NetworkTimeSuggestion;
import android.app.timedetector.TelephonyTimeSuggestion;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITimeDetectorService
extends IInterface {
    public static final String DESCRIPTOR = "android.app.timedetector.ITimeDetectorService";

    public TimeCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException;

    public boolean updateConfiguration(TimeConfiguration var1) throws RemoteException;

    public void suggestExternalTime(ExternalTimeSuggestion var1) throws RemoteException;

    public void suggestGnssTime(GnssTimeSuggestion var1) throws RemoteException;

    public boolean suggestManualTime(ManualTimeSuggestion var1) throws RemoteException;

    public void suggestNetworkTime(NetworkTimeSuggestion var1) throws RemoteException;

    public void suggestTelephonyTime(TelephonyTimeSuggestion var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITimeDetectorService {
        static final int TRANSACTION_getCapabilitiesAndConfig = 1;
        static final int TRANSACTION_updateConfiguration = 2;
        static final int TRANSACTION_suggestExternalTime = 3;
        static final int TRANSACTION_suggestGnssTime = 4;
        static final int TRANSACTION_suggestManualTime = 5;
        static final int TRANSACTION_suggestNetworkTime = 6;
        static final int TRANSACTION_suggestTelephonyTime = 7;

        public Stub() {
            this.attachInterface(this, ITimeDetectorService.DESCRIPTOR);
        }

        public static ITimeDetectorService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITimeDetectorService.DESCRIPTOR);
            if (iin != null && iin instanceof ITimeDetectorService) {
                return (ITimeDetectorService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getCapabilitiesAndConfig";
                }
                case 2: {
                    return "updateConfiguration";
                }
                case 3: {
                    return "suggestExternalTime";
                }
                case 4: {
                    return "suggestGnssTime";
                }
                case 5: {
                    return "suggestManualTime";
                }
                case 6: {
                    return "suggestNetworkTime";
                }
                case 7: {
                    return "suggestTelephonyTime";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITimeDetectorService.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    TimeCapabilitiesAndConfig _result = this.getCapabilitiesAndConfig();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    TimeConfiguration _arg0 = 0 != data.readInt() ? TimeConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.updateConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ExternalTimeSuggestion _arg0 = 0 != data.readInt() ? ExternalTimeSuggestion.CREATOR.createFromParcel(data) : null;
                    this.suggestExternalTime(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    GnssTimeSuggestion _arg0 = 0 != data.readInt() ? GnssTimeSuggestion.CREATOR.createFromParcel(data) : null;
                    this.suggestGnssTime(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ManualTimeSuggestion _arg0 = 0 != data.readInt() ? ManualTimeSuggestion.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.suggestManualTime(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    NetworkTimeSuggestion _arg0 = 0 != data.readInt() ? NetworkTimeSuggestion.CREATOR.createFromParcel(data) : null;
                    this.suggestNetworkTime(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    TelephonyTimeSuggestion _arg0 = 0 != data.readInt() ? TelephonyTimeSuggestion.CREATOR.createFromParcel(data) : null;
                    this.suggestTelephonyTime(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITimeDetectorService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITimeDetectorService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITimeDetectorService {
            private IBinder mRemote;
            public static ITimeDetectorService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITimeDetectorService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TimeCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException {
                TimeCapabilitiesAndConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        TimeCapabilitiesAndConfig timeCapabilitiesAndConfig = Stub.getDefaultImpl().getCapabilitiesAndConfig();
                        return timeCapabilitiesAndConfig;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? TimeCapabilitiesAndConfig.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateConfiguration(TimeConfiguration timeConfiguration) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    if (timeConfiguration != null) {
                        _data.writeInt(1);
                        timeConfiguration.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().updateConfiguration(timeConfiguration);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    if (timeSuggestion != null) {
                        _data.writeInt(1);
                        timeSuggestion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().suggestExternalTime(timeSuggestion);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestGnssTime(GnssTimeSuggestion timeSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    if (timeSuggestion != null) {
                        _data.writeInt(1);
                        timeSuggestion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().suggestGnssTime(timeSuggestion);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean suggestManualTime(ManualTimeSuggestion timeSuggestion) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    if (timeSuggestion != null) {
                        _data.writeInt(1);
                        timeSuggestion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().suggestManualTime(timeSuggestion);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestNetworkTime(NetworkTimeSuggestion timeSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    if (timeSuggestion != null) {
                        _data.writeInt(1);
                        timeSuggestion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().suggestNetworkTime(timeSuggestion);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestTelephonyTime(TelephonyTimeSuggestion timeSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    if (timeSuggestion != null) {
                        _data.writeInt(1);
                        timeSuggestion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().suggestTelephonyTime(timeSuggestion);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITimeDetectorService {
        @Override
        public TimeCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException {
            return null;
        }

        @Override
        public boolean updateConfiguration(TimeConfiguration timeConfiguration) throws RemoteException {
            return false;
        }

        @Override
        public void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) throws RemoteException {
        }

        @Override
        public void suggestGnssTime(GnssTimeSuggestion timeSuggestion) throws RemoteException {
        }

        @Override
        public boolean suggestManualTime(ManualTimeSuggestion timeSuggestion) throws RemoteException {
            return false;
        }

        @Override
        public void suggestNetworkTime(NetworkTimeSuggestion timeSuggestion) throws RemoteException {
        }

        @Override
        public void suggestTelephonyTime(TelephonyTimeSuggestion timeSuggestion) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

