/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.annotation.RequiresPermission;
import android.app.timedetector.GnssTimeSuggestion;
import android.app.timedetector.ManualTimeSuggestion;
import android.app.timedetector.NetworkTimeSuggestion;
import android.app.timedetector.TelephonyTimeSuggestion;
import android.os.SystemClock;
import android.os.TimestampedValue;

public interface TimeDetector {
    public static final String SHELL_COMMAND_SERVICE_NAME = "time_detector";
    public static final String SHELL_COMMAND_IS_AUTO_DETECTION_ENABLED = "is_auto_detection_enabled";

    public static ManualTimeSuggestion createManualTimeSuggestion(long when, String why) {
        TimestampedValue<Long> utcTime = new TimestampedValue<Long>(SystemClock.elapsedRealtime(), when);
        ManualTimeSuggestion manualTimeSuggestion = new ManualTimeSuggestion(utcTime);
        manualTimeSuggestion.addDebugInfo(why);
        return manualTimeSuggestion;
    }

    @RequiresPermission(value="android.permission.SUGGEST_TELEPHONY_TIME_AND_ZONE")
    public void suggestTelephonyTime(TelephonyTimeSuggestion var1);

    @RequiresPermission(value="android.permission.SUGGEST_MANUAL_TIME_AND_ZONE")
    public boolean suggestManualTime(ManualTimeSuggestion var1);

    @RequiresPermission(value="android.permission.SET_TIME")
    public void suggestNetworkTime(NetworkTimeSuggestion var1);

    @RequiresPermission(value="android.permission.SET_TIME")
    public void suggestGnssTime(GnssTimeSuggestion var1);
}

