/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PropertyInvalidatedCache;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.OobData;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Attributable;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.UUID;

public class BluetoothDevice
implements Parcelable,
Attributable {
    private static final String TAG = "BluetoothDevice";
    private static final boolean DBG = false;
    private static final int CONNECTION_STATE_DISCONNECTED = 0;
    private static final int CONNECTION_STATE_CONNECTED = 1;
    private static final int CONNECTION_STATE_ENCRYPTED_BREDR = 2;
    private static final int CONNECTION_STATE_ENCRYPTED_LE = 4;
    public static final int ERROR = Integer.MIN_VALUE;
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_FOUND = "android.bluetooth.device.action.FOUND";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ALIAS_CHANGED = "android.bluetooth.device.action.ALIAS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BATTERY_LEVEL_CHANGED = "android.bluetooth.device.action.BATTERY_LEVEL_CHANGED";
    public static final String EXTRA_BATTERY_LEVEL = "android.bluetooth.device.extra.BATTERY_LEVEL";
    public static final int BATTERY_LEVEL_UNKNOWN = -1;
    public static final int BATTERY_LEVEL_BLUETOOTH_OFF = -100;
    public static final String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static final String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static final String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static final String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static final String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static final String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    public static final int BOND_NONE = 10;
    public static final int BOND_BONDING = 11;
    public static final int BOND_BONDED = 12;
    @UnsupportedAppUsage
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static final String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static final String EXTRA_PAIRING_KEY = "android.bluetooth.device.extra.PAIRING_KEY";
    public static final String EXTRA_PAIRING_INITIATOR = "android.bluetooth.device.extra.PAIRING_INITIATOR";
    public static final int EXTRA_PAIRING_INITIATOR_FOREGROUND = 1;
    public static final int EXTRA_PAIRING_INITIATOR_BACKGROUND = 2;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_CLASSIC = 1;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_DUAL = 3;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_SDP_RECORD = "android.bluetooth.device.action.SDP_RECORD";
    @SystemApi
    public static final int METADATA_MAX_LENGTH = 2048;
    @SystemApi
    public static final int METADATA_MANUFACTURER_NAME = 0;
    @SystemApi
    public static final int METADATA_MODEL_NAME = 1;
    @SystemApi
    public static final int METADATA_SOFTWARE_VERSION = 2;
    @SystemApi
    public static final int METADATA_HARDWARE_VERSION = 3;
    @SystemApi
    public static final int METADATA_COMPANION_APP = 4;
    @SystemApi
    public static final int METADATA_MAIN_ICON = 5;
    @SystemApi
    public static final int METADATA_IS_UNTETHERED_HEADSET = 6;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_ICON = 7;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_ICON = 8;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_ICON = 9;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_BATTERY = 10;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_BATTERY = 11;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_BATTERY = 12;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_CHARGING = 13;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_CHARGING = 14;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_CHARGING = 15;
    @SystemApi
    public static final int METADATA_ENHANCED_SETTINGS_UI_URI = 16;
    @SystemApi
    public static final int METADATA_DEVICE_TYPE = 17;
    @SystemApi
    public static final int METADATA_MAIN_BATTERY = 18;
    @SystemApi
    public static final int METADATA_MAIN_CHARGING = 19;
    @SystemApi
    public static final int METADATA_MAIN_LOW_BATTERY_THRESHOLD = 20;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_LOW_BATTERY_THRESHOLD = 21;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_LOW_BATTERY_THRESHOLD = 22;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_LOW_BATTERY_THRESHOLD = 23;
    @SystemApi
    public static final String DEVICE_TYPE_DEFAULT = "Default";
    @SystemApi
    public static final String DEVICE_TYPE_WATCH = "Watch";
    @SystemApi
    public static final String DEVICE_TYPE_UNTETHERED_HEADSET = "Untethered Headset";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_UUID = "android.bluetooth.device.action.UUID";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MAS_INSTANCE = "android.bluetooth.device.action.MAS_INSTANCE";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage
    public static final String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_ACCESS_REQUEST = "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_ACCESS_REPLY = "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_ACCESS_CANCEL = "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_SILENCE_MODE_CHANGED = "android.bluetooth.device.action.SILENCE_MODE_CHANGED";
    public static final String EXTRA_ACCESS_REQUEST_TYPE = "android.bluetooth.device.extra.ACCESS_REQUEST_TYPE";
    public static final int REQUEST_TYPE_PROFILE_CONNECTION = 1;
    public static final int REQUEST_TYPE_PHONEBOOK_ACCESS = 2;
    public static final int REQUEST_TYPE_MESSAGE_ACCESS = 3;
    public static final int REQUEST_TYPE_SIM_ACCESS = 4;
    public static final String EXTRA_PACKAGE_NAME = "android.bluetooth.device.extra.PACKAGE_NAME";
    public static final String EXTRA_CLASS_NAME = "android.bluetooth.device.extra.CLASS_NAME";
    public static final String EXTRA_CONNECTION_ACCESS_RESULT = "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT";
    public static final int CONNECTION_ACCESS_YES = 1;
    public static final int CONNECTION_ACCESS_NO = 2;
    public static final String EXTRA_ALWAYS_ALLOWED = "android.bluetooth.device.extra.ALWAYS_ALLOWED";
    public static final int BOND_SUCCESS = 0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_AUTH_TIMEOUT = 6;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    public static final int UNBOND_REASON_REMOVED = 9;
    public static final int PAIRING_VARIANT_PIN = 0;
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    public static final int PAIRING_VARIANT_CONSENT = 3;
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    public static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    public static final int PAIRING_VARIANT_OOB_CONSENT = 6;
    public static final int PAIRING_VARIANT_PIN_16_DIGITS = 7;
    public static final String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    public static final String EXTRA_SDP_RECORD = "android.bluetooth.device.extra.SDP_RECORD";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_SDP_SEARCH_STATUS = "android.bluetooth.device.extra.SDP_SEARCH_STATUS";
    @SystemApi
    public static final int ACCESS_UNKNOWN = 0;
    @SystemApi
    public static final int ACCESS_ALLOWED = 1;
    @SystemApi
    public static final int ACCESS_REJECTED = 2;
    public static final int TRANSPORT_AUTO = 0;
    public static final int TRANSPORT_BREDR = 1;
    public static final int TRANSPORT_LE = 2;
    public static final int PHY_LE_1M = 1;
    public static final int PHY_LE_2M = 2;
    public static final int PHY_LE_CODED = 3;
    public static final int PHY_LE_1M_MASK = 1;
    public static final int PHY_LE_2M_MASK = 2;
    public static final int PHY_LE_CODED_MASK = 4;
    public static final int PHY_OPTION_NO_PREFERRED = 0;
    public static final int PHY_OPTION_S2 = 1;
    public static final int PHY_OPTION_S8 = 2;
    public static final String EXTRA_MAS_INSTANCE = "android.bluetooth.device.extra.MAS_INSTANCE";
    public static final int ADDRESS_TYPE_PUBLIC = 0;
    public static final int ADDRESS_TYPE_RANDOM = 1;
    private static volatile IBluetooth sService;
    private final String mAddress;
    private final int mAddressType;
    private AttributionSource mAttributionSource;
    static IBluetoothManagerCallback sStateChangeCallback;
    public static final Parcelable.Creator<BluetoothDevice> CREATOR;
    private static final String BLUETOOTH_BONDING_CACHE_PROPERTY = "cache_key.bluetooth.get_bond_state";
    private final PropertyInvalidatedCache<BluetoothDevice, Integer> mBluetoothBondCache = new PropertyInvalidatedCache<BluetoothDevice, Integer>(8, "cache_key.bluetooth.get_bond_state"){

        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        protected Integer recompute(BluetoothDevice query) {
            try {
                return sService.getBondState(query, BluetoothDevice.this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    static IBluetooth getService() {
        Class<BluetoothDevice> clazz = BluetoothDevice.class;
        synchronized (BluetoothDevice.class) {
            if (sService == null) {
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                sService = adapter.getBluetoothService(sStateChangeCallback);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sService;
        }
    }

    @UnsupportedAppUsage
    BluetoothDevice(String address) {
        BluetoothDevice.getService();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            throw new IllegalArgumentException(address + " is not a valid Bluetooth address");
        }
        this.mAddress = address;
        this.mAddressType = 0;
        this.mAttributionSource = BluetoothManager.resolveAttributionSource(null);
    }

    @Override
    public void setAttributionSource(AttributionSource attributionSource) {
        this.mAttributionSource = attributionSource;
    }

    public void prepareToEnterProcess(AttributionSource attributionSource) {
        this.setAttributionSource(attributionSource);
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothDevice) {
            return this.mAddress.equals(((BluetoothDevice)o).getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    public String toString() {
        return this.mAddress;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAddress);
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getAnonymizedAddress() {
        return "XX:XX:XX" + this.getAddress().substring(8);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device name");
            return null;
        }
        try {
            String name = service.getRemoteName(this, this.mAttributionSource);
            if (name != null) {
                return name.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
            }
            return null;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getType() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device type");
            return 0;
        }
        try {
            return service.getRemoteType(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getAlias() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device Alias");
            return null;
        }
        try {
            String alias = service.getRemoteAliasWithAttribution(this, this.mAttributionSource);
            if (alias == null) {
                return this.getName();
            }
            return alias.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int setAlias(String alias) {
        if (alias != null && alias.isEmpty()) {
            throw new IllegalArgumentException("alias cannot be the empty string");
        }
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device name");
            return 1;
        }
        try {
            return service.setRemoteAlias(this, alias, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBatteryLevel() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "Bluetooth disabled. Cannot get remote device battery level");
            return -100;
        }
        try {
            return service.getBatteryLevel(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond() {
        return this.createBond(0);
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond(int transport) {
        return this.createBondInternal(transport, null, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBondOutOfBand(int transport, OobData remoteP192Data, OobData remoteP256Data) {
        if (remoteP192Data == null && remoteP256Data == null) {
            throw new IllegalArgumentException("One or both arguments for the OOB data types are required to not be null.  Please use createBond() instead if you do not have OOB data to pass.");
        }
        return this.createBondInternal(transport, remoteP192Data, remoteP256Data);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private boolean createBondInternal(int transport, OobData remoteP192Data, OobData remoteP256Data) {
        IBluetooth service = sService;
        if (service == null) {
            Log.w(TAG, "BT not enabled, createBondOutOfBand failed");
            return false;
        }
        try {
            return service.createBond(this, transport, remoteP192Data, remoteP256Data, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isBondingInitiatedLocally() {
        IBluetooth service = sService;
        if (service == null) {
            Log.w(TAG, "BT not enabled, isBondingInitiatedLocally failed");
            return false;
        }
        try {
            return service.isBondingInitiatedLocally(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean cancelBondProcess() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot cancel Remote Device bond");
            return false;
        }
        try {
            Log.i(TAG, "cancelBondProcess() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            return service.cancelBondProcess(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot remove Remote Device bond");
            return false;
        }
        try {
            Log.i(TAG, "removeBond() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            return service.removeBond(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public void disableBluetoothGetBondStateCache() {
        this.mBluetoothBondCache.disableLocal();
    }

    public static void invalidateBluetoothGetBondStateCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_BONDING_CACHE_PROPERTY);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public int getBondState() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get bond state");
            return 10;
        }
        try {
            return this.mBluetoothBondCache.query(this);
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, "", e);
            return 10;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean canBondWithoutDialog() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot check if we can skip pairing dialog");
            return false;
        }
        try {
            return service.canBondWithoutDialog(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isConnected() {
        IBluetooth service = sService;
        if (service == null) {
            return false;
        }
        try {
            return service.getConnectionStateWithAttribution(this, this.mAttributionSource) != 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isEncrypted() {
        IBluetooth service = sService;
        if (service == null) {
            return false;
        }
        try {
            return service.getConnectionStateWithAttribution(this, this.mAttributionSource) > 1;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothClass getBluetoothClass() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get Bluetooth Class");
            return null;
        }
        try {
            int classInt = service.getRemoteClass(this, this.mAttributionSource);
            if (classInt == -16777216) {
                return null;
            }
            return new BluetoothClass(classInt);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getUuids() {
        IBluetooth service = sService;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get remote device Uuids");
            return null;
        }
        try {
            return service.getRemoteUuids(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean fetchUuidsWithSdp() {
        IBluetooth service = sService;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot fetchUuidsWithSdp");
            return false;
        }
        try {
            return service.fetchRemoteUuidsWithAttribution(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sdpSearch(ParcelUuid uuid) {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot query remote device sdp records");
            return false;
        }
        try {
            return service.sdpSearch(this, uuid, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(byte[] pin) {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device pin");
            return false;
        }
        try {
            return service.setPin(this, true, pin.length, pin, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(String pin) {
        byte[] pinBytes = BluetoothDevice.convertPinToBytes(pin);
        if (pinBytes == null) {
            return false;
        }
        return this.setPin(pinBytes);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPairingConfirmation(boolean confirm) {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot set pairing confirmation");
            return false;
        }
        try {
            return service.setPairingConfirmation(this, confirm, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean cancelPairing() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot cancel pairing");
            return false;
        }
        try {
            return service.cancelBondProcess(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    boolean isBluetoothEnabled() {
        boolean ret = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.isEnabled()) {
            ret = true;
        }
        return ret;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getPhonebookAccessPermission() {
        IBluetooth service = sService;
        if (service == null) {
            return 0;
        }
        try {
            return service.getPhonebookAccessPermission(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSilenceMode(boolean silence) {
        IBluetooth service = sService;
        if (service == null) {
            throw new IllegalStateException("Bluetooth is not turned ON");
        }
        try {
            return service.setSilenceMode(this, silence, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "setSilenceMode fail", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isInSilenceMode() {
        IBluetooth service = sService;
        if (service == null) {
            throw new IllegalStateException("Bluetooth is not turned ON");
        }
        try {
            return service.getSilenceMode(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "isInSilenceMode fail", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPhonebookAccessPermission(int value) {
        IBluetooth service = sService;
        if (service == null) {
            return false;
        }
        try {
            return service.setPhonebookAccessPermission(this, value, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMessageAccessPermission() {
        IBluetooth service = sService;
        if (service == null) {
            return 0;
        }
        try {
            return service.getMessageAccessPermission(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMessageAccessPermission(int value) {
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException(value + "is not a valid AccessPermission value");
        }
        IBluetooth service = sService;
        if (service == null) {
            return false;
        }
        try {
            return service.setMessageAccessPermission(this, value, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getSimAccessPermission() {
        IBluetooth service = sService;
        if (service == null) {
            return 0;
        }
        try {
            return service.getSimAccessPermission(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSimAccessPermission(int value) {
        IBluetooth service = sService;
        if (service == null) {
            return false;
        }
        try {
            return service.setSimAccessPermission(this, value, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createRfcommSocket(int channel) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, true, true, this, channel, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(3, -1, true, true, this, channel, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(3, -1, false, false, this, channel, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, true, true, this, -1, new ParcelUuid(uuid));
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, false, false, this, -1, new ParcelUuid(uuid));
    }

    @UnsupportedAppUsage(publicAlternatives="Use {@link #createInsecureRfcommSocketToServiceRecord} instead.")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureRfcommSocket(int port) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, false, false, this, port, null);
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createScoSocket() throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(2, -1, true, true, this, -1, null);
    }

    @UnsupportedAppUsage
    public static byte[] convertPinToBytes(String pin) {
        byte[] pinBytes;
        if (pin == null) {
            return null;
        }
        try {
            pinBytes = pin.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e(TAG, "UTF-8 not supported?!?");
            return null;
        }
        if (pinBytes.length <= 0 || pinBytes.length > 16) {
            return null;
        }
        return pinBytes;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        return this.connectGatt(context, autoConnect, callback, 0);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        return this.connectGatt(context, autoConnect, callback, transport, 1);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy) {
        return this.connectGatt(context, autoConnect, callback, transport, phy, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy, Handler handler) {
        return this.connectGatt(context, autoConnect, callback, transport, false, phy, handler);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, boolean opportunistic, int phy, Handler handler) {
        if (callback == null) {
            throw new NullPointerException("callback is null");
        }
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager managerService = adapter.getBluetoothManager();
        try {
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return null;
            }
            BluetoothGatt gatt = new BluetoothGatt(iGatt, this, transport, opportunistic, phy, this.mAttributionSource);
            gatt.connect(autoConnect, callback, handler);
            return gatt;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createL2capChannel(int psm) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createL2capChannel: Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(4, -1, true, true, this, psm, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureL2capChannel(int psm) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createInsecureL2capChannel: Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(4, -1, false, false, this, psm, null);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMetadata(int key, byte[] value) {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set metadata");
            return false;
        }
        if (value.length > 2048) {
            throw new IllegalArgumentException("value length is " + value.length + ", should not over " + 2048);
        }
        try {
            return service.setMetadata(this, key, value, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "setMetadata fail", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public byte[] getMetadata(int key) {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get metadata");
            return null;
        }
        try {
            return service.getMetadata(this, key, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "getMetadata fail", e);
            return null;
        }
    }

    public static int getMaxMetadataKey() {
        return 23;
    }

    static {
        sStateChangeCallback = new IBluetoothManagerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) throws RemoteException {
                Class<BluetoothDevice> clazz = BluetoothDevice.class;
                synchronized (BluetoothDevice.class) {
                    if (sService == null) {
                        sService = bluetoothService;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceDown() throws RemoteException {
                Class<BluetoothDevice> clazz = BluetoothDevice.class;
                synchronized (BluetoothDevice.class) {
                    sService = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void onBrEdrDown() {
            }

            public void onOobData(int transport, OobData oobData) {
            }
        };
        CREATOR = new Parcelable.Creator<BluetoothDevice>(){

            @Override
            public BluetoothDevice createFromParcel(Parcel in) {
                return new BluetoothDevice(in.readString());
            }

            public BluetoothDevice[] newArray(int size) {
                return new BluetoothDevice[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetAliasReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AddressType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AccessPermission {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataKey {
    }
}

