/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothAvrcpPlayerSettings;
import android.bluetooth.BluetoothDevice;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothAvrcpController
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothAvrcpPlayerSettings getPlayerSettings(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendGroupNavigationCmd(BluetoothDevice var1, int var2, int var3, AttributionSource var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothAvrcpController {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothAvrcpController";
        static final int TRANSACTION_getConnectedDevices = 1;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 2;
        static final int TRANSACTION_getConnectionState = 3;
        static final int TRANSACTION_getPlayerSettings = 4;
        static final int TRANSACTION_setPlayerApplicationSetting = 5;
        static final int TRANSACTION_sendGroupNavigationCmd = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothAvrcpController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothAvrcpController) {
                return (IBluetoothAvrcpController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getConnectedDevices";
                }
                case 2: {
                    return "getDevicesMatchingConnectionStates";
                }
                case 3: {
                    return "getConnectionState";
                }
                case 4: {
                    return "getPlayerSettings";
                }
                case 5: {
                    return "setPlayerApplicationSetting";
                }
                case 6: {
                    return "sendGroupNavigationCmd";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    List<BluetoothDevice> _result = this.getConnectedDevices(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    List<BluetoothDevice> _result = this.getDevicesMatchingConnectionStates(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getConnectionState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    BluetoothAvrcpPlayerSettings _result = this.getPlayerSettings(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    BluetoothAvrcpPlayerSettings _arg0 = 0 != data.readInt() ? BluetoothAvrcpPlayerSettings.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setPlayerApplicationSetting(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.sendGroupNavigationCmd(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBluetoothAvrcpController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBluetoothAvrcpController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBluetoothAvrcpController {
            private IBinder mRemote;
            public static IBluetoothAvrcpController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getConnectedDevices(AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<BluetoothDevice> list = Stub.getDefaultImpl().getConnectedDevices(attributionSource);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(states);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<BluetoothDevice> list = Stub.getDefaultImpl().getDevicesMatchingConnectionStates(states, attributionSource);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConnectionState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getConnectionState(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothAvrcpPlayerSettings getPlayerSettings(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                BluetoothAvrcpPlayerSettings _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BluetoothAvrcpPlayerSettings bluetoothAvrcpPlayerSettings = Stub.getDefaultImpl().getPlayerSettings(device, attributionSource);
                        return bluetoothAvrcpPlayerSettings;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BluetoothAvrcpPlayerSettings.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings plAppSetting, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (plAppSetting != null) {
                        _data.writeInt(1);
                        plAppSetting.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setPlayerApplicationSetting(plAppSetting, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendGroupNavigationCmd(BluetoothDevice device, int keyCode, int keyState, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(keyCode);
                    _data.writeInt(keyState);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendGroupNavigationCmd(device, keyCode, keyState, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothAvrcpController {
        @Override
        public List<BluetoothDevice> getConnectedDevices(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int getConnectionState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public BluetoothAvrcpPlayerSettings getPlayerSettings(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings plAppSetting, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public void sendGroupNavigationCmd(BluetoothDevice device, int keyCode, int keyState, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

