/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.RemoteException;
import android.util.Log;

public class AdvertisingSet {
    private static final String TAG = "AdvertisingSet";
    private final IBluetoothGatt mGatt;
    private int mAdvertiserId;
    private AttributionSource mAttributionSource;

    AdvertisingSet(int advertiserId, IBluetoothManager bluetoothManager, AttributionSource attributionSource) {
        this.mAdvertiserId = advertiserId;
        this.mAttributionSource = attributionSource;
        try {
            this.mGatt = bluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            throw new IllegalStateException("Failed to get Bluetooth");
        }
    }

    void setAdvertiserId(int advertiserId) {
        this.mAdvertiserId = advertiserId;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void enableAdvertising(boolean enable, int duration, int maxExtendedAdvertisingEvents) {
        try {
            this.mGatt.enableAdvertisingSet(this.mAdvertiserId, enable, duration, maxExtendedAdvertisingEvents, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingData(AdvertiseData advertiseData) {
        try {
            this.mGatt.setAdvertisingData(this.mAdvertiserId, advertiseData, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setScanResponseData(AdvertiseData scanResponse) {
        try {
            this.mGatt.setScanResponseData(this.mAdvertiserId, scanResponse, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingParameters(AdvertisingSetParameters parameters) {
        try {
            this.mGatt.setAdvertisingParameters(this.mAdvertiserId, parameters, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters parameters) {
        try {
            this.mGatt.setPeriodicAdvertisingParameters(this.mAdvertiserId, parameters, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingData(AdvertiseData periodicData) {
        try {
            this.mGatt.setPeriodicAdvertisingData(this.mAdvertiserId, periodicData, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingEnabled(boolean enable) {
        try {
            this.mGatt.setPeriodicAdvertisingEnable(this.mAdvertiserId, enable, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getOwnAddress() {
        try {
            this.mGatt.getOwnAddress(this.mAdvertiserId, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresNoPermission
    public int getAdvertiserId() {
        return this.mAdvertiserId;
    }
}

