/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.NonNull;
import android.annotation.UserIdInt;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Date;
import java.util.Objects;

public class Association
implements Parcelable {
    private final int mUserId;
    private final String mDeviceMacAddress;
    private final String mPackageName;
    private final String mDeviceProfile;
    private final boolean mNotifyOnDeviceNearby;
    private final long mTimeApprovedMs;
    public static final Parcelable.Creator<Association> CREATOR = new Parcelable.Creator<Association>(){

        public Association[] newArray(int size) {
            return new Association[size];
        }

        @Override
        public Association createFromParcel(Parcel in) {
            return new Association(in);
        }
    };

    public int getUserId() {
        return this.mUserId;
    }

    private String timeApprovedMsToString() {
        return new Date(this.mTimeApprovedMs).toString();
    }

    public Association(int userId, String deviceMacAddress, String packageName, String deviceProfile, boolean notifyOnDeviceNearby, long timeApprovedMs) {
        this.mUserId = userId;
        AnnotationValidations.validate(UserIdInt.class, null, this.mUserId);
        this.mDeviceMacAddress = deviceMacAddress;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDeviceMacAddress);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mDeviceProfile = deviceProfile;
        this.mNotifyOnDeviceNearby = notifyOnDeviceNearby;
        this.mTimeApprovedMs = timeApprovedMs;
    }

    public String getDeviceMacAddress() {
        return this.mDeviceMacAddress;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getDeviceProfile() {
        return this.mDeviceProfile;
    }

    public boolean isNotifyOnDeviceNearby() {
        return this.mNotifyOnDeviceNearby;
    }

    public long getTimeApprovedMs() {
        return this.mTimeApprovedMs;
    }

    public String toString() {
        return "Association { userId = " + this.mUserId + ", deviceMacAddress = " + this.mDeviceMacAddress + ", packageName = " + this.mPackageName + ", deviceProfile = " + this.mDeviceProfile + ", notifyOnDeviceNearby = " + this.mNotifyOnDeviceNearby + ", timeApprovedMs = " + this.timeApprovedMsToString() + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Association that = (Association)o;
        return this.mUserId == that.mUserId && Objects.equals(this.mDeviceMacAddress, that.mDeviceMacAddress) && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mDeviceProfile, that.mDeviceProfile) && this.mNotifyOnDeviceNearby == that.mNotifyOnDeviceNearby && this.mTimeApprovedMs == that.mTimeApprovedMs;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mUserId;
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceMacAddress);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfile);
        _hash = 31 * _hash + Boolean.hashCode(this.mNotifyOnDeviceNearby);
        _hash = 31 * _hash + Long.hashCode(this.mTimeApprovedMs);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mNotifyOnDeviceNearby) {
            flg = (byte)(flg | 0x10);
        }
        if (this.mDeviceProfile != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mUserId);
        dest.writeString(this.mDeviceMacAddress);
        dest.writeString(this.mPackageName);
        if (this.mDeviceProfile != null) {
            dest.writeString(this.mDeviceProfile);
        }
        dest.writeLong(this.mTimeApprovedMs);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    Association(Parcel in) {
        byte flg = in.readByte();
        boolean notifyOnDeviceNearby = (flg & 0x10) != 0;
        int userId = in.readInt();
        String deviceMacAddress = in.readString();
        String packageName = in.readString();
        String deviceProfile = (flg & 8) == 0 ? null : in.readString();
        long timeApprovedMs = in.readLong();
        this.mUserId = userId;
        AnnotationValidations.validate(UserIdInt.class, null, this.mUserId);
        this.mDeviceMacAddress = deviceMacAddress;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDeviceMacAddress);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mDeviceProfile = deviceProfile;
        this.mNotifyOnDeviceNearby = notifyOnDeviceNearby;
        this.mTimeApprovedMs = timeApprovedMs;
    }

    @Deprecated
    private void __metadata() {
    }
}

