/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.companion.Association;
import android.companion.AssociationRequest;
import android.companion.DeviceNotAssociatedException;
import android.companion.ICompanionDeviceManager;
import android.companion.IFindDeviceCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.net.MacAddress;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class CompanionDeviceManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "CompanionDeviceManager";
    public static final String EXTRA_DEVICE = "android.companion.extra.DEVICE";
    public static final String COMPANION_DEVICE_DISCOVERY_PACKAGE_NAME = "com.android.companiondevicemanager";
    private final ICompanionDeviceManager mService;
    private final Context mContext;

    public CompanionDeviceManager(ICompanionDeviceManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_WATCH", conditional=true)
    public void associate(AssociationRequest request, Callback callback, Handler handler) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        try {
            this.mService.associate(request, new CallbackProxy(request, callback, Handler.mainIfNull(handler)), this.getCallingPackage());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociations(this.getCallingPackage(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disassociate(String deviceMacAddress) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.disassociate(deviceMacAddress, this.getCallingPackage());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            IntentSender intentSender = this.mService.requestNotificationAccess(component).getIntentSender();
            this.mContext.startIntentSender(intentSender, null, 0, 0, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IntentSender.SendIntentException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        try {
            return this.mService.hasNotificationAccess(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean isDeviceAssociatedForWifiConnection(String packageName, MacAddress macAddress, UserHandle user) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            return this.mService.isDeviceAssociatedForWifiConnection(packageName, macAddress.toString(), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public List<Association> getAllAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociationsForUser(this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, UserHandle user) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(deviceMacAddress, "device mac address cannot be null");
        Objects.requireNonNull(user, "user handle cannot be null");
        try {
            return this.mService.canPairWithoutPrompt(packageName, deviceMacAddress, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void startObservingDevicePresence(String deviceAddress) throws DeviceNotAssociatedException {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.registerDevicePresenceListenerService(this.mContext.getPackageName(), deviceAddress);
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void stopObservingDevicePresence(String deviceAddress) throws DeviceNotAssociatedException {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.unregisterDevicePresenceListenerService(this.mContext.getPackageName(), deviceAddress);
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ASSOCIATE_COMPANION_DEVICES")
    public void associate(String packageName, MacAddress macAddress, byte[] certificate) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        UserHandle user = Process.myUserHandle();
        try {
            this.mService.createAssociation(packageName, macAddress.toString(), user.getIdentifier(), certificate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean checkFeaturePresent() {
        boolean featurePresent;
        boolean bl = featurePresent = this.mService != null;
        if (!featurePresent) {
            // empty if block
        }
        return featurePresent;
    }

    private Activity getActivity() {
        return (Activity)this.mContext;
    }

    private String getCallingPackage() {
        return this.mContext.getPackageName();
    }

    private class CallbackProxy
    extends IFindDeviceCallback.Stub
    implements Application.ActivityLifecycleCallbacks {
        private Callback mCallback;
        private Handler mHandler;
        private AssociationRequest mRequest;
        final Object mLock = new Object();

        private CallbackProxy(AssociationRequest request, Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
            this.mRequest = request;
            CompanionDeviceManager.this.getActivity().getApplication().registerActivityLifecycleCallbacks(this);
        }

        @Override
        public void onSuccess(PendingIntent launcher) {
            this.lockAndPost(Callback::onDeviceFound, launcher.getIntentSender());
        }

        @Override
        public void onFailure(CharSequence reason) {
            this.lockAndPost(Callback::onFailure, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> void lockAndPost(BiConsumer<Callback, T> action, T payload) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHandler != null) {
                    this.mHandler.post(() -> {
                        Callback callback = null;
                        Object object = this.mLock;
                        synchronized (object) {
                            callback = this.mCallback;
                        }
                        if (callback != null) {
                            action.accept(callback, payload);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActivityDestroyed(Activity activity) {
            Object object = this.mLock;
            synchronized (object) {
                if (activity != CompanionDeviceManager.this.getActivity()) {
                    return;
                }
                try {
                    CompanionDeviceManager.this.mService.stopScan(this.mRequest, this, CompanionDeviceManager.this.getCallingPackage());
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                CompanionDeviceManager.this.getActivity().getApplication().unregisterActivityLifecycleCallbacks(this);
                this.mCallback = null;
                this.mHandler = null;
                this.mRequest = null;
            }
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        @Override
        public void onActivityStarted(Activity activity) {
        }

        @Override
        public void onActivityResumed(Activity activity) {
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onActivityStopped(Activity activity) {
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    public static abstract class Callback {
        public abstract void onDeviceFound(IntentSender var1);

        public abstract void onFailure(CharSequence var1);
    }
}

