/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.AttributionSourceState;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os._Original_Build;
import android.permission.PermissionManager;
import android.util.ArraySet;
import com.android.internal.annotations.Immutable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@Immutable
public class AttributionSource
implements Parcelable {
    private static final String DESCRIPTOR = "android.content.AttributionSource";
    private static final Binder sDefaultToken = new Binder("android.content.AttributionSource");
    private final AttributionSourceState mAttributionSourceState;
    private AttributionSource mNextCached;
    private Set<String> mRenouncedPermissionsCached;
    public static final Parcelable.Creator<AttributionSource> CREATOR = new Parcelable.Creator<AttributionSource>(){

        public AttributionSource[] newArray(int size) {
            return new AttributionSource[size];
        }

        @Override
        public AttributionSource createFromParcel(Parcel in) {
            return new AttributionSource(in);
        }
    };

    public AttributionSource(int uid, String packageName, String attributionTag) {
        this(uid, packageName, attributionTag, sDefaultToken);
    }

    public AttributionSource(int uid, String packageName, String attributionTag, IBinder token) {
        this(uid, packageName, attributionTag, token, null, null);
    }

    public AttributionSource(int uid, String packageName, String attributionTag, IBinder token, AttributionSource next) {
        this(uid, packageName, attributionTag, token, null, next);
    }

    public AttributionSource(int uid, String packageName, String attributionTag, Set<String> renouncedPermissions, AttributionSource next) {
        this(uid, packageName, attributionTag, renouncedPermissions != null ? renouncedPermissions.toArray(new String[0]) : null, next);
    }

    public AttributionSource(AttributionSource current, AttributionSource next) {
        this(current.getUid(), current.getPackageName(), current.getAttributionTag(), current.getToken(), current.mAttributionSourceState.renouncedPermissions, next);
    }

    AttributionSource(int uid, String packageName, String attributionTag, String[] renouncedPermissions, AttributionSource next) {
        this(uid, packageName, attributionTag, sDefaultToken, renouncedPermissions, next);
    }

    AttributionSource(int uid, String packageName, String attributionTag, IBinder token, String[] renouncedPermissions, AttributionSource next) {
        AttributionSourceState[] attributionSourceStateArray;
        this.mAttributionSourceState = new AttributionSourceState();
        this.mAttributionSourceState.uid = uid;
        this.mAttributionSourceState.token = token;
        this.mAttributionSourceState.packageName = packageName;
        this.mAttributionSourceState.attributionTag = attributionTag;
        this.mAttributionSourceState.renouncedPermissions = renouncedPermissions;
        if (next != null) {
            AttributionSourceState[] attributionSourceStateArray2 = new AttributionSourceState[1];
            attributionSourceStateArray = attributionSourceStateArray2;
            attributionSourceStateArray2[0] = next.mAttributionSourceState;
        } else {
            attributionSourceStateArray = new AttributionSourceState[]{};
        }
        this.mAttributionSourceState.next = attributionSourceStateArray;
    }

    AttributionSource(Parcel in) {
        this(AttributionSourceState.CREATOR.createFromParcel(in));
        this.enforceCallingUid();
    }

    public AttributionSource(AttributionSourceState attributionSourceState) {
        this.mAttributionSourceState = attributionSourceState;
    }

    public AttributionSource withNextAttributionSource(AttributionSource next) {
        return new AttributionSource(this.getUid(), this.getPackageName(), this.getAttributionTag(), this.mAttributionSourceState.renouncedPermissions, next);
    }

    public AttributionSource withPackageName(String packageName) {
        return new AttributionSource(this.getUid(), packageName, this.getAttributionTag(), this.mAttributionSourceState.renouncedPermissions, this.getNext());
    }

    public AttributionSource withToken(Binder token) {
        return new AttributionSource(this.getUid(), this.getPackageName(), this.getAttributionTag(), token, this.mAttributionSourceState.renouncedPermissions, this.getNext());
    }

    public AttributionSourceState asState() {
        return this.mAttributionSourceState;
    }

    public ScopedParcelState asScopedParcelState() {
        return new ScopedParcelState(this);
    }

    public static AttributionSource myAttributionSource() {
        return new AttributionSource(Process.myUid(), ActivityThread.currentOpPackageName(), null, (String[])null, null);
    }

    public void enforceCallingUid() {
        if (!this.checkCallingUid()) {
            throw new SecurityException("Calling uid: " + Binder.getCallingUid() + " doesn't match source uid: " + this.mAttributionSourceState.uid);
        }
    }

    public boolean checkCallingUid() {
        int callingUid = Binder.getCallingUid();
        return callingUid == 0 || callingUid == 1000 || callingUid == this.mAttributionSourceState.uid;
    }

    public String toString() {
        if (_Original_Build.IS_DEBUGGABLE) {
            return "AttributionSource { uid = " + this.mAttributionSourceState.uid + ", packageName = " + this.mAttributionSourceState.packageName + ", attributionTag = " + this.mAttributionSourceState.attributionTag + ", token = " + this.mAttributionSourceState.token + ", next = " + (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0 ? this.mAttributionSourceState.next[0] : null) + " }";
        }
        return super.toString();
    }

    public int getNextUid() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].uid;
        }
        return -1;
    }

    public String getNextPackageName() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].packageName;
        }
        return null;
    }

    public String getNextAttributionTag() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].attributionTag;
        }
        return null;
    }

    public IBinder getNextToken() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].token;
        }
        return null;
    }

    public boolean isTrusted(Context context) {
        return this.mAttributionSourceState.token != null && context.getSystemService(PermissionManager.class).isRegisteredAttributionSource(this);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
    public Set<String> getRenouncedPermissions() {
        if (this.mRenouncedPermissionsCached == null) {
            this.mRenouncedPermissionsCached = this.mAttributionSourceState.renouncedPermissions != null ? new ArraySet<String>(this.mAttributionSourceState.renouncedPermissions) : Collections.emptySet();
        }
        return this.mRenouncedPermissionsCached;
    }

    public int getUid() {
        return this.mAttributionSourceState.uid;
    }

    public String getPackageName() {
        return this.mAttributionSourceState.packageName;
    }

    public String getAttributionTag() {
        return this.mAttributionSourceState.attributionTag;
    }

    public IBinder getToken() {
        return this.mAttributionSourceState.token;
    }

    public AttributionSource getNext() {
        if (this.mNextCached == null && this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            this.mNextCached = new AttributionSource(this.mAttributionSourceState.next[0]);
        }
        return this.mNextCached;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributionSource that = (AttributionSource)o;
        return this.mAttributionSourceState.uid == that.mAttributionSourceState.uid && Objects.equals(this.mAttributionSourceState.packageName, that.mAttributionSourceState.packageName) && Objects.equals(this.mAttributionSourceState.attributionTag, that.mAttributionSourceState.attributionTag) && Objects.equals(this.mAttributionSourceState.token, that.mAttributionSourceState.token) && Arrays.equals(this.mAttributionSourceState.renouncedPermissions, that.mAttributionSourceState.renouncedPermissions) && Objects.equals(this.getNext(), that.getNext());
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mAttributionSourceState.uid;
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionSourceState.packageName);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionSourceState.attributionTag);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionSourceState.token);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionSourceState.renouncedPermissions);
        _hash = 31 * _hash + Objects.hashCode(this.getNext());
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mAttributionSourceState.writeToParcel(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final AttributionSourceState mAttributionSourceState = new AttributionSourceState();
        private long mBuilderFieldsSet = 0L;

        public Builder(int uid) {
            this.mAttributionSourceState.uid = uid;
        }

        public Builder setPackageName(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mAttributionSourceState.packageName = value;
            return this;
        }

        public Builder setAttributionTag(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mAttributionSourceState.attributionTag = value;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
        public Builder setRenouncedPermissions(Set<String> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mAttributionSourceState.renouncedPermissions = value != null ? value.toArray(new String[0]) : null;
            return this;
        }

        public Builder setNext(AttributionSource value) {
            AttributionSourceState[] attributionSourceStateArray;
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            if (value != null) {
                AttributionSourceState[] attributionSourceStateArray2 = new AttributionSourceState[1];
                attributionSourceStateArray = attributionSourceStateArray2;
                attributionSourceStateArray2[0] = value.mAttributionSourceState;
            } else {
                attributionSourceStateArray = this.mAttributionSourceState.next;
            }
            this.mAttributionSourceState.next = attributionSourceStateArray;
            return this;
        }

        public AttributionSource build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mAttributionSourceState.packageName = null;
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mAttributionSourceState.attributionTag = null;
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mAttributionSourceState.renouncedPermissions = null;
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mAttributionSourceState.next = null;
            }
            this.mAttributionSourceState.token = sDefaultToken;
            if (this.mAttributionSourceState.next == null) {
                this.mAttributionSourceState.next = new AttributionSourceState[0];
            }
            return new AttributionSource(this.mAttributionSourceState);
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x40L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    public static class ScopedParcelState
    implements AutoCloseable {
        private final Parcel mParcel = Parcel.obtain();

        public Parcel getParcel() {
            return this.mParcel;
        }

        public ScopedParcelState(AttributionSource attributionSource) {
            attributionSource.writeToParcel(this.mParcel, 0);
            this.mParcel.setDataPosition(0);
        }

        @Override
        public void close() {
            this.mParcel.recycle();
        }
    }
}

