/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ComponentCallbacksController {
    @GuardedBy(value={"mLock"})
    private List<ComponentCallbacks> mComponentCallbacks;
    private final Object mLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallbacks(ComponentCallbacks callbacks) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mComponentCallbacks == null) {
                this.mComponentCallbacks = new ArrayList<ComponentCallbacks>();
            }
            this.mComponentCallbacks.add(callbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallbacks(ComponentCallbacks callbacks) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mComponentCallbacks == null || this.mComponentCallbacks.isEmpty()) {
                return;
            }
            this.mComponentCallbacks.remove(callbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mComponentCallbacks != null) {
                this.mComponentCallbacks.clear();
            }
        }
    }

    public void dispatchConfigurationChanged(Configuration newConfig) {
        this.forAllComponentCallbacks(callbacks -> callbacks.onConfigurationChanged(newConfig));
    }

    public void dispatchLowMemory() {
        this.forAllComponentCallbacks(ComponentCallbacks::onLowMemory);
    }

    public void dispatchTrimMemory(int level) {
        this.forAllComponentCallbacks(callbacks -> {
            if (callbacks instanceof ComponentCallbacks2) {
                ((ComponentCallbacks2)callbacks).onTrimMemory(level);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forAllComponentCallbacks(Consumer<ComponentCallbacks> callbacksConsumer) {
        ComponentCallbacks[] componentCallbacksArray = this.mLock;
        synchronized (this.mLock) {
            if (this.mComponentCallbacks == null || this.mComponentCallbacks.isEmpty()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            ComponentCallbacks[] callbacksArray = new ComponentCallbacks[this.mComponentCallbacks.size()];
            this.mComponentCallbacks.toArray(callbacksArray);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (ComponentCallbacks callbacks : callbacksArray) {
                callbacksConsumer.accept(callbacks);
            }
            return;
        }
    }
}

