/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.UriGrantsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ContentInterface;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncRequest;
import android.content.SyncStatusInfo;
import android.content.SyncStatusObserver;
import android.content.UriPermission;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.IContentObserver;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os._Original_Build;
import android.system.Int64Ref;
import android.text.TextUtils;
import android.util.Log;
import android.util.Size;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.MimeIconUtils;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ContentResolver
implements ContentInterface {
    public static final boolean DEPRECATE_DATA_COLUMNS = true;
    public static final String DEPRECATE_DATA_PREFIX = "/mnt/content/";
    @Deprecated
    public static final String SYNC_EXTRAS_ACCOUNT = "account";
    public static final String SYNC_EXTRAS_EXPEDITED = "expedited";
    public static final String SYNC_EXTRAS_REQUIRE_CHARGING = "require_charging";
    @SuppressLint(value={"IntentName"})
    public static final String SYNC_EXTRAS_SCHEDULE_AS_EXPEDITED_JOB = "schedule_as_expedited_job";
    @Deprecated
    public static final String SYNC_EXTRAS_FORCE = "force";
    public static final String SYNC_EXTRAS_IGNORE_SETTINGS = "ignore_settings";
    public static final String SYNC_EXTRAS_IGNORE_BACKOFF = "ignore_backoff";
    public static final String SYNC_EXTRAS_DO_NOT_RETRY = "do_not_retry";
    public static final String SYNC_EXTRAS_MANUAL = "force";
    public static final String SYNC_EXTRAS_UPLOAD = "upload";
    public static final String SYNC_EXTRAS_OVERRIDE_TOO_MANY_DELETIONS = "deletions_override";
    public static final String SYNC_EXTRAS_DISCARD_LOCAL_DELETIONS = "discard_deletions";
    public static final String SYNC_EXTRAS_EXPECTED_UPLOAD = "expected_upload";
    public static final String SYNC_EXTRAS_EXPECTED_DOWNLOAD = "expected_download";
    public static final String SYNC_EXTRAS_PRIORITY = "sync_priority";
    public static final String SYNC_EXTRAS_DISALLOW_METERED = "allow_metered";
    public static final String SYNC_VIRTUAL_EXTRAS_EXEMPTION_FLAG = "v_exemption";
    public static final String SYNC_EXTRAS_INITIALIZE = "initialize";
    public static final Intent ACTION_SYNC_CONN_STATUS_CHANGED = new Intent("com.android.sync.SYNC_CONN_STATUS_CHANGED");
    public static final String SCHEME_CONTENT = "content";
    public static final String SCHEME_ANDROID_RESOURCE = "android.resource";
    public static final String SCHEME_FILE = "file";
    public static final String EXTRA_SIZE = "android.content.extra.SIZE";
    public static final String EXTRA_REFRESH_SUPPORTED = "android.content.extra.REFRESH_SUPPORTED";
    public static final String QUERY_ARG_SQL_SELECTION = "android:query-arg-sql-selection";
    public static final String QUERY_ARG_SQL_SELECTION_ARGS = "android:query-arg-sql-selection-args";
    public static final String QUERY_ARG_SQL_SORT_ORDER = "android:query-arg-sql-sort-order";
    public static final String QUERY_ARG_SQL_GROUP_BY = "android:query-arg-sql-group-by";
    public static final String QUERY_ARG_SQL_HAVING = "android:query-arg-sql-having";
    public static final String QUERY_ARG_SQL_LIMIT = "android:query-arg-sql-limit";
    public static final String QUERY_ARG_SORT_COLUMNS = "android:query-arg-sort-columns";
    public static final String QUERY_ARG_SORT_DIRECTION = "android:query-arg-sort-direction";
    public static final String QUERY_ARG_SORT_COLLATION = "android:query-arg-sort-collation";
    public static final String QUERY_ARG_SORT_LOCALE = "android:query-arg-sort-locale";
    public static final String QUERY_ARG_GROUP_COLUMNS = "android:query-arg-group-columns";
    public static final String EXTRA_HONORED_ARGS = "android.content.extra.HONORED_ARGS";
    public static final int QUERY_SORT_DIRECTION_ASCENDING = 0;
    public static final int QUERY_SORT_DIRECTION_DESCENDING = 1;
    public static final String QUERY_ARG_OFFSET = "android:query-arg-offset";
    public static final String QUERY_ARG_LIMIT = "android:query-arg-limit";
    public static final String EXTRA_TOTAL_COUNT = "android.content.extra.TOTAL_COUNT";
    public static final String CURSOR_ITEM_BASE_TYPE = "vnd.android.cursor.item";
    public static final String CURSOR_DIR_BASE_TYPE = "vnd.android.cursor.dir";
    public static final String ANY_CURSOR_ITEM_TYPE = "vnd.android.cursor.item/*";
    @Deprecated
    public static final String MIME_TYPE_DEFAULT = "application/octet-stream";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int SYNC_ERROR_SYNC_ALREADY_IN_PROGRESS = 1;
    public static final int SYNC_ERROR_AUTHENTICATION = 2;
    public static final int SYNC_ERROR_IO = 3;
    public static final int SYNC_ERROR_PARSE = 4;
    public static final int SYNC_ERROR_CONFLICT = 5;
    public static final int SYNC_ERROR_TOO_MANY_DELETIONS = 6;
    public static final int SYNC_ERROR_TOO_MANY_RETRIES = 7;
    public static final int SYNC_ERROR_INTERNAL = 8;
    private static final String[] SYNC_ERROR_NAMES = new String[]{"already-in-progress", "authentication-error", "io-error", "parse-error", "conflict", "too-many-deletions", "too-many-retries", "internal-error"};
    public static final int SYNC_OBSERVER_TYPE_SETTINGS = 1;
    public static final int SYNC_OBSERVER_TYPE_PENDING = 2;
    public static final int SYNC_OBSERVER_TYPE_ACTIVE = 4;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int SYNC_OBSERVER_TYPE_STATUS = 8;
    public static final int SYNC_OBSERVER_TYPE_ALL = Integer.MAX_VALUE;
    public static final int NOTIFY_SYNC_TO_NETWORK = 1;
    public static final int NOTIFY_SKIP_NOTIFY_FOR_DESCENDANTS = 2;
    public static final int NOTIFY_INSERT = 4;
    public static final int NOTIFY_UPDATE = 8;
    public static final int NOTIFY_DELETE = 16;
    public static final int NOTIFY_NO_DELAY = 32768;
    public static final int SYNC_EXEMPTION_NONE = 0;
    public static final int SYNC_EXEMPTION_PROMOTE_BUCKET = 1;
    public static final int SYNC_EXEMPTION_PROMOTE_BUCKET_WITH_TEMP = 2;
    private static final boolean ENABLE_CONTENT_SAMPLE = false;
    private static final int SLOW_THRESHOLD_MILLIS = 500 * _Original_Build.HW_TIMEOUT_MULTIPLIER;
    private final Random mRandom = new Random();
    public static final String REMOTE_CALLBACK_RESULT = "result";
    public static final String REMOTE_CALLBACK_ERROR = "error";
    public static final int CONTENT_PROVIDER_PUBLISH_TIMEOUT_MILLIS = 10000 * _Original_Build.HW_TIMEOUT_MULTIPLIER;
    public static final int CONTENT_PROVIDER_READY_TIMEOUT_MILLIS = CONTENT_PROVIDER_PUBLISH_TIMEOUT_MILLIS + 10000 * _Original_Build.HW_TIMEOUT_MULTIPLIER;
    private static final int CONTENT_PROVIDER_TIMEOUT_MILLIS = 3000 * _Original_Build.HW_TIMEOUT_MULTIPLIER;
    private static final int REMOTE_CONTENT_PROVIDER_TIMEOUT_MILLIS = CONTENT_PROVIDER_READY_TIMEOUT_MILLIS + CONTENT_PROVIDER_TIMEOUT_MILLIS;
    public static final String CONTENT_SERVICE_NAME = "content";
    @UnsupportedAppUsage
    private static volatile IContentService sContentService;
    @UnsupportedAppUsage
    private final Context mContext;
    @Deprecated
    @UnsupportedAppUsage
    final String mPackageName;
    final int mTargetSdkVersion;
    final ContentInterface mWrapped;
    private static final String TAG = "ContentResolver";

    public static String syncErrorToString(int error) {
        if (error < 1 || error > SYNC_ERROR_NAMES.length) {
            return String.valueOf(error);
        }
        return SYNC_ERROR_NAMES[error - 1];
    }

    public static int syncErrorStringToInt(String error) {
        int n = SYNC_ERROR_NAMES.length;
        for (int i = 0; i < n; ++i) {
            if (!SYNC_ERROR_NAMES[i].equals(error)) continue;
            return i + 1;
        }
        if (error != null) {
            try {
                return Integer.parseInt(error);
            }
            catch (NumberFormatException e) {
                Log.d(TAG, "error parsing sync error: " + error);
            }
        }
        return 0;
    }

    public ContentResolver(Context context) {
        this(context, null);
    }

    public ContentResolver(Context context, ContentInterface wrapped) {
        this.mContext = context != null ? context : ActivityThread.currentApplication();
        this.mPackageName = this.mContext.getOpPackageName();
        this.mTargetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
        this.mWrapped = wrapped;
    }

    public static ContentResolver wrap(ContentInterface wrapped) {
        Objects.requireNonNull(wrapped);
        return new ContentResolver(null, wrapped){

            @Override
            public void unstableProviderDied(IContentProvider icp) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean releaseUnstableProvider(IContentProvider icp) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean releaseProvider(IContentProvider icp) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected IContentProvider acquireUnstableProvider(Context c, String name) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected IContentProvider acquireProvider(Context c, String name) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ContentResolver wrap(ContentProvider wrapped) {
        return ContentResolver.wrap((ContentInterface)wrapped);
    }

    public static ContentResolver wrap(ContentProviderClient wrapped) {
        return ContentResolver.wrap((ContentInterface)wrapped);
    }

    @UnsupportedAppUsage
    protected abstract IContentProvider acquireProvider(Context var1, String var2);

    @UnsupportedAppUsage
    protected IContentProvider acquireExistingProvider(Context c, String name) {
        return this.acquireProvider(c, name);
    }

    @UnsupportedAppUsage
    public abstract boolean releaseProvider(IContentProvider var1);

    @UnsupportedAppUsage
    protected abstract IContentProvider acquireUnstableProvider(Context var1, String var2);

    @UnsupportedAppUsage
    public abstract boolean releaseUnstableProvider(IContentProvider var1);

    @UnsupportedAppUsage
    public abstract void unstableProviderDied(IContentProvider var1);

    public void appNotRespondingViaProvider(IContentProvider icp) {
        throw new UnsupportedOperationException("appNotRespondingViaProvider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType(Uri url) {
        Objects.requireNonNull(url, "url");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.getType(url);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        IContentProvider provider = this.acquireExistingProvider(url);
        if (provider != null) {
            try {
                StringResultListener resultListener = new StringResultListener();
                provider.getTypeAsync(url, new RemoteCallback(resultListener));
                resultListener.waitForResult(CONTENT_PROVIDER_TIMEOUT_MILLIS);
                if (resultListener.exception != null) {
                    throw resultListener.exception;
                }
                String string2 = (String)resultListener.result;
                return string2;
            }
            catch (RemoteException e) {
                String string3 = null;
                return string3;
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to get type for: " + url + " (" + e.getMessage() + ")");
                String string4 = null;
                return string4;
            }
            finally {
                this.releaseProvider(provider);
            }
        }
        if (!"content".equals(url.getScheme())) {
            return null;
        }
        try {
            StringResultListener resultListener = new StringResultListener();
            ActivityManager.getService().getProviderMimeTypeAsync(ContentProvider.getUriWithoutUserId(url), this.resolveUserId(url), new RemoteCallback(resultListener));
            resultListener.waitForResult(REMOTE_CONTENT_PROVIDER_TIMEOUT_MILLIS);
            if (resultListener.exception != null) {
                throw resultListener.exception;
            }
            return (String)resultListener.result;
        }
        catch (RemoteException e) {
            return null;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to get type for: " + url + " (" + e.getMessage() + ")");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getStreamTypes(Uri url, String mimeTypeFilter) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mimeTypeFilter, "mimeTypeFilter");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.getStreamTypes(url, mimeTypeFilter);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            String[] stringArray = provider.getStreamTypes(url, mimeTypeFilter);
            return stringArray;
        }
        catch (RemoteException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    public Cursor query(@RequiresPermission.Read Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder, null);
    }

    public Cursor query(@RequiresPermission.Read Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        Bundle queryArgs = ContentResolver.createSqlQueryBundle(selection, selectionArgs, sortOrder);
        return this.query(uri, projection, queryArgs, cancellationSignal);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Cursor query(@RequiresPermission.Read Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Uri canonicalizeOrElse(Uri uri) {
        Uri res = this.canonicalize(uri);
        return res != null ? res : uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri canonicalize(Uri url) {
        Objects.requireNonNull(url, "url");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.canonicalize(url);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            UriResultListener resultListener = new UriResultListener();
            provider.canonicalizeAsync(this.mContext.getAttributionSource(), url, new RemoteCallback(resultListener));
            resultListener.waitForResult(CONTENT_PROVIDER_TIMEOUT_MILLIS);
            if (resultListener.exception != null) {
                throw resultListener.exception;
            }
            Uri uri = (Uri)resultListener.result;
            return uri;
        }
        catch (RemoteException e) {
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri uncanonicalize(Uri url) {
        Objects.requireNonNull(url, "url");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.uncanonicalize(url);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            UriResultListener resultListener = new UriResultListener();
            provider.uncanonicalizeAsync(this.mContext.getAttributionSource(), url, new RemoteCallback(resultListener));
            resultListener.waitForResult(CONTENT_PROVIDER_TIMEOUT_MILLIS);
            if (resultListener.exception != null) {
                throw resultListener.exception;
            }
            Uri uri = (Uri)resultListener.result;
            return uri;
        }
        catch (RemoteException e) {
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refresh(Uri url, Bundle extras, CancellationSignal cancellationSignal) {
        Objects.requireNonNull(url, "url");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.refresh(url, extras, cancellationSignal);
            }
        }
        catch (RemoteException e) {
            return false;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return false;
        }
        try {
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = provider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            boolean bl = provider.refresh(this.mContext.getAttributionSource(), url, extras, remoteCancellationSignal);
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    @Override
    @SystemApi
    public int checkUriPermission(Uri uri, int uid, int modeFlags) {
        Objects.requireNonNull(uri, "uri");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.checkUriPermission(uri, uid, modeFlags);
            }
        }
        catch (RemoteException e) {
            return -1;
        }
        ContentProviderClient client = this.acquireUnstableContentProviderClient(uri);
        try {
            int n = client.checkUriPermission(uri, uid, modeFlags);
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                return -1;
            }
        }
    }

    public InputStream openInputStream(Uri uri) throws FileNotFoundException {
        Objects.requireNonNull(uri, "uri");
        String scheme = uri.getScheme();
        if (SCHEME_ANDROID_RESOURCE.equals(scheme)) {
            OpenResourceIdResult r = this.getResourceId(uri);
            try {
                InputStream stream = r.r.openRawResource(r.id);
                return stream;
            }
            catch (Resources.NotFoundException ex) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        if (SCHEME_FILE.equals(scheme)) {
            return new FileInputStream(uri.getPath());
        }
        AssetFileDescriptor fd = this.openAssetFileDescriptor(uri, "r", null);
        try {
            return fd != null ? fd.createInputStream() : null;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    public OutputStream openOutputStream(Uri uri) throws FileNotFoundException {
        return this.openOutputStream(uri, "w");
    }

    public OutputStream openOutputStream(Uri uri, String mode) throws FileNotFoundException {
        AssetFileDescriptor fd = this.openAssetFileDescriptor(uri, mode, null);
        try {
            return fd != null ? fd.createOutputStream() : null;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.openFile(uri, mode, signal);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return this.openFileDescriptor(uri, mode, signal);
    }

    public ParcelFileDescriptor openFileDescriptor(Uri uri, String mode) throws FileNotFoundException {
        return this.openFileDescriptor(uri, mode, null);
    }

    public ParcelFileDescriptor openFileDescriptor(Uri uri, String mode, CancellationSignal cancellationSignal) throws FileNotFoundException {
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.openFile(uri, mode, cancellationSignal);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        AssetFileDescriptor afd = this.openAssetFileDescriptor(uri, mode, cancellationSignal);
        if (afd == null) {
            return null;
        }
        if (afd.getDeclaredLength() < 0L) {
            return afd.getParcelFileDescriptor();
        }
        try {
            afd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new FileNotFoundException("Not a whole file");
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.openAssetFile(uri, mode, signal);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return this.openAssetFileDescriptor(uri, mode, signal);
    }

    public AssetFileDescriptor openAssetFileDescriptor(Uri uri, String mode) throws FileNotFoundException {
        return this.openAssetFileDescriptor(uri, mode, null);
    }

    /*
     * Exception decompiling
     */
    public AssetFileDescriptor openAssetFileDescriptor(Uri uri, String mode, CancellationSignal cancellationSignal) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 9[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.openTypedAssetFile(uri, mimeTypeFilter, opts, signal);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return this.openTypedAssetFileDescriptor(uri, mimeTypeFilter, opts, signal);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, mimeType, opts, null);
    }

    /*
     * Exception decompiling
     */
    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts, CancellationSignal cancellationSignal) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @UnsupportedAppUsage
    public OpenResourceIdResult getResourceId(Uri uri) throws FileNotFoundException {
        int id2;
        Resources r;
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty(authority)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            r = this.mContext.getPackageManager().getResourcesForApplication(authority);
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        List<String> path = uri.getPathSegments();
        if (path == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        int len = path.size();
        if (len == 1) {
            try {
                id2 = Integer.parseInt(path.get(0));
            }
            catch (NumberFormatException e) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else if (len == 2) {
            id2 = r.getIdentifier(path.get(1), path.get(0), authority);
        } else {
            throw new FileNotFoundException("More than two path segments: " + uri);
        }
        if (id2 == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        OpenResourceIdResult res = new OpenResourceIdResult();
        res.r = r;
        res.id = id2;
        return res;
    }

    public Uri insert(@RequiresPermission.Write Uri url, ContentValues values) {
        return this.insert(url, values, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri insert(@RequiresPermission.Write Uri url, ContentValues values, Bundle extras) {
        Objects.requireNonNull(url, "url");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.insert(url, values, extras);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            Uri createdRow = provider.insert(this.mContext.getAttributionSource(), url, values, extras);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, url, "insert", null);
            Uri uri = createdRow;
            return uri;
        }
        catch (RemoteException e) {
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Objects.requireNonNull(authority, "authority");
        Objects.requireNonNull(operations, "operations");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.applyBatch(authority, operations);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        ContentProviderClient provider = this.acquireContentProviderClient(authority);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown authority " + authority);
        }
        try {
            ContentProviderResult[] contentProviderResultArray = provider.applyBatch(operations);
            return contentProviderResultArray;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bulkInsert(@RequiresPermission.Write Uri url, ContentValues[] values) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(values, "values");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.bulkInsert(url, values);
            }
        }
        catch (RemoteException e) {
            return 0;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            int rowsCreated = provider.bulkInsert(this.mContext.getAttributionSource(), url, values);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, url, "bulkinsert", null);
            int n = rowsCreated;
            return n;
        }
        catch (RemoteException e) {
            int n = 0;
            return n;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    public int delete(@RequiresPermission.Write Uri url, String where, String[] selectionArgs) {
        return this.delete(url, ContentResolver.createSqlQueryBundle(where, selectionArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(@RequiresPermission.Write Uri url, Bundle extras) {
        Objects.requireNonNull(url, "url");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.delete(url, extras);
            }
        }
        catch (RemoteException e) {
            return 0;
        }
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            int rowsDeleted = provider.delete(this.mContext.getAttributionSource(), url, extras);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, url, "delete", null);
            int n = rowsDeleted;
            return n;
        }
        catch (RemoteException e) {
            int n = -1;
            return n;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    public int update(@RequiresPermission.Write Uri uri, ContentValues values, String where, String[] selectionArgs) {
        return this.update(uri, values, ContentResolver.createSqlQueryBundle(where, selectionArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(@RequiresPermission.Write Uri uri, ContentValues values, Bundle extras) {
        Objects.requireNonNull(uri, "uri");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.update(uri, values, extras);
            }
        }
        catch (RemoteException e) {
            return 0;
        }
        IContentProvider provider = this.acquireProvider(uri);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            int rowsUpdated = provider.update(this.mContext.getAttributionSource(), uri, values, extras);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, uri, "update", null);
            int n = rowsUpdated;
            return n;
        }
        catch (RemoteException e) {
            int n = -1;
            return n;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    public Bundle call(Uri uri, String method, String arg, Bundle extras) {
        return this.call(uri.getAuthority(), method, arg, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle call(String authority, String method, String arg, Bundle extras) {
        Objects.requireNonNull(authority, "authority");
        Objects.requireNonNull(method, "method");
        try {
            if (this.mWrapped != null) {
                return this.mWrapped.call(authority, method, arg, extras);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        IContentProvider provider = this.acquireProvider(authority);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown authority " + authority);
        }
        try {
            Bundle res = provider.call(this.mContext.getAttributionSource(), authority, method, arg, extras);
            Bundle.setDefusable(res, true);
            Bundle bundle = res;
            return bundle;
        }
        catch (RemoteException e) {
            Bundle bundle = null;
            return bundle;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    @UnsupportedAppUsage
    public IContentProvider acquireProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireProvider(this.mContext, auth);
        }
        return null;
    }

    @UnsupportedAppUsage
    public IContentProvider acquireExistingProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireExistingProvider(this.mContext, auth);
        }
        return null;
    }

    @UnsupportedAppUsage
    public IContentProvider acquireProvider(String name) {
        if (name == null) {
            return null;
        }
        return this.acquireProvider(this.mContext, name);
    }

    public IContentProvider acquireUnstableProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireUnstableProvider(this.mContext, uri.getAuthority());
        }
        return null;
    }

    @UnsupportedAppUsage
    public IContentProvider acquireUnstableProvider(String name) {
        if (name == null) {
            return null;
        }
        return this.acquireUnstableProvider(this.mContext, name);
    }

    public ContentProviderClient acquireContentProviderClient(Uri uri) {
        Objects.requireNonNull(uri, "uri");
        IContentProvider provider = this.acquireProvider(uri);
        if (provider != null) {
            return new ContentProviderClient(this, provider, uri.getAuthority(), true);
        }
        return null;
    }

    public ContentProviderClient acquireContentProviderClient(String name) {
        Objects.requireNonNull(name, "name");
        IContentProvider provider = this.acquireProvider(name);
        if (provider != null) {
            return new ContentProviderClient(this, provider, name, true);
        }
        return null;
    }

    public ContentProviderClient acquireUnstableContentProviderClient(Uri uri) {
        Objects.requireNonNull(uri, "uri");
        IContentProvider provider = this.acquireUnstableProvider(uri);
        if (provider != null) {
            return new ContentProviderClient(this, provider, uri.getAuthority(), false);
        }
        return null;
    }

    public ContentProviderClient acquireUnstableContentProviderClient(String name) {
        Objects.requireNonNull(name, "name");
        IContentProvider provider = this.acquireUnstableProvider(name);
        if (provider != null) {
            return new ContentProviderClient(this, provider, name, false);
        }
        return null;
    }

    public void registerContentObserver(Uri uri, boolean notifyForDescendants, ContentObserver observer) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(observer, "observer");
        this.registerContentObserver(ContentProvider.getUriWithoutUserId(uri), notifyForDescendants, observer, ContentProvider.getUserIdFromUri(uri, this.mContext.getUserId()));
    }

    @UnsupportedAppUsage
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
        try {
            ContentResolver.getContentService().registerContentObserver(uri, notifyForDescendents, observer.getContentObserver(), userHandle, this.mTargetSdkVersion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterContentObserver(ContentObserver observer) {
        Objects.requireNonNull(observer, "observer");
        try {
            IContentObserver contentObserver = observer.releaseContentObserver();
            if (contentObserver != null) {
                ContentResolver.getContentService().unregisterContentObserver(contentObserver);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyChange(Uri uri, ContentObserver observer) {
        this.notifyChange(uri, observer, true);
    }

    @Deprecated
    public void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
        this.notifyChange(uri, observer, syncToNetwork ? 1 : 0);
    }

    public void notifyChange(Uri uri, ContentObserver observer, int flags) {
        Objects.requireNonNull(uri, "uri");
        this.notifyChange(ContentProvider.getUriWithoutUserId(uri), observer, flags, ContentProvider.getUserIdFromUri(uri, this.mContext.getUserId()));
    }

    @Deprecated
    public void notifyChange(Iterable<Uri> uris, ContentObserver observer, int flags) {
        ArrayList<Uri> asCollection = new ArrayList<Uri>();
        uris.forEach(asCollection::add);
        this.notifyChange((Collection<Uri>)asCollection, observer, flags);
    }

    public void notifyChange(Collection<Uri> uris, ContentObserver observer, int flags) {
        Objects.requireNonNull(uris, "uris");
        SparseArray<ArrayList<Uri>> clusteredByUser = new SparseArray<ArrayList<Uri>>();
        for (Uri uri : uris) {
            int userId = ContentProvider.getUserIdFromUri(uri, this.mContext.getUserId());
            ArrayList<Uri> list = (ArrayList<Uri>)clusteredByUser.get(userId);
            if (list == null) {
                list = new ArrayList<Uri>();
                clusteredByUser.put(userId, list);
            }
            list.add(ContentProvider.getUriWithoutUserId(uri));
        }
        for (int i = 0; i < clusteredByUser.size(); ++i) {
            int userId = clusteredByUser.keyAt(i);
            ArrayList list = (ArrayList)clusteredByUser.valueAt(i);
            this.notifyChange(list.toArray(new Uri[list.size()]), observer, flags, userId);
        }
    }

    @Deprecated
    public void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork, int userHandle) {
        this.notifyChange(uri, observer, syncToNetwork ? 1 : 0, userHandle);
    }

    public void notifyChange(Uri uri, ContentObserver observer, int flags, int userHandle) {
        this.notifyChange(new Uri[]{uri}, observer, flags, userHandle);
    }

    public void notifyChange(Uri[] uris, ContentObserver observer, int flags, int userHandle) {
        try {
            ContentResolver.getContentService().notifyChange(uris, observer == null ? null : observer.getContentObserver(), observer != null && observer.deliverSelfNotifications(), flags, userHandle, this.mTargetSdkVersion, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void takePersistableUriPermission(Uri uri, int modeFlags) {
        Objects.requireNonNull(uri, "uri");
        try {
            UriGrantsManager.getService().takePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), modeFlags, null, this.resolveUserId(uri));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void takePersistableUriPermission(String toPackage, Uri uri, int modeFlags) {
        Objects.requireNonNull(toPackage, "toPackage");
        Objects.requireNonNull(uri, "uri");
        try {
            UriGrantsManager.getService().takePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), modeFlags, toPackage, this.resolveUserId(uri));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void releasePersistableUriPermission(Uri uri, int modeFlags) {
        Objects.requireNonNull(uri, "uri");
        try {
            UriGrantsManager.getService().releasePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), modeFlags, null, this.resolveUserId(uri));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<UriPermission> getPersistedUriPermissions() {
        try {
            return UriGrantsManager.getService().getUriPermissions(this.mPackageName, true, true).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<UriPermission> getOutgoingPersistedUriPermissions() {
        try {
            return UriGrantsManager.getService().getUriPermissions(this.mPackageName, false, true).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<UriPermission> getOutgoingUriPermissions() {
        try {
            return UriGrantsManager.getService().getUriPermissions(this.mPackageName, false, false).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void startSync(Uri uri, Bundle extras) {
        Account account = null;
        if (extras != null) {
            String accountName = extras.getString(SYNC_EXTRAS_ACCOUNT);
            if (!TextUtils.isEmpty(accountName)) {
                account = new Account(accountName, "com.google");
            }
            extras.remove(SYNC_EXTRAS_ACCOUNT);
        }
        ContentResolver.requestSync(account, uri != null ? uri.getAuthority() : null, extras);
    }

    public static void requestSync(Account account, String authority, Bundle extras) {
        ContentResolver.requestSyncAsUser(account, authority, UserHandle.myUserId(), extras);
    }

    public static void requestSyncAsUser(Account account, String authority, int userId, Bundle extras) {
        if (extras == null) {
            throw new IllegalArgumentException("Must specify extras.");
        }
        SyncRequest request = new SyncRequest.Builder().setSyncAdapter(account, authority).setExtras(extras).syncOnce().build();
        try {
            ContentResolver.getContentService().syncAsUser(request, userId, ActivityThread.currentPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void requestSync(SyncRequest request) {
        try {
            ContentResolver.getContentService().sync(request, ActivityThread.currentPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void validateSyncExtrasBundle(Bundle extras) {
        try {
            for (String key : extras.keySet()) {
                Object value = extras.get(key);
                if (value == null || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Account) continue;
                throw new IllegalArgumentException("unexpected value type: " + value.getClass().getName());
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException exc) {
            throw new IllegalArgumentException("error unparceling Bundle", exc);
        }
    }

    @Deprecated
    public void cancelSync(Uri uri) {
        ContentResolver.cancelSync(null, uri != null ? uri.getAuthority() : null);
    }

    public static void cancelSync(Account account, String authority) {
        try {
            ContentResolver.getContentService().cancelSync(account, authority, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void cancelSyncAsUser(Account account, String authority, int userId) {
        try {
            ContentResolver.getContentService().cancelSyncAsUser(account, authority, null, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static SyncAdapterType[] getSyncAdapterTypes() {
        try {
            return ContentResolver.getContentService().getSyncAdapterTypes();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static SyncAdapterType[] getSyncAdapterTypesAsUser(int userId) {
        try {
            return ContentResolver.getContentService().getSyncAdapterTypesAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String[] getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) {
        try {
            return ContentResolver.getContentService().getSyncAdapterPackagesForAuthorityAsUser(authority, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean getSyncAutomatically(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getSyncAutomatically(account, authority);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean getSyncAutomaticallyAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().getSyncAutomaticallyAsUser(account, authority, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void setSyncAutomatically(Account account, String authority, boolean sync) {
        ContentResolver.setSyncAutomaticallyAsUser(account, authority, sync, UserHandle.myUserId());
    }

    public static void setSyncAutomaticallyAsUser(Account account, String authority, boolean sync, int userId) {
        try {
            ContentResolver.getContentService().setSyncAutomaticallyAsUser(account, authority, sync, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean hasInvalidScheduleAsEjExtras(Bundle extras) {
        return extras.getBoolean(SYNC_EXTRAS_REQUIRE_CHARGING) || extras.getBoolean(SYNC_EXTRAS_EXPEDITED);
    }

    public static void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        ContentResolver.validateSyncExtrasBundle(extras);
        if (ContentResolver.invalidPeriodicExtras(extras)) {
            throw new IllegalArgumentException("illegal extras were set");
        }
        try {
            ContentResolver.getContentService().addPeriodicSync(account, authority, extras, pollFrequency);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean invalidPeriodicExtras(Bundle extras) {
        return extras.getBoolean("force", false) || extras.getBoolean(SYNC_EXTRAS_DO_NOT_RETRY, false) || extras.getBoolean(SYNC_EXTRAS_IGNORE_BACKOFF, false) || extras.getBoolean(SYNC_EXTRAS_IGNORE_SETTINGS, false) || extras.getBoolean(SYNC_EXTRAS_INITIALIZE, false) || extras.getBoolean("force", false) || extras.getBoolean(SYNC_EXTRAS_EXPEDITED, false) || extras.getBoolean(SYNC_EXTRAS_SCHEDULE_AS_EXPEDITED_JOB, false);
    }

    public static void removePeriodicSync(Account account, String authority, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        try {
            ContentResolver.getContentService().removePeriodicSync(account, authority, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void cancelSync(SyncRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        try {
            ContentResolver.getContentService().cancelRequest(request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static List<PeriodicSync> getPeriodicSyncs(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getPeriodicSyncs(account, authority, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int getIsSyncable(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getIsSyncable(account, authority);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int getIsSyncableAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().getIsSyncableAsUser(account, authority, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void setIsSyncable(Account account, String authority, int syncable) {
        try {
            ContentResolver.getContentService().setIsSyncable(account, authority, syncable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void setIsSyncableAsUser(Account account, String authority, int syncable, int userId) {
        try {
            ContentResolver.getContentService().setIsSyncableAsUser(account, authority, syncable, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean getMasterSyncAutomatically() {
        try {
            return ContentResolver.getContentService().getMasterSyncAutomatically();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean getMasterSyncAutomaticallyAsUser(int userId) {
        try {
            return ContentResolver.getContentService().getMasterSyncAutomaticallyAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void setMasterSyncAutomatically(boolean sync) {
        ContentResolver.setMasterSyncAutomaticallyAsUser(sync, UserHandle.myUserId());
    }

    public static void setMasterSyncAutomaticallyAsUser(boolean sync, int userId) {
        try {
            ContentResolver.getContentService().setMasterSyncAutomaticallyAsUser(sync, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isSyncActive(Account account, String authority) {
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        try {
            return ContentResolver.getContentService().isSyncActive(account, authority, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public static SyncInfo getCurrentSync() {
        try {
            List<SyncInfo> syncs = ContentResolver.getContentService().getCurrentSyncs();
            if (syncs.isEmpty()) {
                return null;
            }
            return syncs.get(0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static List<SyncInfo> getCurrentSyncs() {
        try {
            return ContentResolver.getContentService().getCurrentSyncs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static List<SyncInfo> getCurrentSyncsAsUser(int userId) {
        try {
            return ContentResolver.getContentService().getCurrentSyncsAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public static SyncStatusInfo getSyncStatus(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getSyncStatus(account, authority, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static SyncStatusInfo getSyncStatusAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().getSyncStatusAsUser(account, authority, null, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isSyncPending(Account account, String authority) {
        return ContentResolver.isSyncPendingAsUser(account, authority, UserHandle.myUserId());
    }

    public static boolean isSyncPendingAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().isSyncPendingAsUser(account, authority, null, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static Object addStatusChangeListener(int mask, final SyncStatusObserver callback) {
        if (callback == null) {
            throw new IllegalArgumentException("you passed in a null callback");
        }
        try {
            ISyncStatusObserver.Stub observer = new ISyncStatusObserver.Stub(){

                @Override
                public void onStatusChanged(int which) throws RemoteException {
                    callback.onStatusChanged(which);
                }
            };
            ContentResolver.getContentService().addStatusChangeListener(mask, observer);
            return observer;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void removeStatusChangeListener(Object handle) {
        if (handle == null) {
            throw new IllegalArgumentException("you passed in a null handle");
        }
        try {
            ContentResolver.getContentService().removeStatusChangeListener((ISyncStatusObserver.Stub)handle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CACHE_CONTENT")
    public void putCache(Uri key, Bundle value) {
        try {
            ContentResolver.getContentService().putCache(this.mContext.getPackageName(), key, value, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CACHE_CONTENT")
    public Bundle getCache(Uri key) {
        try {
            Bundle bundle = ContentResolver.getContentService().getCache(this.mContext.getPackageName(), key, this.mContext.getUserId());
            if (bundle != null) {
                bundle.setClassLoader(this.mContext.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    private int samplePercentForDuration(long durationMillis) {
        if (durationMillis >= (long)SLOW_THRESHOLD_MILLIS) {
            return 100;
        }
        return (int)(100L * durationMillis / (long)SLOW_THRESHOLD_MILLIS) + 1;
    }

    private void maybeLogQueryToEventLog(long durationMillis, Uri uri, String[] projection, Bundle queryArgs) {
    }

    private void maybeLogUpdateToEventLog(long durationMillis, Uri uri, String operation, String selection) {
    }

    @UnsupportedAppUsage
    public static IContentService getContentService() {
        if (sContentService != null) {
            return sContentService;
        }
        IBinder b = ServiceManager.getService("content");
        sContentService = IContentService.Stub.asInterface(b);
        return sContentService;
    }

    @UnsupportedAppUsage
    public String getPackageName() {
        return this.mContext.getOpPackageName();
    }

    public String getAttributionTag() {
        return this.mContext.getAttributionTag();
    }

    public AttributionSource getAttributionSource() {
        return this.mContext.getAttributionSource();
    }

    public int resolveUserId(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, this.mContext.getUserId());
    }

    public int getUserId() {
        return this.mContext.getUserId();
    }

    @Deprecated
    public Drawable getTypeDrawable(String mimeType) {
        return this.getTypeInfo(mimeType).getIcon().loadDrawable(this.mContext);
    }

    public MimeTypeInfo getTypeInfo(String mimeType) {
        Objects.requireNonNull(mimeType);
        return MimeIconUtils.getTypeInfo(mimeType);
    }

    public static Bundle createSqlQueryBundle(String selection, String[] selectionArgs) {
        return ContentResolver.createSqlQueryBundle(selection, selectionArgs, null);
    }

    public static Bundle createSqlQueryBundle(String selection, String[] selectionArgs, String sortOrder) {
        if (selection == null && selectionArgs == null && sortOrder == null) {
            return null;
        }
        Bundle queryArgs = new Bundle();
        if (selection != null) {
            queryArgs.putString(QUERY_ARG_SQL_SELECTION, selection);
        }
        if (selectionArgs != null) {
            queryArgs.putStringArray(QUERY_ARG_SQL_SELECTION_ARGS, selectionArgs);
        }
        if (sortOrder != null) {
            queryArgs.putString(QUERY_ARG_SQL_SORT_ORDER, sortOrder);
        }
        return queryArgs;
    }

    public static Bundle includeSqlSelectionArgs(Bundle queryArgs, String selection, String[] selectionArgs) {
        if (selection != null) {
            queryArgs.putString(QUERY_ARG_SQL_SELECTION, selection);
        }
        if (selectionArgs != null) {
            queryArgs.putStringArray(QUERY_ARG_SQL_SELECTION_ARGS, selectionArgs);
        }
        return queryArgs;
    }

    public static String createSqlSortClause(Bundle queryArgs) {
        int sortDir;
        Object[] columns = queryArgs.getStringArray(QUERY_ARG_SORT_COLUMNS);
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("Can't create sort clause without columns.");
        }
        String query = TextUtils.join((CharSequence)", ", columns);
        int collation = queryArgs.getInt(QUERY_ARG_SORT_COLLATION, 3);
        if (collation == 0 || collation == 1) {
            query = query + " COLLATE NOCASE";
        }
        if ((sortDir = queryArgs.getInt(QUERY_ARG_SORT_DIRECTION, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            switch (sortDir) {
                case 0: {
                    query = query + " ASC";
                    break;
                }
                case 1: {
                    query = query + " DESC";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported sort direction value. See ContentResolver documentation for details.");
                }
            }
        }
        return query;
    }

    public Bitmap loadThumbnail(Uri uri, Size size, CancellationSignal signal) throws IOException {
        return ContentResolver.loadThumbnail(this, uri, size, signal, 1);
    }

    public static Bitmap loadThumbnail(ContentInterface content, Uri uri, Size size, CancellationSignal signal, int allocator) throws IOException {
        Objects.requireNonNull(content);
        Objects.requireNonNull(uri);
        Objects.requireNonNull(size);
        Bundle opts = new Bundle();
        opts.putParcelable(EXTRA_SIZE, new Point(size.getWidth(), size.getHeight()));
        Int64Ref orientation = new Int64Ref(0L);
        Bitmap bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(() -> {
            AssetFileDescriptor afd = content.openTypedAssetFile(uri, "image/*", opts, signal);
            Bundle extras = afd.getExtras();
            orientation.value = extras != null ? (long)extras.getInt("android.provider.extra.ORIENTATION", 0) : 0L;
            return afd;
        }), (decoder, info, source) -> {
            int heightSample;
            int widthSample;
            int sample;
            decoder.setAllocator(allocator);
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if ((sample = Math.max(widthSample = info.getSize().getWidth() / size.getWidth(), heightSample = info.getSize().getHeight() / size.getHeight())) > 1) {
                decoder.setTargetSampleSize(sample);
            }
        });
        if (orientation.value != 0L) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix m = new Matrix();
            m.setRotate(orientation.value, width / 2, height / 2);
            bitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, m, false);
        }
        return bitmap;
    }

    public static void onDbCorruption(String tag, String message, Throwable stacktrace) {
        try {
            ContentResolver.getContentService().onDbCorruption(tag, message, Log.getStackTraceString(stacktrace));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"StreamFiles"})
    public static Uri decodeFromFile(File file) {
        return ContentResolver.translateDeprecatedDataPath(file.getAbsolutePath());
    }

    @SystemApi
    @SuppressLint(value={"StreamFiles"})
    public static File encodeToFile(Uri uri) {
        return new File(ContentResolver.translateDeprecatedDataPath(uri));
    }

    public static Uri translateDeprecatedDataPath(String path) {
        String ssp = "//" + path.substring(DEPRECATE_DATA_PREFIX.length());
        return Uri.parse(new Uri.Builder().scheme("content").encodedOpaquePart(ssp).build().toString());
    }

    public static String translateDeprecatedDataPath(Uri uri) {
        return DEPRECATE_DATA_PREFIX + uri.getEncodedSchemeSpecificPart().substring(2);
    }

    public static class MimeTypeInfo {
        private final Icon mIcon;
        private final CharSequence mLabel;
        private final CharSequence mContentDescription;

        public MimeTypeInfo(Icon icon, CharSequence label, CharSequence contentDescription) {
            this.mIcon = Objects.requireNonNull(icon);
            this.mLabel = Objects.requireNonNull(label);
            this.mContentDescription = Objects.requireNonNull(contentDescription);
        }

        public Icon getIcon() {
            return this.mIcon;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }
    }

    private class ParcelFileDescriptorInner
    extends ParcelFileDescriptor {
        private final IContentProvider mContentProvider;
        private final AtomicBoolean mProviderReleased;

        ParcelFileDescriptorInner(ParcelFileDescriptor pfd, IContentProvider icp) {
            super(pfd);
            this.mProviderReleased = new AtomicBoolean();
            this.mContentProvider = icp;
        }

        @Override
        public void releaseResources() {
            if (this.mProviderReleased.compareAndSet(false, true)) {
                ContentResolver.this.releaseProvider(this.mContentProvider);
            }
        }
    }

    private class CursorWrapperInner
    extends CrossProcessCursorWrapper {
        private final IContentProvider mContentProvider;
        private final AtomicBoolean mProviderReleased;
        private final CloseGuard mCloseGuard;

        CursorWrapperInner(Cursor cursor, IContentProvider contentProvider) {
            super(cursor);
            this.mProviderReleased = new AtomicBoolean();
            this.mCloseGuard = CloseGuard.get();
            this.mContentProvider = contentProvider;
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            this.mCloseGuard.close();
            super.close();
            if (this.mProviderReleased.compareAndSet(false, true)) {
                ContentResolver.this.releaseProvider(this.mContentProvider);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    public class OpenResourceIdResult {
        @UnsupportedAppUsage
        public Resources r;
        @UnsupportedAppUsage
        public int id;
    }

    private static class UriResultListener
    extends ResultListener<Uri> {
        private UriResultListener() {
        }

        @Override
        protected Uri getResultFromBundle(Bundle result) {
            return (Uri)result.getParcelable(ContentResolver.REMOTE_CALLBACK_RESULT);
        }
    }

    private static class StringResultListener
    extends ResultListener<String> {
        private StringResultListener() {
        }

        @Override
        protected String getResultFromBundle(Bundle result) {
            return result.getString(ContentResolver.REMOTE_CALLBACK_RESULT);
        }
    }

    private static abstract class ResultListener<T>
    implements RemoteCallback.OnResultListener {
        @GuardedBy(value={"this"})
        public boolean done;
        @GuardedBy(value={"this"})
        public T result;
        @GuardedBy(value={"this"})
        public RuntimeException exception;

        private ResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(Bundle result) {
            ResultListener resultListener = this;
            synchronized (resultListener) {
                ParcelableException e = (ParcelableException)result.getParcelable(ContentResolver.REMOTE_CALLBACK_ERROR);
                if (e != null) {
                    Throwable t = e.getCause();
                    this.exception = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
                } else {
                    this.result = this.getResultFromBundle(result);
                }
                this.done = true;
                this.notifyAll();
            }
        }

        protected abstract T getResultFromBundle(Bundle var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForResult(long timeout) {
            ResultListener resultListener = this;
            synchronized (resultListener) {
                if (!this.done) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SyncExemption {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QueryCollator {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SortDirection {
    }
}

