/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.permission.IPermissionChecker;
import android.permission.PermissionCheckerManager;

public class PermissionChecker {
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_SOFT_DENIED = 1;
    public static final int PERMISSION_HARD_DENIED = 2;
    public static final int PID_UNKNOWN = -1;
    private static volatile IPermissionChecker sService;

    private PermissionChecker() {
    }

    public static int checkPermissionForDataDelivery(Context context, String permission2, int pid, int uid, String packageName, String attributionTag, String message, boolean startDataDelivery) {
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, pid, new AttributionSource(uid, packageName, attributionTag), message, startDataDelivery);
    }

    public static int checkPermissionForDataDelivery(Context context, String permission2, int pid, int uid, String packageName, String attributionTag, String message) {
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, pid, uid, packageName, attributionTag, message, false);
    }

    public static int checkPermissionForDataDeliveryFromDataSource(Context context, String permission2, int pid, AttributionSource attributionSource, String message) {
        return PermissionChecker.checkPermissionForDataDeliveryCommon(context, permission2, attributionSource, message, false, true);
    }

    public static int checkPermissionForDataDelivery(Context context, String permission2, int pid, AttributionSource attributionSource, String message) {
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, pid, attributionSource, message, false);
    }

    public static int checkPermissionForDataDelivery(Context context, String permission2, int pid, AttributionSource attributionSource, String message, boolean startDataDelivery) {
        return PermissionChecker.checkPermissionForDataDeliveryCommon(context, permission2, attributionSource, message, startDataDelivery, false);
    }

    private static int checkPermissionForDataDeliveryCommon(Context context, String permission2, AttributionSource attributionSource, String message, boolean startDataDelivery, boolean fromDatasource) {
        return context.getSystemService(PermissionCheckerManager.class).checkPermission(permission2, attributionSource.asState(), message, true, startDataDelivery, fromDatasource, -1);
    }

    public static int checkPermissionAndStartDataDelivery(Context context, String permission2, AttributionSource attributionSource, String message) {
        return context.getSystemService(PermissionCheckerManager.class).checkPermission(permission2, attributionSource.asState(), message, true, true, false, -1);
    }

    public static int startOpForDataDelivery(Context context, String opName, AttributionSource attributionSource, String message) {
        return context.getSystemService(PermissionCheckerManager.class).checkOp(AppOpsManager.strOpToOp(opName), attributionSource.asState(), message, true, true);
    }

    public static void finishDataDelivery(Context context, String op, AttributionSource attributionSource) {
        context.getSystemService(PermissionCheckerManager.class).finishDataDelivery(AppOpsManager.strOpToOp(op), attributionSource.asState(), false);
    }

    public static void finishDataDeliveryFromDatasource(Context context, String op, AttributionSource attributionSource) {
        context.getSystemService(PermissionCheckerManager.class).finishDataDelivery(AppOpsManager.strOpToOp(op), attributionSource.asState(), true);
    }

    public static int checkOpForPreflight(Context context, String opName, AttributionSource attributionSource, String message) {
        return context.getSystemService(PermissionCheckerManager.class).checkOp(AppOpsManager.strOpToOp(opName), attributionSource.asState(), message, false, false);
    }

    public static int checkOpForDataDelivery(Context context, String opName, AttributionSource attributionSource, String message) {
        return context.getSystemService(PermissionCheckerManager.class).checkOp(AppOpsManager.strOpToOp(opName), attributionSource.asState(), message, true, false);
    }

    public static int checkPermissionForPreflight(Context context, String permission2, int pid, int uid, String packageName) {
        return PermissionChecker.checkPermissionForPreflight(context, permission2, new AttributionSource(uid, packageName, null));
    }

    public static int checkPermissionForPreflight(Context context, String permission2, AttributionSource attributionSource) {
        return context.getSystemService(PermissionCheckerManager.class).checkPermission(permission2, attributionSource.asState(), null, false, false, false, -1);
    }

    public static int checkSelfPermissionForDataDelivery(Context context, String permission2, String message) {
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName(), context.getAttributionTag(), message, false);
    }

    public static int checkSelfPermissionForPreflight(Context context, String permission2) {
        return PermissionChecker.checkPermissionForPreflight(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName());
    }

    public static int checkCallingPermissionForDataDelivery(Context context, String permission2, String callingPackageName, String callingAttributionTag, String message) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return 2;
        }
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), callingPackageName, callingAttributionTag, message, false);
    }

    public static int checkCallingPermissionForPreflight(Context context, String permission2, String packageName) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return 2;
        }
        return PermissionChecker.checkPermissionForPreflight(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    public static int checkCallingOrSelfPermissionForDataDelivery(Context context, String permission2, String callingPackageName, String callingAttributionTag, String message) {
        callingPackageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : callingPackageName;
        callingAttributionTag = Binder.getCallingPid() == Process.myPid() ? context.getAttributionTag() : callingAttributionTag;
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), callingPackageName, callingAttributionTag, message, false);
    }

    public static int checkCallingOrSelfPermissionForPreflight(Context context, String permission2) {
        String packageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : null;
        return PermissionChecker.checkPermissionForPreflight(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }
}

