/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.provider.DeviceConfig;
import android.util.Slog;
import java.util.Arrays;
import java.util.List;

public class ConstrainDisplayApisConfig {
    private static final String TAG = ConstrainDisplayApisConfig.class.getSimpleName();
    private static final String FLAG_NEVER_CONSTRAIN_DISPLAY_APIS = "never_constrain_display_apis";
    private static final String FLAG_NEVER_CONSTRAIN_DISPLAY_APIS_ALL_PACKAGES = "never_constrain_display_apis_all_packages";
    private static final String FLAG_ALWAYS_CONSTRAIN_DISPLAY_APIS = "always_constrain_display_apis";

    public static boolean neverConstrainDisplayApis(ApplicationInfo applicationInfo) {
        if (DeviceConfig.getBoolean("constrain_display_apis", FLAG_NEVER_CONSTRAIN_DISPLAY_APIS_ALL_PACKAGES, false)) {
            return true;
        }
        return ConstrainDisplayApisConfig.flagHasMatchingPackageEntry(FLAG_NEVER_CONSTRAIN_DISPLAY_APIS, applicationInfo);
    }

    public static boolean alwaysConstrainDisplayApis(ApplicationInfo applicationInfo) {
        return ConstrainDisplayApisConfig.flagHasMatchingPackageEntry(FLAG_ALWAYS_CONSTRAIN_DISPLAY_APIS, applicationInfo);
    }

    private static boolean flagHasMatchingPackageEntry(String flagName, ApplicationInfo applicationInfo) {
        String configStr = DeviceConfig.getString("constrain_display_apis", flagName, "");
        if (configStr.isEmpty()) {
            return false;
        }
        for (String packageEntryString : configStr.split(",")) {
            if (!ConstrainDisplayApisConfig.matchesApplicationInfo(packageEntryString, applicationInfo)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesApplicationInfo(String packageEntryStr, ApplicationInfo applicationInfo) {
        List<String> packageAndVersions = Arrays.asList(packageEntryStr.split(":", 3));
        if (packageAndVersions.size() != 3) {
            Slog.w(TAG, "Invalid package entry in flag 'never_constrain_display_apis': " + packageEntryStr);
            return false;
        }
        String packageName = packageAndVersions.get(0);
        String minVersionCodeStr = packageAndVersions.get(1);
        String maxVersionCodeStr = packageAndVersions.get(2);
        if (!packageName.equals(applicationInfo.packageName)) {
            return false;
        }
        long version = applicationInfo.longVersionCode;
        try {
            if (!minVersionCodeStr.isEmpty() && version < Long.parseLong(minVersionCodeStr)) {
                return false;
            }
            if (!maxVersionCodeStr.isEmpty() && version > Long.parseLong(maxVersionCodeStr)) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Invalid APK version code in package entry: " + packageEntryStr);
            return false;
        }
        return true;
    }
}

