/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ShortcutInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.List;

public interface IShortcutChangeCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.IShortcutChangeCallback";

    public void onShortcutsAddedOrUpdated(String var1, List<ShortcutInfo> var2, UserHandle var3) throws RemoteException;

    public void onShortcutsRemoved(String var1, List<ShortcutInfo> var2, UserHandle var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IShortcutChangeCallback {
        static final int TRANSACTION_onShortcutsAddedOrUpdated = 1;
        static final int TRANSACTION_onShortcutsRemoved = 2;

        public Stub() {
            this.attachInterface(this, IShortcutChangeCallback.DESCRIPTOR);
        }

        public static IShortcutChangeCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IShortcutChangeCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IShortcutChangeCallback) {
                return (IShortcutChangeCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onShortcutsAddedOrUpdated";
                }
                case 2: {
                    return "onShortcutsRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IShortcutChangeCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ArrayList<ShortcutInfo> _arg1 = data.createTypedArrayList(ShortcutInfo.CREATOR);
                    UserHandle _arg2 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    this.onShortcutsAddedOrUpdated(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ArrayList<ShortcutInfo> _arg1 = data.createTypedArrayList(ShortcutInfo.CREATOR);
                    UserHandle _arg2 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    this.onShortcutsRemoved(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IShortcutChangeCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IShortcutChangeCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IShortcutChangeCallback {
            private IBinder mRemote;
            public static IShortcutChangeCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IShortcutChangeCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onShortcutsAddedOrUpdated(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IShortcutChangeCallback.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedList(shortcuts);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onShortcutsAddedOrUpdated(packageName, shortcuts, user);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onShortcutsRemoved(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IShortcutChangeCallback.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedList(shortcuts);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onShortcutsRemoved(packageName, shortcuts, user);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IShortcutChangeCallback {
        @Override
        public void onShortcutsAddedOrUpdated(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) throws RemoteException {
        }

        @Override
        public void onShortcutsRemoved(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

