/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.pm.ComponentInfo;
import android.content.pm.SuspendDialogInfo;
import android.content.pm.overlay.OverlayPaths;
import android.content.pm.parsing.ParsingPackageRead;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.os.BaseBundle;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import android.util.Slog;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class PackageUserState {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "PackageUserState";
    public long ceDataInode;
    public boolean installed;
    public boolean stopped;
    public boolean notLaunched;
    public boolean hidden;
    public int distractionFlags;
    public boolean suspended;
    public ArrayMap<String, SuspendParams> suspendParams;
    public boolean instantApp;
    public boolean virtualPreload;
    public int enabled;
    public String lastDisableAppCaller;
    public int categoryHint = -1;
    public int installReason;
    public int uninstallReason;
    public String harmfulAppWarning;
    public String splashScreenTheme;
    public ArraySet<String> disabledComponents;
    public ArraySet<String> enabledComponents;
    private OverlayPaths overlayPaths;
    private ArrayMap<String, OverlayPaths> sharedLibraryOverlayPaths;
    private OverlayPaths cachedOverlayPaths;
    private ArrayMap<ComponentName, Pair<String, Integer>> componentLabelIconOverrideMap;

    @UnsupportedAppUsage
    public PackageUserState() {
        this.installed = true;
        this.hidden = false;
        this.suspended = false;
        this.enabled = 0;
        this.installReason = 0;
        this.uninstallReason = 0;
    }

    @VisibleForTesting
    public PackageUserState(PackageUserState o) {
        this.ceDataInode = o.ceDataInode;
        this.installed = o.installed;
        this.stopped = o.stopped;
        this.notLaunched = o.notLaunched;
        this.hidden = o.hidden;
        this.distractionFlags = o.distractionFlags;
        this.suspended = o.suspended;
        this.suspendParams = new ArrayMap<String, SuspendParams>(o.suspendParams);
        this.instantApp = o.instantApp;
        this.virtualPreload = o.virtualPreload;
        this.enabled = o.enabled;
        this.lastDisableAppCaller = o.lastDisableAppCaller;
        this.categoryHint = o.categoryHint;
        this.installReason = o.installReason;
        this.uninstallReason = o.uninstallReason;
        this.disabledComponents = ArrayUtils.cloneOrNull(o.disabledComponents);
        this.enabledComponents = ArrayUtils.cloneOrNull(o.enabledComponents);
        this.overlayPaths = o.overlayPaths;
        if (o.sharedLibraryOverlayPaths != null) {
            this.sharedLibraryOverlayPaths = new ArrayMap<String, OverlayPaths>(o.sharedLibraryOverlayPaths);
        }
        this.harmfulAppWarning = o.harmfulAppWarning;
        if (o.componentLabelIconOverrideMap != null) {
            this.componentLabelIconOverrideMap = new ArrayMap<ComponentName, Pair<String, Integer>>(o.componentLabelIconOverrideMap);
        }
        this.splashScreenTheme = o.splashScreenTheme;
    }

    public OverlayPaths getOverlayPaths() {
        return this.overlayPaths;
    }

    public Map<String, OverlayPaths> getSharedLibraryOverlayPaths() {
        return this.sharedLibraryOverlayPaths;
    }

    public boolean setOverlayPaths(OverlayPaths paths) {
        if (Objects.equals(paths, this.overlayPaths)) {
            return false;
        }
        if (this.overlayPaths == null && paths.isEmpty() || paths == null && this.overlayPaths.isEmpty()) {
            return false;
        }
        this.overlayPaths = paths;
        this.cachedOverlayPaths = null;
        return true;
    }

    public boolean setSharedLibraryOverlayPaths(String library, OverlayPaths paths) {
        OverlayPaths currentPaths;
        if (this.sharedLibraryOverlayPaths == null) {
            this.sharedLibraryOverlayPaths = new ArrayMap();
        }
        if (Objects.equals(paths, currentPaths = this.sharedLibraryOverlayPaths.get(library))) {
            return false;
        }
        this.cachedOverlayPaths = null;
        if (paths == null || paths.isEmpty()) {
            return this.sharedLibraryOverlayPaths.remove(library) != null;
        }
        this.sharedLibraryOverlayPaths.put(library, paths);
        return true;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean overrideLabelAndIcon(ComponentName component, String nonLocalizedLabel, Integer icon) {
        boolean changed;
        Pair<String, Integer> pair;
        String existingLabel = null;
        Integer existingIcon = null;
        if (this.componentLabelIconOverrideMap != null && (pair = this.componentLabelIconOverrideMap.get(component)) != null) {
            existingLabel = (String)pair.first;
            existingIcon = (Integer)pair.second;
        }
        boolean bl = changed = !TextUtils.equals(existingLabel, nonLocalizedLabel) || !Objects.equals(existingIcon, icon);
        if (changed) {
            if (nonLocalizedLabel == null && icon == null) {
                this.componentLabelIconOverrideMap.remove(component);
                if (this.componentLabelIconOverrideMap.isEmpty()) {
                    this.componentLabelIconOverrideMap = null;
                }
            } else {
                if (this.componentLabelIconOverrideMap == null) {
                    this.componentLabelIconOverrideMap = new ArrayMap(1);
                }
                this.componentLabelIconOverrideMap.put(component, Pair.create(nonLocalizedLabel, icon));
            }
        }
        return changed;
    }

    public void resetOverrideComponentLabelIcon() {
        this.componentLabelIconOverrideMap = null;
    }

    public Pair<String, Integer> getOverrideLabelIconForComponent(ComponentName componentName) {
        if (ArrayUtils.isEmpty(this.componentLabelIconOverrideMap)) {
            return null;
        }
        return this.componentLabelIconOverrideMap.get(componentName);
    }

    public boolean isAvailable(int flags) {
        boolean matchAnyUser = (flags & 0x400000) != 0;
        boolean matchUninstalled = (flags & 0x2000) != 0;
        return matchAnyUser || this.installed && (!this.hidden || matchUninstalled);
    }

    public boolean isMatch(ComponentInfo componentInfo, int flags) {
        return this.isMatch(componentInfo.applicationInfo.isSystemApp(), componentInfo.applicationInfo.enabled, componentInfo.enabled, componentInfo.directBootAware, componentInfo.name, flags);
    }

    public boolean isMatch(boolean isSystem, boolean isPackageEnabled, ParsedMainComponent component, int flags) {
        return this.isMatch(isSystem, isPackageEnabled, component.isEnabled(), component.isDirectBootAware(), component.getName(), flags);
    }

    public boolean isMatch(boolean isSystem, boolean isPackageEnabled, boolean isComponentEnabled, boolean isComponentDirectBootAware, String componentName, int flags) {
        boolean matchUninstalled;
        boolean bl = matchUninstalled = (flags & 0x402000) != 0;
        if (!(this.isAvailable(flags) || isSystem && matchUninstalled)) {
            return this.reportIfDebug(false, flags);
        }
        if (!this.isEnabled(isPackageEnabled, isComponentEnabled, componentName, flags)) {
            return this.reportIfDebug(false, flags);
        }
        if ((flags & 0x100000) != 0 && !isSystem) {
            return this.reportIfDebug(false, flags);
        }
        boolean matchesUnaware = (flags & 0x40000) != 0 && !isComponentDirectBootAware;
        boolean matchesAware = (flags & 0x80000) != 0 && isComponentDirectBootAware;
        return this.reportIfDebug(matchesUnaware || matchesAware, flags);
    }

    public boolean reportIfDebug(boolean result, int flags) {
        return result;
    }

    public boolean isPackageEnabled(ParsingPackageRead pkg) {
        switch (this.enabled) {
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return pkg.isEnabled();
    }

    public boolean isEnabled(ComponentInfo componentInfo, int flags) {
        return this.isEnabled(componentInfo.applicationInfo.enabled, componentInfo.enabled, componentInfo.name, flags);
    }

    public boolean isEnabled(boolean isPackageEnabled, ParsedMainComponent parsedComponent, int flags) {
        return this.isEnabled(isPackageEnabled, parsedComponent.isEnabled(), parsedComponent.getName(), flags);
    }

    public boolean isEnabled(boolean isPackageEnabled, boolean isComponentEnabled, String componentName, int flags) {
        if ((flags & 0x200) != 0) {
            return true;
        }
        switch (this.enabled) {
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                if ((flags & 0x8000) == 0) {
                    return false;
                }
            }
            case 0: {
                if (isPackageEnabled) break;
                return false;
            }
        }
        if (ArrayUtils.contains(this.enabledComponents, componentName)) {
            return true;
        }
        if (ArrayUtils.contains(this.disabledComponents, componentName)) {
            return false;
        }
        return isComponentEnabled;
    }

    public OverlayPaths getAllOverlayPaths() {
        if (this.overlayPaths == null && this.sharedLibraryOverlayPaths == null) {
            return null;
        }
        if (this.cachedOverlayPaths != null) {
            return this.cachedOverlayPaths;
        }
        OverlayPaths.Builder newPaths = new OverlayPaths.Builder();
        newPaths.addAll(this.overlayPaths);
        if (this.sharedLibraryOverlayPaths != null) {
            for (OverlayPaths libOverlayPaths : this.sharedLibraryOverlayPaths.values()) {
                newPaths.addAll(libOverlayPaths);
            }
        }
        this.cachedOverlayPaths = newPaths.build();
        return this.cachedOverlayPaths;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof PackageUserState)) {
            return false;
        }
        PackageUserState oldState = (PackageUserState)obj;
        if (this.ceDataInode != oldState.ceDataInode) {
            return false;
        }
        if (this.installed != oldState.installed) {
            return false;
        }
        if (this.stopped != oldState.stopped) {
            return false;
        }
        if (this.notLaunched != oldState.notLaunched) {
            return false;
        }
        if (this.hidden != oldState.hidden) {
            return false;
        }
        if (this.distractionFlags != oldState.distractionFlags) {
            return false;
        }
        if (this.suspended != oldState.suspended) {
            return false;
        }
        if (this.suspended && !Objects.equals(this.suspendParams, oldState.suspendParams)) {
            return false;
        }
        if (this.instantApp != oldState.instantApp) {
            return false;
        }
        if (this.virtualPreload != oldState.virtualPreload) {
            return false;
        }
        if (this.enabled != oldState.enabled) {
            return false;
        }
        if (this.lastDisableAppCaller == null && oldState.lastDisableAppCaller != null || this.lastDisableAppCaller != null && !this.lastDisableAppCaller.equals(oldState.lastDisableAppCaller)) {
            return false;
        }
        if (this.categoryHint != oldState.categoryHint) {
            return false;
        }
        if (this.installReason != oldState.installReason) {
            return false;
        }
        if (this.uninstallReason != oldState.uninstallReason) {
            return false;
        }
        if (this.disabledComponents == null && oldState.disabledComponents != null || this.disabledComponents != null && oldState.disabledComponents == null) {
            return false;
        }
        if (this.disabledComponents != null) {
            if (this.disabledComponents.size() != oldState.disabledComponents.size()) {
                return false;
            }
            for (i = this.disabledComponents.size() - 1; i >= 0; --i) {
                if (oldState.disabledComponents.contains(this.disabledComponents.valueAt(i))) continue;
                return false;
            }
        }
        if (this.enabledComponents == null && oldState.enabledComponents != null || this.enabledComponents != null && oldState.enabledComponents == null) {
            return false;
        }
        if (this.enabledComponents != null) {
            if (this.enabledComponents.size() != oldState.enabledComponents.size()) {
                return false;
            }
            for (i = this.enabledComponents.size() - 1; i >= 0; --i) {
                if (oldState.enabledComponents.contains(this.enabledComponents.valueAt(i))) continue;
                return false;
            }
        }
        if (this.harmfulAppWarning == null && oldState.harmfulAppWarning != null || this.harmfulAppWarning != null && !this.harmfulAppWarning.equals(oldState.harmfulAppWarning)) {
            return false;
        }
        return Objects.equals(this.splashScreenTheme, oldState.splashScreenTheme);
    }

    public int hashCode() {
        int hashCode = Long.hashCode(this.ceDataInode);
        hashCode = 31 * hashCode + Boolean.hashCode(this.installed);
        hashCode = 31 * hashCode + Boolean.hashCode(this.stopped);
        hashCode = 31 * hashCode + Boolean.hashCode(this.notLaunched);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hidden);
        hashCode = 31 * hashCode + this.distractionFlags;
        hashCode = 31 * hashCode + Boolean.hashCode(this.suspended);
        hashCode = 31 * hashCode + Objects.hashCode(this.suspendParams);
        hashCode = 31 * hashCode + Boolean.hashCode(this.instantApp);
        hashCode = 31 * hashCode + Boolean.hashCode(this.virtualPreload);
        hashCode = 31 * hashCode + this.enabled;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDisableAppCaller);
        hashCode = 31 * hashCode + this.categoryHint;
        hashCode = 31 * hashCode + this.installReason;
        hashCode = 31 * hashCode + this.uninstallReason;
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledComponents);
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledComponents);
        hashCode = 31 * hashCode + Objects.hashCode(this.harmfulAppWarning);
        hashCode = 31 * hashCode + Objects.hashCode(this.splashScreenTheme);
        return hashCode;
    }

    public static class SuspendParams {
        private static final String TAG_DIALOG_INFO = "dialog-info";
        private static final String TAG_APP_EXTRAS = "app-extras";
        private static final String TAG_LAUNCHER_EXTRAS = "launcher-extras";
        public SuspendDialogInfo dialogInfo;
        public PersistableBundle appExtras;
        public PersistableBundle launcherExtras;

        private SuspendParams() {
        }

        public static SuspendParams getInstanceOrNull(SuspendDialogInfo dialogInfo, PersistableBundle appExtras, PersistableBundle launcherExtras) {
            if (dialogInfo == null && appExtras == null && launcherExtras == null) {
                return null;
            }
            SuspendParams instance = new SuspendParams();
            instance.dialogInfo = dialogInfo;
            instance.appExtras = appExtras;
            instance.launcherExtras = launcherExtras;
            return instance;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SuspendParams)) {
                return false;
            }
            SuspendParams other = (SuspendParams)obj;
            if (!Objects.equals(this.dialogInfo, other.dialogInfo)) {
                return false;
            }
            if (!BaseBundle.kindofEquals(this.appExtras, other.appExtras)) {
                return false;
            }
            return BaseBundle.kindofEquals(this.launcherExtras, other.launcherExtras);
        }

        public int hashCode() {
            int hashCode = Objects.hashCode(this.dialogInfo);
            hashCode = 31 * hashCode + (this.appExtras != null ? this.appExtras.size() : 0);
            hashCode = 31 * hashCode + (this.launcherExtras != null ? this.launcherExtras.size() : 0);
            return hashCode;
        }

        public void saveToXml(TypedXmlSerializer out) throws IOException {
            if (this.dialogInfo != null) {
                out.startTag(null, TAG_DIALOG_INFO);
                this.dialogInfo.saveToXml(out);
                out.endTag(null, TAG_DIALOG_INFO);
            }
            if (this.appExtras != null) {
                out.startTag(null, TAG_APP_EXTRAS);
                try {
                    this.appExtras.saveToXml(out);
                }
                catch (XmlPullParserException e) {
                    Slog.e(PackageUserState.LOG_TAG, "Exception while trying to write appExtras. Will be lost on reboot", e);
                }
                out.endTag(null, TAG_APP_EXTRAS);
            }
            if (this.launcherExtras != null) {
                out.startTag(null, TAG_LAUNCHER_EXTRAS);
                try {
                    this.launcherExtras.saveToXml(out);
                }
                catch (XmlPullParserException e) {
                    Slog.e(PackageUserState.LOG_TAG, "Exception while trying to write launcherExtras. Will be lost on reboot", e);
                }
                out.endTag(null, TAG_LAUNCHER_EXTRAS);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static SuspendParams restoreFromXml(TypedXmlPullParser in) throws IOException {
            SuspendDialogInfo readDialogInfo = null;
            PersistableBundle readAppExtras = null;
            PersistableBundle readLauncherExtras = null;
            int currentDepth = in.getDepth();
            try {
                int type;
                block12: while ((type = in.next()) != 1 && (type != 3 || in.getDepth() > currentDepth)) {
                    if (type == 3 || type == 4) continue;
                    switch (in.getName()) {
                        case "dialog-info": {
                            readDialogInfo = SuspendDialogInfo.restoreFromXml(in);
                            continue block12;
                        }
                        case "app-extras": {
                            readAppExtras = PersistableBundle.restoreFromXml(in);
                            continue block12;
                        }
                        case "launcher-extras": {
                            readLauncherExtras = PersistableBundle.restoreFromXml(in);
                            continue block12;
                        }
                    }
                    Slog.w(PackageUserState.LOG_TAG, "Unknown tag " + in.getName() + " in SuspendParams. Ignoring");
                }
                return SuspendParams.getInstanceOrNull(readDialogInfo, readAppExtras, readLauncherExtras);
            }
            catch (XmlPullParserException e) {
                Slog.e(PackageUserState.LOG_TAG, "Exception while trying to parse SuspendParams, some fields may default", e);
            }
            return SuspendParams.getInstanceOrNull(readDialogInfo, readAppExtras, readLauncherExtras);
        }
    }
}

