/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.content.pm.PackageInfo;
import android.content.pm.PackageParser;
import android.content.pm.VerifierInfo;
import java.util.List;

public class ApkLite {
    private final String mPackageName;
    private final String mPath;
    private final String mSplitName;
    private final String mUsesSplitName;
    private final String mConfigForSplit;
    private final int mVersionCodeMajor;
    private final int mVersionCode;
    private final int mRevisionCode;
    private final int mInstallLocation;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private final VerifierInfo[] mVerifiers;
    private final PackageParser.SigningDetails mSigningDetails;
    private final boolean mFeatureSplit;
    private final boolean mIsolatedSplits;
    private final boolean mSplitRequired;
    private final boolean mCoreApp;
    private final boolean mDebuggable;
    private final boolean mProfileableByShell;
    private final boolean mMultiArch;
    private final boolean mUse32bitAbi;
    private final boolean mExtractNativeLibs;
    private final boolean mUseEmbeddedDex;
    private final String mTargetPackageName;
    private final boolean mOverlayIsStatic;
    private final int mOverlayPriority;
    private final int mRollbackDataPolicy;

    public ApkLite(String path, String packageName, String splitName, boolean isFeatureSplit, String configForSplit, String usesSplitName, boolean isSplitRequired, int versionCode, int versionCodeMajor, int revisionCode, int installLocation, List<VerifierInfo> verifiers, PackageParser.SigningDetails signingDetails, boolean coreApp, boolean debuggable, boolean profileableByShell, boolean multiArch, boolean use32bitAbi, boolean useEmbeddedDex, boolean extractNativeLibs, boolean isolatedSplits, String targetPackageName, boolean overlayIsStatic, int overlayPriority, int minSdkVersion, int targetSdkVersion, int rollbackDataPolicy) {
        this.mPath = path;
        this.mPackageName = packageName;
        this.mSplitName = splitName;
        this.mFeatureSplit = isFeatureSplit;
        this.mConfigForSplit = configForSplit;
        this.mUsesSplitName = usesSplitName;
        this.mSplitRequired = isSplitRequired;
        this.mVersionCode = versionCode;
        this.mVersionCodeMajor = versionCodeMajor;
        this.mRevisionCode = revisionCode;
        this.mInstallLocation = installLocation;
        this.mVerifiers = verifiers.toArray(new VerifierInfo[verifiers.size()]);
        this.mSigningDetails = signingDetails;
        this.mCoreApp = coreApp;
        this.mDebuggable = debuggable;
        this.mProfileableByShell = profileableByShell;
        this.mMultiArch = multiArch;
        this.mUse32bitAbi = use32bitAbi;
        this.mUseEmbeddedDex = useEmbeddedDex;
        this.mExtractNativeLibs = extractNativeLibs;
        this.mIsolatedSplits = isolatedSplits;
        this.mTargetPackageName = targetPackageName;
        this.mOverlayIsStatic = overlayIsStatic;
        this.mOverlayPriority = overlayPriority;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion;
        this.mRollbackDataPolicy = rollbackDataPolicy;
    }

    public long getLongVersionCode() {
        return PackageInfo.composeLongVersionCode(this.mVersionCodeMajor, this.mVersionCode);
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getSplitName() {
        return this.mSplitName;
    }

    public String getUsesSplitName() {
        return this.mUsesSplitName;
    }

    public String getConfigForSplit() {
        return this.mConfigForSplit;
    }

    public int getVersionCodeMajor() {
        return this.mVersionCodeMajor;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getRevisionCode() {
        return this.mRevisionCode;
    }

    public int getInstallLocation() {
        return this.mInstallLocation;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public VerifierInfo[] getVerifiers() {
        return this.mVerifiers;
    }

    public PackageParser.SigningDetails getSigningDetails() {
        return this.mSigningDetails;
    }

    public boolean isFeatureSplit() {
        return this.mFeatureSplit;
    }

    public boolean isIsolatedSplits() {
        return this.mIsolatedSplits;
    }

    public boolean isSplitRequired() {
        return this.mSplitRequired;
    }

    public boolean isCoreApp() {
        return this.mCoreApp;
    }

    public boolean isDebuggable() {
        return this.mDebuggable;
    }

    public boolean isProfileableByShell() {
        return this.mProfileableByShell;
    }

    public boolean isMultiArch() {
        return this.mMultiArch;
    }

    public boolean isUse32bitAbi() {
        return this.mUse32bitAbi;
    }

    public boolean isExtractNativeLibs() {
        return this.mExtractNativeLibs;
    }

    public boolean isUseEmbeddedDex() {
        return this.mUseEmbeddedDex;
    }

    public String getTargetPackageName() {
        return this.mTargetPackageName;
    }

    public boolean isOverlayIsStatic() {
        return this.mOverlayIsStatic;
    }

    public int getOverlayPriority() {
        return this.mOverlayPriority;
    }

    public int getRollbackDataPolicy() {
        return this.mRollbackDataPolicy;
    }

    @Deprecated
    private void __metadata() {
    }
}

