/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.PermissionInfo;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedComponentUtils;
import android.content.pm.parsing.component.ParsedPermission;
import android.content.pm.parsing.component.ParsedPermissionGroup;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.Slog;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedPermissionUtils {
    private static final String TAG = "PackageParsing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedPermission> parsePermission(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input) throws IOException, XmlPullParserException {
        String packageName = pkg.getPackageName();
        ParsedPermission permission2 = new ParsedPermission();
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermission);
        try {
            ParseResult<ParsedPermission> result = ParsedComponentUtils.parseComponent(permission2, tag, pkg, sa, useRoundIcon, input, 8, 5, 1, 0, 6, 2, 9);
            if (result.isError()) {
                ParseResult<ParsedPermission> parseResult = result;
                return parseResult;
            }
            if (sa.hasValue(11)) {
                if ("android".equals(packageName)) {
                    permission2.backgroundPermission = sa.getNonResourceString(11);
                } else {
                    Slog.w(TAG, packageName + " defines a background permission. Only the 'android' package can do that.");
                }
            }
            permission2.setGroup(sa.getNonResourceString(4));
            permission2.requestRes = sa.getResourceId(12, 0);
            permission2.protectionLevel = sa.getInt(3, 0);
            permission2.flags = sa.getInt(7, 0);
            int knownCertsResource = sa.getResourceId(10, 0);
            if (knownCertsResource != 0) {
                String resourceType = res.getResourceTypeName(knownCertsResource);
                if (resourceType.equals("array")) {
                    String[] knownCerts = res.getStringArray(knownCertsResource);
                    if (knownCerts != null) {
                        permission2.setKnownCerts(knownCerts);
                    }
                } else {
                    String knownCert = res.getString(knownCertsResource);
                    if (knownCert != null) {
                        permission2.setKnownCert(knownCert);
                    }
                }
                if (permission2.knownCerts == null) {
                    Slog.w(TAG, packageName + " defines a knownSigner permission but the provided knownCerts resource is null");
                }
            } else {
                String knownCert = sa.getString(10);
                if (knownCert != null) {
                    permission2.setKnownCert(knownCert);
                }
            }
            if (!permission2.isRuntime() || !"android".equals(permission2.getPackageName())) {
                permission2.flags &= 0xFFFFFFFB;
                permission2.flags &= 0xFFFFFFF7;
            } else if ((permission2.flags & 4) != 0 && (permission2.flags & 8) != 0) {
                throw new IllegalStateException("Permission cannot be both soft and hard restricted: " + permission2.getName());
            }
        }
        finally {
            sa.recycle();
        }
        permission2.protectionLevel = PermissionInfo.fixProtectionLevel(permission2.protectionLevel);
        int otherProtectionFlags = permission2.getProtectionFlags() & 0xFFFFCFBF;
        if (otherProtectionFlags != 0 && permission2.getProtection() != 2 && permission2.getProtection() != 4) {
            return input.error("<permission> protectionLevel specifies a non-instant, non-appop, non-runtimeOnly flag but is not based on signature or internal type");
        }
        return ComponentParseUtils.parseAllMetaData(pkg, res, parser, tag, permission2, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedPermission> parsePermissionTree(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input) throws IOException, XmlPullParserException {
        ParsedPermission permission2 = new ParsedPermission();
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionTree);
        try {
            ParseResult<ParsedPermission> result = ParsedComponentUtils.parseComponent(permission2, tag, pkg, sa, useRoundIcon, input, 4, null, 1, 0, 3, 2, 5);
            if (result.isError()) {
                ParseResult<ParsedPermission> parseResult = result;
                return parseResult;
            }
        }
        finally {
            sa.recycle();
        }
        int index = permission2.getName().indexOf(46);
        if (index > 0) {
            index = permission2.getName().indexOf(46, index + 1);
        }
        if (index < 0) {
            return input.error("<permission-tree> name has less than three segments: " + permission2.getName());
        }
        permission2.protectionLevel = 0;
        permission2.tree = true;
        return ComponentParseUtils.parseAllMetaData(pkg, res, parser, tag, permission2, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedPermissionGroup> parsePermissionGroup(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input) throws IOException, XmlPullParserException {
        ParsedPermissionGroup permissionGroup = new ParsedPermissionGroup();
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionGroup);
        try {
            ParseResult<ParsedPermissionGroup> result = ParsedComponentUtils.parseComponent(permissionGroup, tag, pkg, sa, useRoundIcon, input, 7, 4, 1, 0, 5, 2, 8);
            if (result.isError()) {
                ParseResult<ParsedPermissionGroup> parseResult = result;
                return parseResult;
            }
            permissionGroup.requestDetailResourceId = sa.getResourceId(12, 0);
            permissionGroup.backgroundRequestResourceId = sa.getResourceId(9, 0);
            permissionGroup.backgroundRequestDetailResourceId = sa.getResourceId(10, 0);
            permissionGroup.requestRes = sa.getResourceId(11, 0);
            permissionGroup.flags = sa.getInt(6, 0);
            permissionGroup.priority = sa.getInt(3, 0);
        }
        finally {
            sa.recycle();
        }
        return ComponentParseUtils.parseAllMetaData(pkg, res, parser, tag, permissionGroup, input);
    }
}

