/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.PathPermission;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedComponentUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedMainComponentUtils;
import android.content.pm.parsing.component.ParsedProvider;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.Slog;
import com.android.internal.R;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedProviderUtils {
    private static final String TAG = "PackageParsing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedProvider> parseProvider(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean useRoundIcon, ParseInput input) throws IOException, XmlPullParserException {
        boolean visibleToEphemeral;
        String authority;
        int targetSdkVersion = pkg.getTargetSdkVersion();
        String packageName = pkg.getPackageName();
        ParsedProvider provider = new ParsedProvider();
        String tag = parser.getName();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProvider);
        try {
            ParseResult<ParsedProvider> result = ParsedMainComponentUtils.parseMainComponent(provider, tag, separateProcesses, pkg, sa, flags, useRoundIcon, input, 17, 14, 18, 6, 1, 0, 15, 2, 8, 19, 21, 23);
            if (result.isError()) {
                ParseResult<ParsedProvider> parseResult = result;
                return parseResult;
            }
            authority = sa.getNonConfigurationString(10, 0);
            provider.exported = sa.getBoolean(7, targetSdkVersion < 17);
            provider.syncable = sa.getBoolean(11, false);
            String permission2 = sa.getNonConfigurationString(3, 0);
            String readPermission = sa.getNonConfigurationString(4, 0);
            if (readPermission == null) {
                readPermission = permission2;
            }
            if (readPermission == null) {
                provider.setReadPermission(pkg.getPermission());
            } else {
                provider.setReadPermission(readPermission);
            }
            String writePermission = sa.getNonConfigurationString(5, 0);
            if (writePermission == null) {
                writePermission = permission2;
            }
            if (writePermission == null) {
                provider.setWritePermission(pkg.getPermission());
            } else {
                provider.setWritePermission(writePermission);
            }
            provider.grantUriPermissions = sa.getBoolean(13, false);
            provider.forceUriPermissions = sa.getBoolean(22, false);
            provider.multiProcess = sa.getBoolean(9, false);
            provider.initOrder = sa.getInt(12, 0);
            provider.flags |= ComponentParseUtils.flag(0x40000000, 16, sa);
            visibleToEphemeral = sa.getBoolean(20, false);
            if (visibleToEphemeral) {
                provider.flags |= 0x100000;
                pkg.setVisibleToInstantApps(true);
            }
        }
        finally {
            sa.recycle();
        }
        if (pkg.isCantSaveState() && Objects.equals(provider.getProcessName(), packageName)) {
            return input.error("Heavy-weight applications can not have providers in main process");
        }
        if (authority == null) {
            return input.error("<provider> does not include authorities attribute");
        }
        if (authority.length() <= 0) {
            return input.error("<provider> has empty authorities attribute");
        }
        provider.setAuthority(authority);
        return ParsedProviderUtils.parseProviderTags(pkg, tag, res, parser, visibleToEphemeral, provider, input);
    }

    private static ParseResult<ParsedProvider> parseProviderTags(ParsingPackage pkg, String tag, Resources res, XmlResourceParser parser, boolean visibleToEphemeral, ParsedProvider provider, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Parcelable> result;
            String name;
            if (type != 2) continue;
            switch (name = parser.getName()) {
                case "intent-filter": {
                    ParseResult<ParsedIntentInfo> intentResult = ParsedMainComponentUtils.parseIntentFilter(provider, pkg, res, parser, visibleToEphemeral, true, false, false, false, input);
                    result = intentResult;
                    if (!intentResult.isSuccess()) break;
                    ParsedIntentInfo intent = intentResult.getResult();
                    provider.order = Math.max(intent.getOrder(), provider.order);
                    provider.addIntent(intent);
                    break;
                }
                case "meta-data": {
                    result = ParsedComponentUtils.addMetaData(provider, pkg, res, parser, input);
                    break;
                }
                case "property": {
                    result = ParsedComponentUtils.addProperty(provider, pkg, res, parser, input);
                    break;
                }
                case "grant-uri-permission": {
                    result = ParsedProviderUtils.parseGrantUriPermission(provider, pkg, res, parser, input);
                    break;
                }
                case "path-permission": {
                    result = ParsedProviderUtils.parsePathPermission(provider, pkg, res, parser, input);
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag(tag, pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsedProvider> parseGrantUriPermission(ParsedProvider provider, ParsingPackage pkg, Resources resources, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestGrantUriPermission);
        try {
            String name = parser.getName();
            PatternMatcher pa = null;
            String str = sa.getNonConfigurationString(4, 0);
            if (str != null) {
                pa = new PatternMatcher(str, 3);
            } else {
                str = sa.getNonConfigurationString(2, 0);
                if (str != null) {
                    pa = new PatternMatcher(str, 2);
                } else {
                    str = sa.getNonConfigurationString(1, 0);
                    if (str != null) {
                        pa = new PatternMatcher(str, 1);
                    } else {
                        str = sa.getNonConfigurationString(3, 0);
                        if (str != null) {
                            pa = new PatternMatcher(str, 4);
                        } else {
                            str = sa.getNonConfigurationString(0, 0);
                            if (str != null) {
                                pa = new PatternMatcher(str, 0);
                            }
                        }
                    }
                }
            }
            if (pa != null) {
                if (provider.uriPermissionPatterns == null) {
                    provider.uriPermissionPatterns = new PatternMatcher[1];
                    provider.uriPermissionPatterns[0] = pa;
                } else {
                    int N = provider.uriPermissionPatterns.length;
                    PatternMatcher[] newp = new PatternMatcher[N + 1];
                    System.arraycopy(provider.uriPermissionPatterns, 0, newp, 0, N);
                    newp[N] = pa;
                    provider.uriPermissionPatterns = newp;
                }
                provider.grantUriPermissions = true;
            } else {
                Slog.w(TAG, "Unknown element under <path-permission>: " + name + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
            }
            ParseResult<ParsedProvider> parseResult = input.success(provider);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsedProvider> parsePathPermission(ParsedProvider provider, ParsingPackage pkg, Resources resources, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestPathPermission);
        try {
            String writePermission;
            String name = parser.getName();
            String permission2 = sa.getNonConfigurationString(0, 0);
            String readPermission = sa.getNonConfigurationString(1, 0);
            if (readPermission == null) {
                readPermission = permission2;
            }
            if ((writePermission = sa.getNonConfigurationString(2, 0)) == null) {
                writePermission = permission2;
            }
            boolean havePerm = false;
            if (readPermission != null) {
                readPermission = readPermission.intern();
                havePerm = true;
            }
            if (writePermission != null) {
                writePermission = writePermission.intern();
                havePerm = true;
            }
            if (!havePerm) {
                Slog.w(TAG, "No readPermission or writePermission for <path-permission>: " + name + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
                ParseResult<ParsedProvider> parseResult = input.success(provider);
                return parseResult;
            }
            PathPermission pa = null;
            String path = sa.getNonConfigurationString(7, 0);
            if (path != null) {
                pa = new PathPermission(path, 3, readPermission, writePermission);
            } else {
                path = sa.getNonConfigurationString(5, 0);
                if (path != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                } else {
                    path = sa.getNonConfigurationString(4, 0);
                    if (path != null) {
                        pa = new PathPermission(path, 1, readPermission, writePermission);
                    } else {
                        path = sa.getNonConfigurationString(6, 0);
                        if (path != null) {
                            pa = new PathPermission(path, 4, readPermission, writePermission);
                        } else {
                            path = sa.getNonConfigurationString(3, 0);
                            if (path != null) {
                                pa = new PathPermission(path, 0, readPermission, writePermission);
                            }
                        }
                    }
                }
            }
            if (pa != null) {
                if (provider.pathPermissions == null) {
                    provider.pathPermissions = new PathPermission[1];
                    provider.pathPermissions[0] = pa;
                } else {
                    int N = provider.pathPermissions.length;
                    PathPermission[] newp = new PathPermission[N + 1];
                    System.arraycopy(provider.pathPermissions, 0, newp, 0, N);
                    newp[N] = pa;
                    provider.pathPermissions = newp;
                }
            } else {
                Slog.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>: " + name + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
            }
            ParseResult<ParsedProvider> parseResult = input.success(provider);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }
}

