/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedComponentUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedMainComponentUtils;
import android.content.pm.parsing.component.ParsedService;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcelable;
import com.android.internal.R;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedServiceUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedService> parseService(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean useRoundIcon, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        boolean visibleToEphemeral;
        boolean setExported;
        String packageName = pkg.getPackageName();
        ParsedService service = new ParsedService();
        String tag = parser.getName();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestService);
        try {
            String permission2;
            ParseResult<ParsedService> result = ParsedMainComponentUtils.parseMainComponent(service, tag, separateProcesses, pkg, sa, flags, useRoundIcon, input, 12, 7, 13, 4, 1, 0, 8, 2, 6, 15, 17, 20);
            if (result.isError()) {
                ParseResult<ParsedService> parseResult = result;
                return parseResult;
            }
            setExported = sa.hasValue(5);
            if (setExported) {
                service.exported = sa.getBoolean(5, false);
            }
            service.setPermission((permission2 = sa.getNonConfigurationString(3, 0)) != null ? permission2 : pkg.getPermission());
            service.foregroundServiceType = sa.getInt(19, 0);
            service.flags |= ComponentParseUtils.flag(1, 9, sa) | ComponentParseUtils.flag(2, 10, sa) | ComponentParseUtils.flag(4, 14, sa) | ComponentParseUtils.flag(8, 18, sa) | ComponentParseUtils.flag(0x40000000, 11, sa);
            visibleToEphemeral = sa.getBoolean(16, false);
            if (visibleToEphemeral) {
                service.flags |= 0x100000;
                pkg.setVisibleToInstantApps(true);
            }
        }
        finally {
            sa.recycle();
        }
        if (pkg.isCantSaveState() && Objects.equals(service.getProcessName(), packageName)) {
            return input.error("Heavy-weight applications can not have services in main process");
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Parcelable> parseResult;
            if (type != 2) continue;
            switch (parser.getName()) {
                case "intent-filter": {
                    ParseResult<ParsedIntentInfo> intentResult = ParsedMainComponentUtils.parseIntentFilter(service, pkg, res, parser, visibleToEphemeral, true, false, false, false, input);
                    parseResult = intentResult;
                    if (!intentResult.isSuccess()) break;
                    ParsedIntentInfo intent = intentResult.getResult();
                    service.order = Math.max(intent.getOrder(), service.order);
                    service.addIntent(intent);
                    break;
                }
                case "meta-data": {
                    parseResult = ParsedComponentUtils.addMetaData(service, pkg, res, parser, input);
                    break;
                }
                case "property": {
                    parseResult = ParsedComponentUtils.addProperty(service, pkg, res, parser, input);
                    break;
                }
                default: {
                    parseResult = ParsingUtils.unknownTag(tag, pkg, parser, input);
                }
            }
            if (!parseResult.isError()) continue;
            return input.error(parseResult);
        }
        if (!setExported) {
            ParseResult<?> exportedCheckResult;
            boolean hasIntentFilters;
            boolean bl = hasIntentFilters = service.getIntents().size() > 0;
            if (hasIntentFilters && (exportedCheckResult = input.deferError(service.getName() + ": Targeting S+ (version " + 31 + " and above) requires that an explicit value for android:exported be defined when intent filters are present", 150232615L)).isError()) {
                return input.error(exportedCheckResult);
            }
            service.exported = hasIntentFilters;
        }
        return input.success(service);
    }
}

