/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Shader;

public class RadialGradient
extends Shader {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mX;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mY;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mRadius;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float[] mPositions;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Shader.TileMode mTileMode;
    private final float mFocalX;
    private final float mFocalY;
    private final float mFocalRadius;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] mColors;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mCenterColor;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mEdgeColor;
    private final long[] mColorLongs;

    public RadialGradient(float centerX, float centerY, float radius, int[] colors, float[] stops, Shader.TileMode tileMode) {
        this(centerX, centerY, 0.0f, centerX, centerY, radius, RadialGradient.convertColors(colors), stops, tileMode, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public RadialGradient(float centerX, float centerY, float radius, long[] colors, float[] stops, Shader.TileMode tileMode) {
        this(centerX, centerY, 0.0f, centerX, centerY, radius, (long[])colors.clone(), stops, tileMode, RadialGradient.detectColorSpace(colors));
    }

    public RadialGradient(float startX, float startY, float startRadius, float endX, float endY, float endRadius, long[] colors, float[] stops, Shader.TileMode tileMode) {
        this(startX, startY, startRadius, endX, endY, endRadius, (long[])colors.clone(), stops, tileMode, RadialGradient.detectColorSpace(colors));
    }

    private RadialGradient(float startX, float startY, float startRadius, float endX, float endY, float endRadius, long[] colors, float[] stops, Shader.TileMode tileMode, ColorSpace colorSpace) {
        super(colorSpace);
        if (startRadius < 0.0f) {
            throw new IllegalArgumentException("starting/focal radius must be >= 0");
        }
        if (endRadius <= 0.0f) {
            throw new IllegalArgumentException("ending radius must be > 0");
        }
        if (stops != null && colors.length != stops.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mX = endX;
        this.mY = endY;
        this.mRadius = endRadius;
        this.mFocalX = startX;
        this.mFocalY = startY;
        this.mFocalRadius = startRadius;
        this.mColorLongs = colors;
        this.mPositions = stops != null ? (float[])stops.clone() : null;
        this.mTileMode = tileMode;
    }

    public RadialGradient(float centerX, float centerY, float radius, int centerColor, int edgeColor, Shader.TileMode tileMode) {
        this(centerX, centerY, radius, Color.pack(centerColor), Color.pack(edgeColor), tileMode);
    }

    public RadialGradient(float centerX, float centerY, float radius, long centerColor, long edgeColor, Shader.TileMode tileMode) {
        this(centerX, centerY, radius, new long[]{centerColor, edgeColor}, null, tileMode);
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        return RadialGradient.nativeCreate(nativeMatrix, this.mFocalX, this.mFocalY, this.mFocalRadius, this.mX, this.mY, this.mRadius, this.mColorLongs, this.mPositions, this.mTileMode.nativeInt, this.colorSpace().getNativeInstance());
    }

    private static native long nativeCreate(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long[] var8, float[] var9, int var10, long var11);
}

