/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Shader;

public class SweepGradient
extends Shader {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mCx;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mCy;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float[] mPositions;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] mColors;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mColor0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mColor1;
    private final long[] mColorLongs;

    public SweepGradient(float cx, float cy, int[] colors, float[] positions) {
        this(cx, cy, SweepGradient.convertColors(colors), positions, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public SweepGradient(float cx, float cy, long[] colors, float[] positions) {
        this(cx, cy, (long[])colors.clone(), positions, SweepGradient.detectColorSpace(colors));
    }

    private SweepGradient(float cx, float cy, long[] colors, float[] positions, ColorSpace colorSpace) {
        super(colorSpace);
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mCx = cx;
        this.mCy = cy;
        this.mColorLongs = colors;
        this.mPositions = positions != null ? (float[])positions.clone() : null;
    }

    public SweepGradient(float cx, float cy, int color0, int color1) {
        this(cx, cy, Color.pack(color0), Color.pack(color1));
    }

    public SweepGradient(float cx, float cy, long color0, long color1) {
        this(cx, cy, new long[]{color0, color1}, null);
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        return SweepGradient.nativeCreate(nativeMatrix, this.mCx, this.mCy, this.mColorLongs, this.mPositions, this.colorSpace().getNativeInstance());
    }

    private static native long nativeCreate(long var0, float var2, float var3, long[] var4, float[] var5, long var6);
}

