/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.SurfaceTexture;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.create.OverrideMethod;

public class TextureLayer
implements AutoCloseable {
    private HardwareRenderer mRenderer;
    private VirtualRefBasePtr mFinalizer;

    private TextureLayer(HardwareRenderer renderer, long deferredUpdater) {
        if (renderer == null || deferredUpdater == 0L) {
            throw new IllegalArgumentException("Either hardware renderer: " + renderer + " or deferredUpdater: " + deferredUpdater + " is invalid");
        }
        this.mRenderer = renderer;
        this.mFinalizer = new VirtualRefBasePtr(deferredUpdater);
    }

    public void setLayerPaint(Paint paint) {
        TextureLayer.nSetLayerPaint(this.mFinalizer.get(), paint != null ? paint.getNativeInstance() : 0L);
        this.mRenderer.pushLayerUpdate(this);
    }

    private boolean isValid() {
        return this.mFinalizer != null && this.mFinalizer.get() != 0L;
    }

    @Override
    public void close() {
        if (!this.isValid()) {
            return;
        }
        this.mRenderer.onLayerDestroyed(this);
        this.mRenderer = null;
        this.mFinalizer.release();
        this.mFinalizer = null;
    }

    long getDeferredLayerUpdater() {
        return this.mFinalizer.get();
    }

    public boolean copyInto(Bitmap bitmap) {
        return this.mRenderer.copyLayerInto(this, bitmap);
    }

    public boolean prepare(int width, int height, boolean isOpaque) {
        return TextureLayer.nPrepare(this.mFinalizer.get(), width, height, isOpaque);
    }

    public void setTransform(Matrix matrix) {
        TextureLayer.nSetTransform(this.mFinalizer.get(), matrix.ni());
        this.mRenderer.pushLayerUpdate(this);
    }

    public void detachSurfaceTexture() {
        this.mRenderer.detachSurfaceTexture(this.mFinalizer.get());
    }

    long getLayerHandle() {
        return this.mFinalizer.get();
    }

    public void setSurfaceTexture(SurfaceTexture surface) {
        TextureLayer.nSetSurfaceTexture(this.mFinalizer.get(), surface);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void updateSurfaceTexture() {
        TextureLayer.nUpdateSurfaceTexture(this.mFinalizer.get());
        this.mRenderer.pushLayerUpdate(this);
    }

    static TextureLayer adoptTextureLayer(HardwareRenderer renderer, long layer) {
        return new TextureLayer(renderer, layer);
    }

    private static boolean nPrepare(long l, int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.TextureLayer#nPrepare(JIIZ)Z", true, null) != 0;
    }

    private static void nSetLayerPaint(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.TextureLayer#nSetLayerPaint(JJ)V", true, null);
    }

    private static void nSetTransform(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.TextureLayer#nSetTransform(JJ)V", true, null);
    }

    private static void nSetSurfaceTexture(long l, SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.graphics.TextureLayer#nSetSurfaceTexture(JLandroid/graphics/SurfaceTexture;)V", true, null);
    }

    private static void nUpdateSurfaceTexture(long l) {
        OverrideMethod.invokeV("android.graphics.TextureLayer#nUpdateSurfaceTexture(J)V", true, null);
    }
}

