/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBiometricSysuiReceiver
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.IBiometricSysuiReceiver";

    public void onDialogDismissed(int var1, byte[] var2) throws RemoteException;

    public void onTryAgainPressed() throws RemoteException;

    public void onDeviceCredentialPressed() throws RemoteException;

    public void onSystemEvent(int var1) throws RemoteException;

    public void onDialogAnimatedIn() throws RemoteException;

    public void onStartFingerprintNow() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBiometricSysuiReceiver {
        static final int TRANSACTION_onDialogDismissed = 1;
        static final int TRANSACTION_onTryAgainPressed = 2;
        static final int TRANSACTION_onDeviceCredentialPressed = 3;
        static final int TRANSACTION_onSystemEvent = 4;
        static final int TRANSACTION_onDialogAnimatedIn = 5;
        static final int TRANSACTION_onStartFingerprintNow = 6;

        public Stub() {
            this.attachInterface(this, IBiometricSysuiReceiver.DESCRIPTOR);
        }

        public static IBiometricSysuiReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBiometricSysuiReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof IBiometricSysuiReceiver) {
                return (IBiometricSysuiReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDialogDismissed";
                }
                case 2: {
                    return "onTryAgainPressed";
                }
                case 3: {
                    return "onDeviceCredentialPressed";
                }
                case 4: {
                    return "onSystemEvent";
                }
                case 5: {
                    return "onDialogAnimatedIn";
                }
                case 6: {
                    return "onStartFingerprintNow";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBiometricSysuiReceiver.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    this.onDialogDismissed(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onTryAgainPressed();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onDeviceCredentialPressed();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onSystemEvent(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onDialogAnimatedIn();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.onStartFingerprintNow();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBiometricSysuiReceiver impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBiometricSysuiReceiver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBiometricSysuiReceiver {
            private IBinder mRemote;
            public static IBiometricSysuiReceiver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBiometricSysuiReceiver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDialogDismissed(int reason, byte[] credentialAttestation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeByteArray(credentialAttestation);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDialogDismissed(reason, credentialAttestation);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onTryAgainPressed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTryAgainPressed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDeviceCredentialPressed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDeviceCredentialPressed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemEvent(int event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    _data.writeInt(event);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSystemEvent(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDialogAnimatedIn() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDialogAnimatedIn();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onStartFingerprintNow() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartFingerprintNow();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBiometricSysuiReceiver {
        @Override
        public void onDialogDismissed(int reason, byte[] credentialAttestation) throws RemoteException {
        }

        @Override
        public void onTryAgainPressed() throws RemoteException {
        }

        @Override
        public void onDeviceCredentialPressed() throws RemoteException {
        }

        @Override
        public void onSystemEvent(int event) throws RemoteException {
        }

        @Override
        public void onDialogAnimatedIn() throws RemoteException {
        }

        @Override
        public void onStartFingerprintNow() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

