/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.extension.IAdvancedExtenderImpl;
import android.hardware.camera2.extension.ICameraExtensionsProxyService;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.hardware.camera2.extension.LatencyRange;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.extension.SizeList;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.AsyncTask;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CameraExtensionCharacteristics {
    private static final String TAG = "CameraExtensionCharacteristics";
    public static final int EXTENSION_AUTOMATIC = 0;
    public static final int EXTENSION_BEAUTY = 1;
    public static final int EXTENSION_BOKEH = 2;
    public static final int EXTENSION_HDR = 3;
    public static final int EXTENSION_NIGHT = 4;
    public static final int NON_PROCESSING_INPUT_FORMAT = 34;
    public static final int PROCESSING_INPUT_FORMAT = 35;
    private static final int[] EXTENSION_LIST = new int[]{0, 1, 2, 3, 4};
    private final Context mContext;
    private final String mCameraId;
    private final CameraCharacteristics mChars;

    public CameraExtensionCharacteristics(Context context, String cameraId, CameraCharacteristics chars) {
        this.mContext = context;
        this.mCameraId = cameraId;
        this.mChars = chars;
    }

    private static ArrayList<android.util.Size> getSupportedSizes(List<SizeList> sizesList, Integer format) {
        ArrayList<android.util.Size> ret = new ArrayList<android.util.Size>();
        if (sizesList != null && !sizesList.isEmpty()) {
            for (SizeList entry : sizesList) {
                if (entry.format != format || entry.sizes.isEmpty()) continue;
                for (Size sz : entry.sizes) {
                    ret.add(new android.util.Size(sz.width, sz.height));
                }
                return ret;
            }
        }
        return ret;
    }

    private static List<android.util.Size> generateSupportedSizes(List<SizeList> sizesList, Integer format, StreamConfigurationMap streamMap) {
        ArrayList<android.util.Size> ret = CameraExtensionCharacteristics.getSupportedSizes(sizesList, format);
        android.util.Size[] supportedSizes = streamMap.getOutputSizes(format);
        if (ret.isEmpty() && supportedSizes != null) {
            ret.addAll(Arrays.asList(supportedSizes));
        }
        return ret;
    }

    private static List<android.util.Size> generateJpegSupportedSizes(List<SizeList> sizesList, StreamConfigurationMap streamMap) {
        ArrayList<android.util.Size> extensionSizes = CameraExtensionCharacteristics.getSupportedSizes(sizesList, 35);
        HashSet<android.util.Size> supportedSizes = extensionSizes.isEmpty() ? new HashSet<android.util.Size>(Arrays.asList(streamMap.getOutputSizes(35))) : new HashSet<android.util.Size>(extensionSizes);
        HashSet<android.util.Size> supportedJpegSizes = new HashSet<android.util.Size>(Arrays.asList(streamMap.getOutputSizes(256)));
        supportedSizes.retainAll(supportedJpegSizes);
        return new ArrayList<android.util.Size>(supportedSizes);
    }

    public static long registerClient(Context ctx) {
        return CameraExtensionManagerGlobal.get().registerClient(ctx);
    }

    public static void unregisterClient(long clientId) {
        CameraExtensionManagerGlobal.get().unregisterClient(clientId);
    }

    public static void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
        CameraExtensionManagerGlobal.get().initializeSession(cb);
    }

    public static void releaseSession() {
        CameraExtensionManagerGlobal.get().releaseSession();
    }

    public static boolean areAdvancedExtensionsSupported() {
        return CameraExtensionManagerGlobal.get().areAdvancedExtensionsSupported();
    }

    public static boolean isExtensionSupported(String cameraId, int extensionType, CameraCharacteristics chars) {
        Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders;
        if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
            try {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extensionType);
                return extender.isExtensionAvailable(cameraId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to query extension availability! Extension service does not respond!");
                return false;
            }
        }
        try {
            extenders = CameraExtensionCharacteristics.initializeExtension(extensionType);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            return ((IPreviewExtenderImpl)extenders.first).isExtensionAvailable(cameraId, chars.getNativeMetadata()) && ((IImageCaptureExtenderImpl)extenders.second).isExtensionAvailable(cameraId, chars.getNativeMetadata());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query extension availability! Extension service does not respond!");
            return false;
        }
    }

    public static IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) {
        IAdvancedExtenderImpl extender;
        try {
            extender = CameraExtensionManagerGlobal.get().initializeAdvancedExtension(extensionType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to initialize extension: " + extensionType);
        }
        if (extender == null) {
            throw new IllegalArgumentException("Unknown extension: " + extensionType);
        }
        return extender;
    }

    public static Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> initializeExtension(int extensionType) {
        IImageCaptureExtenderImpl imageExtender;
        IPreviewExtenderImpl previewExtender;
        try {
            previewExtender = CameraExtensionManagerGlobal.get().initializePreviewExtension(extensionType);
            imageExtender = CameraExtensionManagerGlobal.get().initializeImageExtension(extensionType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to initialize extension: " + extensionType);
        }
        if (imageExtender == null || previewExtender == null) {
            throw new IllegalArgumentException("Unknown extension: " + extensionType);
        }
        return new Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl>(previewExtender, imageExtender);
    }

    private static <T> boolean isOutputSupportedFor(Class<T> klass) {
        Objects.requireNonNull(klass, "klass must not be null");
        return klass == SurfaceTexture.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getSupportedExtensions() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            return Collections.unmodifiableList(ret);
        }
        try {
            for (int extensionType : EXTENSION_LIST) {
                if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extensionType, this.mChars)) continue;
                ret.add(extensionType);
            }
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return Collections.unmodifiableList(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<android.util.Size> getExtensionSupportedSizes(int extension, Class<T> klass) {
        if (!CameraExtensionCharacteristics.isOutputSupportedFor(klass)) {
            return new ArrayList<android.util.Size>();
        }
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mChars)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            StreamConfigurationMap streamMap = this.mChars.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId);
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedPreviewOutputResolutions(this.mCameraId), 34, streamMap);
                return list;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IPreviewExtenderImpl)extenders.first).init(this.mCameraId, this.mChars.getNativeMetadata());
            List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IPreviewExtenderImpl)extenders.first).getSupportedResolutions(), 34, streamMap);
            return list;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension supported sizes! Extension service does not respond!");
            ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
            return arrayList;
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<android.util.Size> getExtensionSupportedSizes(int extension, int format) {
        try {
            long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
            if (clientId < 0L) {
                throw new IllegalArgumentException("Unsupported extensions");
            }
            try {
                if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mChars)) {
                    throw new IllegalArgumentException("Unsupported extension");
                }
                StreamConfigurationMap streamMap = this.mChars.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                    switch (format) {
                        case 35: 
                        case 256: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported format: " + format);
                        }
                    }
                    IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                    extender.init(this.mCameraId);
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedCaptureOutputResolutions(this.mCameraId), format, streamMap);
                    return list;
                }
                if (format == 35) {
                    Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                    ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mChars.getNativeMetadata());
                    if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null) {
                        ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
                        return arrayList;
                    }
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedResolutions(), format, streamMap);
                    return list;
                }
                if (format != 256) throw new IllegalArgumentException("Unsupported format: " + format);
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mChars.getNativeMetadata());
                if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() != null) {
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateJpegSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedResolutions(), streamMap);
                    return list;
                }
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(null, format, streamMap);
                return list;
            }
            finally {
                CameraExtensionCharacteristics.unregisterClient(clientId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension supported sizes! Extension service does not respond!");
            return new ArrayList<android.util.Size>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range<Long> getEstimatedCaptureLatencyRangeMillis(int extension, android.util.Size captureOutputSize, int format) {
        switch (format) {
            case 35: 
            case 256: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
        }
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mChars)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            Size sz = new Size();
            sz.width = captureOutputSize.getWidth();
            sz.height = captureOutputSize.getHeight();
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId);
                LatencyRange latencyRange = extender.getEstimatedCaptureLatencyRange(this.mCameraId, sz, format);
                if (latencyRange != null) {
                    Range<Long> range = new Range<Long>(latencyRange.min, latencyRange.max);
                    return range;
                }
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mChars.getNativeMetadata());
                if (format == 35 && ((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                if (format == 256 && ((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() != null) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                LatencyRange latencyRange = ((IImageCaptureExtenderImpl)extenders.second).getEstimatedCaptureLatencyRange(sz);
                if (latencyRange != null) {
                    Range<Long> range = new Range<Long>(latencyRange.min, latencyRange.max);
                    return range;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension capture latency! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return null;
    }

    private static class CameraExtensionManagerGlobal {
        private static final String TAG = "CameraExtensionManagerGlobal";
        private static final String PROXY_PACKAGE_NAME = "com.android.cameraextensions";
        private static final String PROXY_SERVICE_NAME = "com.android.cameraextensions.CameraExtensionsProxyService";
        private static final CameraExtensionManagerGlobal GLOBAL_CAMERA_MANAGER = new CameraExtensionManagerGlobal();
        private final Object mLock = new Object();
        private final int PROXY_SERVICE_DELAY_MS = 1000;
        private InitializerFuture mInitFuture = null;
        private ServiceConnection mConnection = null;
        private ICameraExtensionsProxyService mProxy = null;
        private boolean mSupportsAdvancedExtensions = false;

        private CameraExtensionManagerGlobal() {
        }

        public static CameraExtensionManagerGlobal get() {
            return GLOBAL_CAMERA_MANAGER;
        }

        private void connectToProxyLocked(Context ctx) {
            if (this.mConnection == null) {
                Intent intent = new Intent();
                intent.setClassName(PROXY_PACKAGE_NAME, PROXY_SERVICE_NAME);
                String vendorProxyPackage = SystemProperties.get("ro.vendor.camera.extensions.package");
                String vendorProxyService = SystemProperties.get("ro.vendor.camera.extensions.service");
                if (!vendorProxyPackage.isEmpty() && !vendorProxyService.isEmpty()) {
                    Log.v(TAG, "Choosing the vendor camera extensions proxy package: " + vendorProxyPackage);
                    Log.v(TAG, "Choosing the vendor camera extensions proxy service: " + vendorProxyService);
                    intent.setClassName(vendorProxyPackage, vendorProxyService);
                }
                this.mInitFuture = new InitializerFuture();
                this.mConnection = new ServiceConnection(){

                    @Override
                    public void onServiceDisconnected(ComponentName component) {
                        mInitFuture.setStatus(false);
                        mConnection = null;
                        mProxy = null;
                    }

                    @Override
                    public void onServiceConnected(ComponentName component, IBinder binder) {
                        mProxy = ICameraExtensionsProxyService.Stub.asInterface(binder);
                        mInitFuture.setStatus(true);
                        try {
                            mSupportsAdvancedExtensions = mProxy.advancedExtensionsSupported();
                        }
                        catch (RemoteException e) {
                            Log.e(CameraExtensionManagerGlobal.TAG, "Remote IPC failed!");
                        }
                    }
                };
                ctx.bindService(intent, 0x40000049, AsyncTask.THREAD_POOL_EXECUTOR, this.mConnection);
                try {
                    this.mInitFuture.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    Log.e(TAG, "Timed out while initializing proxy service!");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long registerClient(Context ctx) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectToProxyLocked(ctx);
                if (this.mProxy != null) {
                    try {
                        return this.mProxy.registerClient();
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to initialize extension! Extension service does  not respond!");
                        return -1L;
                    }
                }
                return -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterClient(long clientId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    try {
                        this.mProxy.unregisterClient(clientId);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to de-initialize extension! Extension service does not respond!");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    this.mProxy.initializeSession(cb);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSession() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    try {
                        this.mProxy.releaseSession();
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to release session! Extension service does not respond!");
                    }
                }
            }
        }

        public boolean areAdvancedExtensionsSupported() {
            return this.mSupportsAdvancedExtensions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPreviewExtenderImpl initializePreviewExtension(int extensionType) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    return this.mProxy.initializePreviewExtension(extensionType);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IImageCaptureExtenderImpl initializeImageExtension(int extensionType) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    return this.mProxy.initializeImageExtension(extensionType);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    return this.mProxy.initializeAdvancedExtension(extensionType);
                }
                return null;
            }
        }

        private static class InitializerFuture
        implements Future<Boolean> {
            private volatile Boolean mStatus;
            ConditionVariable mCondVar = new ConditionVariable(false);

            private InitializerFuture() {
            }

            public void setStatus(boolean status) {
                this.mStatus = status;
                this.mCondVar.open();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return this.mStatus != null;
            }

            @Override
            public Boolean get() {
                this.mCondVar.block();
                return this.mStatus;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws TimeoutException {
                long timeoutMs = unit.convert(timeout, TimeUnit.MILLISECONDS);
                if (!this.mCondVar.block(timeoutMs)) {
                    throw new TimeoutException("Failed to receive status after " + timeout + " " + (Object)((Object)unit));
                }
                if (this.mStatus == null) {
                    throw new AssertionError();
                }
                return this.mStatus;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Extension {
    }
}

