/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.ISessionProcessorImpl;
import android.hardware.camera2.extension.LatencyRange;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.extension.SizeList;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IAdvancedExtenderImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IAdvancedExtenderImpl";

    public boolean isExtensionAvailable(String var1) throws RemoteException;

    public void init(String var1) throws RemoteException;

    public LatencyRange getEstimatedCaptureLatencyRange(String var1, Size var2, int var3) throws RemoteException;

    public List<SizeList> getSupportedPreviewOutputResolutions(String var1) throws RemoteException;

    public List<SizeList> getSupportedCaptureOutputResolutions(String var1) throws RemoteException;

    public ISessionProcessorImpl getSessionProcessor() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAdvancedExtenderImpl {
        static final int TRANSACTION_isExtensionAvailable = 1;
        static final int TRANSACTION_init = 2;
        static final int TRANSACTION_getEstimatedCaptureLatencyRange = 3;
        static final int TRANSACTION_getSupportedPreviewOutputResolutions = 4;
        static final int TRANSACTION_getSupportedCaptureOutputResolutions = 5;
        static final int TRANSACTION_getSessionProcessor = 6;

        public Stub() {
            this.attachInterface(this, IAdvancedExtenderImpl.DESCRIPTOR);
        }

        public static IAdvancedExtenderImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAdvancedExtenderImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IAdvancedExtenderImpl) {
                return (IAdvancedExtenderImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isExtensionAvailable";
                }
                case 2: {
                    return "init";
                }
                case 3: {
                    return "getEstimatedCaptureLatencyRange";
                }
                case 4: {
                    return "getSupportedPreviewOutputResolutions";
                }
                case 5: {
                    return "getSupportedCaptureOutputResolutions";
                }
                case 6: {
                    return "getSessionProcessor";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAdvancedExtenderImpl.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isExtensionAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.init(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Size _arg1 = 0 != data.readInt() ? Size.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    LatencyRange _result = this.getEstimatedCaptureLatencyRange(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<SizeList> _result = this.getSupportedPreviewOutputResolutions(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<SizeList> _result = this.getSupportedCaptureOutputResolutions(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ISessionProcessorImpl _result = this.getSessionProcessor();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IAdvancedExtenderImpl impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IAdvancedExtenderImpl getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IAdvancedExtenderImpl {
            private IBinder mRemote;
            public static IAdvancedExtenderImpl sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAdvancedExtenderImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isExtensionAvailable(String cameraId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isExtensionAvailable(cameraId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void init(String cameraId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().init(cameraId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LatencyRange getEstimatedCaptureLatencyRange(String cameraId, Size outputSize, int format) throws RemoteException {
                LatencyRange _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    if (outputSize != null) {
                        _data.writeInt(1);
                        outputSize.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(format);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LatencyRange latencyRange = Stub.getDefaultImpl().getEstimatedCaptureLatencyRange(cameraId, outputSize, format);
                        return latencyRange;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LatencyRange.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SizeList> getSupportedPreviewOutputResolutions(String cameraId) throws RemoteException {
                ArrayList<SizeList> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SizeList> list = Stub.getDefaultImpl().getSupportedPreviewOutputResolutions(cameraId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SizeList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SizeList> getSupportedCaptureOutputResolutions(String cameraId) throws RemoteException {
                ArrayList<SizeList> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SizeList> list = Stub.getDefaultImpl().getSupportedCaptureOutputResolutions(cameraId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SizeList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISessionProcessorImpl getSessionProcessor() throws RemoteException {
                ISessionProcessorImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ISessionProcessorImpl iSessionProcessorImpl = Stub.getDefaultImpl().getSessionProcessor();
                        return iSessionProcessorImpl;
                    }
                    _reply.readException();
                    _result = ISessionProcessorImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAdvancedExtenderImpl {
        @Override
        public boolean isExtensionAvailable(String cameraId) throws RemoteException {
            return false;
        }

        @Override
        public void init(String cameraId) throws RemoteException {
        }

        @Override
        public LatencyRange getEstimatedCaptureLatencyRange(String cameraId, Size outputSize, int format) throws RemoteException {
            return null;
        }

        @Override
        public List<SizeList> getSupportedPreviewOutputResolutions(String cameraId) throws RemoteException {
            return null;
        }

        @Override
        public List<SizeList> getSupportedCaptureOutputResolutions(String cameraId) throws RemoteException {
            return null;
        }

        @Override
        public ISessionProcessorImpl getSessionProcessor() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

