/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.IAdvancedExtenderImpl;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraExtensionsProxyService
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.ICameraExtensionsProxyService";

    public long registerClient() throws RemoteException;

    public void unregisterClient(long var1) throws RemoteException;

    public boolean advancedExtensionsSupported() throws RemoteException;

    public void initializeSession(IInitializeSessionCallback var1) throws RemoteException;

    public void releaseSession() throws RemoteException;

    public IPreviewExtenderImpl initializePreviewExtension(int var1) throws RemoteException;

    public IImageCaptureExtenderImpl initializeImageExtension(int var1) throws RemoteException;

    public IAdvancedExtenderImpl initializeAdvancedExtension(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraExtensionsProxyService {
        static final int TRANSACTION_registerClient = 1;
        static final int TRANSACTION_unregisterClient = 2;
        static final int TRANSACTION_advancedExtensionsSupported = 3;
        static final int TRANSACTION_initializeSession = 4;
        static final int TRANSACTION_releaseSession = 5;
        static final int TRANSACTION_initializePreviewExtension = 6;
        static final int TRANSACTION_initializeImageExtension = 7;
        static final int TRANSACTION_initializeAdvancedExtension = 8;

        public Stub() {
            this.attachInterface(this, ICameraExtensionsProxyService.DESCRIPTOR);
        }

        public static ICameraExtensionsProxyService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICameraExtensionsProxyService.DESCRIPTOR);
            if (iin != null && iin instanceof ICameraExtensionsProxyService) {
                return (ICameraExtensionsProxyService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerClient";
                }
                case 2: {
                    return "unregisterClient";
                }
                case 3: {
                    return "advancedExtensionsSupported";
                }
                case 4: {
                    return "initializeSession";
                }
                case 5: {
                    return "releaseSession";
                }
                case 6: {
                    return "initializePreviewExtension";
                }
                case 7: {
                    return "initializeImageExtension";
                }
                case 8: {
                    return "initializeAdvancedExtension";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICameraExtensionsProxyService.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    long _result = this.registerClient();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.advancedExtensionsSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IInitializeSessionCallback _arg0 = IInitializeSessionCallback.Stub.asInterface(data.readStrongBinder());
                    this.initializeSession(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.releaseSession();
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IPreviewExtenderImpl _result = this.initializePreviewExtension(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IImageCaptureExtenderImpl _result = this.initializeImageExtension(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IAdvancedExtenderImpl _result = this.initializeAdvancedExtension(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ICameraExtensionsProxyService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ICameraExtensionsProxyService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ICameraExtensionsProxyService {
            private IBinder mRemote;
            public static ICameraExtensionsProxyService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICameraExtensionsProxyService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long registerClient() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().registerClient();
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClient(long clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeLong(clientId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterClient(clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean advancedExtensionsSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().advancedExtensionsSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initializeSession(cb);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPreviewExtenderImpl initializePreviewExtension(int extensionType) throws RemoteException {
                IPreviewExtenderImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeInt(extensionType);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IPreviewExtenderImpl iPreviewExtenderImpl = Stub.getDefaultImpl().initializePreviewExtension(extensionType);
                        return iPreviewExtenderImpl;
                    }
                    _reply.readException();
                    _result = IPreviewExtenderImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImageCaptureExtenderImpl initializeImageExtension(int extensionType) throws RemoteException {
                IImageCaptureExtenderImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeInt(extensionType);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImageCaptureExtenderImpl iImageCaptureExtenderImpl = Stub.getDefaultImpl().initializeImageExtension(extensionType);
                        return iImageCaptureExtenderImpl;
                    }
                    _reply.readException();
                    _result = IImageCaptureExtenderImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) throws RemoteException {
                IAdvancedExtenderImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeInt(extensionType);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IAdvancedExtenderImpl iAdvancedExtenderImpl = Stub.getDefaultImpl().initializeAdvancedExtension(extensionType);
                        return iAdvancedExtenderImpl;
                    }
                    _reply.readException();
                    _result = IAdvancedExtenderImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICameraExtensionsProxyService {
        @Override
        public long registerClient() throws RemoteException {
            return 0L;
        }

        @Override
        public void unregisterClient(long clientId) throws RemoteException {
        }

        @Override
        public boolean advancedExtensionsSupported() throws RemoteException {
            return false;
        }

        @Override
        public void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
        }

        @Override
        public void releaseSession() throws RemoteException {
        }

        @Override
        public IPreviewExtenderImpl initializePreviewExtension(int extensionType) throws RemoteException {
            return null;
        }

        @Override
        public IImageCaptureExtenderImpl initializeImageExtension(int extensionType) throws RemoteException {
            return null;
        }

        @Override
        public IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

