/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.CaptureStageImpl;
import android.hardware.camera2.extension.IPreviewImageProcessorImpl;
import android.hardware.camera2.extension.IRequestUpdateProcessorImpl;
import android.hardware.camera2.extension.SizeList;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPreviewExtenderImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IPreviewExtenderImpl";
    public static final int PROCESSOR_TYPE_REQUEST_UPDATE_ONLY = 0;
    public static final int PROCESSOR_TYPE_IMAGE_PROCESSOR = 1;
    public static final int PROCESSOR_TYPE_NONE = 2;

    public void onInit(String var1, CameraMetadataNative var2) throws RemoteException;

    public void onDeInit() throws RemoteException;

    public CaptureStageImpl onPresetSession() throws RemoteException;

    public CaptureStageImpl onEnableSession() throws RemoteException;

    public CaptureStageImpl onDisableSession() throws RemoteException;

    public void init(String var1, CameraMetadataNative var2) throws RemoteException;

    public boolean isExtensionAvailable(String var1, CameraMetadataNative var2) throws RemoteException;

    public CaptureStageImpl getCaptureStage() throws RemoteException;

    public int getProcessorType() throws RemoteException;

    public IPreviewImageProcessorImpl getPreviewImageProcessor() throws RemoteException;

    public IRequestUpdateProcessorImpl getRequestUpdateProcessor() throws RemoteException;

    public List<SizeList> getSupportedResolutions() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPreviewExtenderImpl {
        static final int TRANSACTION_onInit = 1;
        static final int TRANSACTION_onDeInit = 2;
        static final int TRANSACTION_onPresetSession = 3;
        static final int TRANSACTION_onEnableSession = 4;
        static final int TRANSACTION_onDisableSession = 5;
        static final int TRANSACTION_init = 6;
        static final int TRANSACTION_isExtensionAvailable = 7;
        static final int TRANSACTION_getCaptureStage = 8;
        static final int TRANSACTION_getProcessorType = 9;
        static final int TRANSACTION_getPreviewImageProcessor = 10;
        static final int TRANSACTION_getRequestUpdateProcessor = 11;
        static final int TRANSACTION_getSupportedResolutions = 12;

        public Stub() {
            this.attachInterface(this, IPreviewExtenderImpl.DESCRIPTOR);
        }

        public static IPreviewExtenderImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPreviewExtenderImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IPreviewExtenderImpl) {
                return (IPreviewExtenderImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInit";
                }
                case 2: {
                    return "onDeInit";
                }
                case 3: {
                    return "onPresetSession";
                }
                case 4: {
                    return "onEnableSession";
                }
                case 5: {
                    return "onDisableSession";
                }
                case 6: {
                    return "init";
                }
                case 7: {
                    return "isExtensionAvailable";
                }
                case 8: {
                    return "getCaptureStage";
                }
                case 9: {
                    return "getProcessorType";
                }
                case 10: {
                    return "getPreviewImageProcessor";
                }
                case 11: {
                    return "getRequestUpdateProcessor";
                }
                case 12: {
                    return "getSupportedResolutions";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPreviewExtenderImpl.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = 0 != data.readInt() ? CameraMetadataNative.CREATOR.createFromParcel(data) : null;
                    this.onInit(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onDeInit();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    CaptureStageImpl _result = this.onPresetSession();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    CaptureStageImpl _result = this.onEnableSession();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    CaptureStageImpl _result = this.onDisableSession();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = 0 != data.readInt() ? CameraMetadataNative.CREATOR.createFromParcel(data) : null;
                    this.init(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = 0 != data.readInt() ? CameraMetadataNative.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isExtensionAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    CaptureStageImpl _result = this.getCaptureStage();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _result = this.getProcessorType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IPreviewImageProcessorImpl _result = this.getPreviewImageProcessor();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IRequestUpdateProcessorImpl _result = this.getRequestUpdateProcessor();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    List<SizeList> _result = this.getSupportedResolutions();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPreviewExtenderImpl impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPreviewExtenderImpl getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPreviewExtenderImpl {
            private IBinder mRemote;
            public static IPreviewExtenderImpl sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPreviewExtenderImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInit(String cameraId, CameraMetadataNative cameraCharacteristics) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    if (cameraCharacteristics != null) {
                        _data.writeInt(1);
                        cameraCharacteristics.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onInit(cameraId, cameraCharacteristics);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeInit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDeInit();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl onPresetSession() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CaptureStageImpl captureStageImpl = Stub.getDefaultImpl().onPresetSession();
                        return captureStageImpl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CaptureStageImpl.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl onEnableSession() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CaptureStageImpl captureStageImpl = Stub.getDefaultImpl().onEnableSession();
                        return captureStageImpl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CaptureStageImpl.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl onDisableSession() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CaptureStageImpl captureStageImpl = Stub.getDefaultImpl().onDisableSession();
                        return captureStageImpl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CaptureStageImpl.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void init(String cameraId, CameraMetadataNative chars) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    if (chars != null) {
                        _data.writeInt(1);
                        chars.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().init(cameraId, chars);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isExtensionAvailable(String cameraId, CameraMetadataNative chars) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    if (chars != null) {
                        _data.writeInt(1);
                        chars.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isExtensionAvailable(cameraId, chars);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl getCaptureStage() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CaptureStageImpl captureStageImpl = Stub.getDefaultImpl().getCaptureStage();
                        return captureStageImpl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CaptureStageImpl.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getProcessorType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getProcessorType();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPreviewImageProcessorImpl getPreviewImageProcessor() throws RemoteException {
                IPreviewImageProcessorImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IPreviewImageProcessorImpl iPreviewImageProcessorImpl = Stub.getDefaultImpl().getPreviewImageProcessor();
                        return iPreviewImageProcessorImpl;
                    }
                    _reply.readException();
                    _result = IPreviewImageProcessorImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRequestUpdateProcessorImpl getRequestUpdateProcessor() throws RemoteException {
                IRequestUpdateProcessorImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IRequestUpdateProcessorImpl iRequestUpdateProcessorImpl = Stub.getDefaultImpl().getRequestUpdateProcessor();
                        return iRequestUpdateProcessorImpl;
                    }
                    _reply.readException();
                    _result = IRequestUpdateProcessorImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SizeList> getSupportedResolutions() throws RemoteException {
                ArrayList<SizeList> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SizeList> list = Stub.getDefaultImpl().getSupportedResolutions();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SizeList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPreviewExtenderImpl {
        @Override
        public void onInit(String cameraId, CameraMetadataNative cameraCharacteristics) throws RemoteException {
        }

        @Override
        public void onDeInit() throws RemoteException {
        }

        @Override
        public CaptureStageImpl onPresetSession() throws RemoteException {
            return null;
        }

        @Override
        public CaptureStageImpl onEnableSession() throws RemoteException {
            return null;
        }

        @Override
        public CaptureStageImpl onDisableSession() throws RemoteException {
            return null;
        }

        @Override
        public void init(String cameraId, CameraMetadataNative chars) throws RemoteException {
        }

        @Override
        public boolean isExtensionAvailable(String cameraId, CameraMetadataNative chars) throws RemoteException {
            return false;
        }

        @Override
        public CaptureStageImpl getCaptureStage() throws RemoteException {
            return null;
        }

        @Override
        public int getProcessorType() throws RemoteException {
            return 0;
        }

        @Override
        public IPreviewImageProcessorImpl getPreviewImageProcessor() throws RemoteException {
            return null;
        }

        @Override
        public IRequestUpdateProcessorImpl getRequestUpdateProcessor() throws RemoteException {
            return null;
        }

        @Override
        public List<SizeList> getSupportedResolutions() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

