/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.hardware.face.Face;
import android.hardware.face.FaceAuthenticationFrame;
import android.hardware.face.FaceEnrollFrame;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IFaceServiceReceiver
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.face.IFaceServiceReceiver";

    public void onEnrollResult(Face var1, int var2) throws RemoteException;

    public void onAcquired(int var1, int var2) throws RemoteException;

    public void onAuthenticationSucceeded(Face var1, int var2, boolean var3) throws RemoteException;

    public void onFaceDetected(int var1, int var2, boolean var3) throws RemoteException;

    public void onAuthenticationFailed() throws RemoteException;

    public void onError(int var1, int var2) throws RemoteException;

    public void onRemoved(Face var1, int var2) throws RemoteException;

    public void onFeatureSet(boolean var1, int var2) throws RemoteException;

    public void onFeatureGet(boolean var1, int[] var2, boolean[] var3) throws RemoteException;

    public void onChallengeGenerated(int var1, int var2, long var3) throws RemoteException;

    public void onAuthenticationFrame(FaceAuthenticationFrame var1) throws RemoteException;

    public void onEnrollmentFrame(FaceEnrollFrame var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFaceServiceReceiver {
        static final int TRANSACTION_onEnrollResult = 1;
        static final int TRANSACTION_onAcquired = 2;
        static final int TRANSACTION_onAuthenticationSucceeded = 3;
        static final int TRANSACTION_onFaceDetected = 4;
        static final int TRANSACTION_onAuthenticationFailed = 5;
        static final int TRANSACTION_onError = 6;
        static final int TRANSACTION_onRemoved = 7;
        static final int TRANSACTION_onFeatureSet = 8;
        static final int TRANSACTION_onFeatureGet = 9;
        static final int TRANSACTION_onChallengeGenerated = 10;
        static final int TRANSACTION_onAuthenticationFrame = 11;
        static final int TRANSACTION_onEnrollmentFrame = 12;

        public Stub() {
            this.attachInterface(this, IFaceServiceReceiver.DESCRIPTOR);
        }

        public static IFaceServiceReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IFaceServiceReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof IFaceServiceReceiver) {
                return (IFaceServiceReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnrollResult";
                }
                case 2: {
                    return "onAcquired";
                }
                case 3: {
                    return "onAuthenticationSucceeded";
                }
                case 4: {
                    return "onFaceDetected";
                }
                case 5: {
                    return "onAuthenticationFailed";
                }
                case 6: {
                    return "onError";
                }
                case 7: {
                    return "onRemoved";
                }
                case 8: {
                    return "onFeatureSet";
                }
                case 9: {
                    return "onFeatureGet";
                }
                case 10: {
                    return "onChallengeGenerated";
                }
                case 11: {
                    return "onAuthenticationFrame";
                }
                case 12: {
                    return "onEnrollmentFrame";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IFaceServiceReceiver.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    Face _arg0 = 0 != data.readInt() ? Face.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.onEnrollResult(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onAcquired(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Face _arg0 = 0 != data.readInt() ? Face.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.onAuthenticationSucceeded(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.onFaceDetected(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onAuthenticationFailed();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onError(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    Face _arg0 = 0 != data.readInt() ? Face.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.onRemoved(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    this.onFeatureSet(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int[] _arg1 = data.createIntArray();
                    boolean[] _arg2 = data.createBooleanArray();
                    this.onFeatureGet(_arg0, _arg1, _arg2);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    this.onChallengeGenerated(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    FaceAuthenticationFrame _arg0 = 0 != data.readInt() ? FaceAuthenticationFrame.CREATOR.createFromParcel(data) : null;
                    this.onAuthenticationFrame(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    FaceEnrollFrame _arg0 = 0 != data.readInt() ? FaceEnrollFrame.CREATOR.createFromParcel(data) : null;
                    this.onEnrollmentFrame(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IFaceServiceReceiver impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IFaceServiceReceiver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IFaceServiceReceiver {
            private IBinder mRemote;
            public static IFaceServiceReceiver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IFaceServiceReceiver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollResult(Face face, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    if (face != null) {
                        _data.writeInt(1);
                        face.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnrollResult(face, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(int acquiredInfo, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(acquiredInfo);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAcquired(acquiredInfo, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(Face face, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    if (face != null) {
                        _data.writeInt(1);
                        face.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    _data.writeInt(isStrongBiometric ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationSucceeded(face, userId, isStrongBiometric);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFaceDetected(int sensorId, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeInt(isStrongBiometric ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFaceDetected(sensorId, userId, isStrongBiometric);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAuthenticationFailed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationFailed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onError(error, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoved(Face face, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    if (face != null) {
                        _data.writeInt(1);
                        face.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoved(face, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureSet(boolean success, int feature) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(success ? 1 : 0);
                    _data.writeInt(feature);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFeatureSet(success, feature);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureGet(boolean success, int[] features, boolean[] featureState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(success ? 1 : 0);
                    _data.writeIntArray(features);
                    _data.writeBooleanArray(featureState);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFeatureGet(success, features, featureState);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChallengeGenerated(int sensorId, int userId, long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onChallengeGenerated(sensorId, userId, challenge);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFrame(FaceAuthenticationFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationFrame(frame);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentFrame(FaceEnrollFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnrollmentFrame(frame);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFaceServiceReceiver {
        @Override
        public void onEnrollResult(Face face, int remaining) throws RemoteException {
        }

        @Override
        public void onAcquired(int acquiredInfo, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(Face face, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onFaceDetected(int sensorId, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
        }

        @Override
        public void onError(int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onRemoved(Face face, int remaining) throws RemoteException {
        }

        @Override
        public void onFeatureSet(boolean success, int feature) throws RemoteException {
        }

        @Override
        public void onFeatureGet(boolean success, int[] features, boolean[] featureState) throws RemoteException {
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) throws RemoteException {
        }

        @Override
        public void onAuthenticationFrame(FaceAuthenticationFrame frame) throws RemoteException {
        }

        @Override
        public void onEnrollmentFrame(FaceEnrollFrame frame) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

