/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.hardware.BatteryState;
import android.hardware.input.InputManager;

public class InputDeviceBatteryState
extends BatteryState {
    private static final float NULL_BATTERY_CAPACITY = Float.NaN;
    private final InputManager mInputManager;
    private final int mDeviceId;
    private final boolean mHasBattery;

    InputDeviceBatteryState(InputManager inputManager, int deviceId, boolean hasBattery) {
        this.mInputManager = inputManager;
        this.mDeviceId = deviceId;
        this.mHasBattery = hasBattery;
    }

    @Override
    public boolean isPresent() {
        return this.mHasBattery;
    }

    @Override
    public int getStatus() {
        if (!this.mHasBattery) {
            return 1;
        }
        return this.mInputManager.getBatteryStatus(this.mDeviceId);
    }

    @Override
    public float getCapacity() {
        int capacity;
        if (this.mHasBattery && (capacity = this.mInputManager.getBatteryCapacity(this.mDeviceId)) != -1) {
            return (float)capacity / 100.0f;
        }
        return Float.NaN;
    }
}

