/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ILightsManager
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.lights.ILightsManager";

    public List<Light> getLights() throws RemoteException;

    public LightState getLightState(int var1) throws RemoteException;

    public void openSession(IBinder var1, int var2) throws RemoteException;

    public void closeSession(IBinder var1) throws RemoteException;

    public void setLightStates(IBinder var1, int[] var2, LightState[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILightsManager {
        static final int TRANSACTION_getLights = 1;
        static final int TRANSACTION_getLightState = 2;
        static final int TRANSACTION_openSession = 3;
        static final int TRANSACTION_closeSession = 4;
        static final int TRANSACTION_setLightStates = 5;

        public Stub() {
            this.attachInterface(this, ILightsManager.DESCRIPTOR);
        }

        public static ILightsManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILightsManager.DESCRIPTOR);
            if (iin != null && iin instanceof ILightsManager) {
                return (ILightsManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getLights";
                }
                case 2: {
                    return "getLightState";
                }
                case 3: {
                    return "openSession";
                }
                case 4: {
                    return "closeSession";
                }
                case 5: {
                    return "setLightStates";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILightsManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    List<Light> _result = this.getLights();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    LightState _result = this.getLightState(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.openSession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.closeSession(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    LightState[] _arg2 = data.createTypedArray(LightState.CREATOR);
                    this.setLightStates(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ILightsManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ILightsManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ILightsManager {
            private IBinder mRemote;
            public static ILightsManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILightsManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Light> getLights() throws RemoteException {
                ArrayList<Light> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<Light> list = Stub.getDefaultImpl().getLights();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Light.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LightState getLightState(int lightId) throws RemoteException {
                LightState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeInt(lightId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LightState lightState = Stub.getDefaultImpl().getLightState(lightId);
                        return lightState;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LightState.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openSession(IBinder sessionToken, int priority) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(priority);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().openSession(sessionToken, priority);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSession(IBinder sessionToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().closeSession(sessionToken);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLightStates(IBinder sessionToken, int[] lightIds, LightState[] states) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeIntArray(lightIds);
                    _data.writeTypedArray(states, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLightStates(sessionToken, lightIds, states);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILightsManager {
        @Override
        public List<Light> getLights() throws RemoteException {
            return null;
        }

        @Override
        public LightState getLightState(int lightId) throws RemoteException {
            return null;
        }

        @Override
        public void openSession(IBinder sessionToken, int priority) throws RemoteException {
        }

        @Override
        public void closeSession(IBinder sessionToken) throws RemoteException {
        }

        @Override
        public void setLightStates(IBinder sessionToken, int[] lightIds, LightState[] states) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

