/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Light
implements Parcelable {
    public static final int LIGHT_TYPE_MICROPHONE = 8;
    public static final int LIGHT_TYPE_INPUT = 10001;
    public static final int LIGHT_TYPE_PLAYER_ID = 10002;
    public static final int LIGHT_CAPABILITY_BRIGHTNESS = 1;
    public static final int LIGHT_CAPABILITY_RGB = 0;
    private final int mId;
    private final String mName;
    private final int mOrdinal;
    private final int mType;
    private final int mCapabilities;
    public static final Parcelable.Creator<Light> CREATOR = new Parcelable.Creator<Light>(){

        @Override
        public Light createFromParcel(Parcel in) {
            return new Light(in);
        }

        public Light[] newArray(int size) {
            return new Light[size];
        }
    };

    public Light(int id2, int ordinal, int type) {
        this(id2, "Light", ordinal, type, 0);
    }

    public Light(int id2, String name, int ordinal, int type, int capabilities) {
        this.mId = id2;
        this.mName = name;
        this.mOrdinal = ordinal;
        this.mType = type;
        this.mCapabilities = capabilities;
    }

    private Light(Parcel in) {
        this.mId = in.readInt();
        this.mName = in.readString();
        this.mOrdinal = in.readInt();
        this.mType = in.readInt();
        this.mCapabilities = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mName);
        dest.writeInt(this.mOrdinal);
        dest.writeInt(this.mType);
        dest.writeInt(this.mCapabilities);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Light) {
            Light light = (Light)obj;
            return this.mId == light.mId && this.mOrdinal == light.mOrdinal && this.mType == light.mType && this.mCapabilities == light.mCapabilities;
        }
        return false;
    }

    public int hashCode() {
        return this.mId;
    }

    public String toString() {
        return "[Name=" + this.mName + " Id=" + this.mId + " Type=" + this.mType + " Capabilities=" + this.mCapabilities + " Ordinal=" + this.mOrdinal + "]";
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public int getType() {
        return this.mType;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public boolean hasBrightnessControl() {
        return (this.mCapabilities & 1) == 1;
    }

    public boolean hasRgbControl() {
        return (this.mCapabilities & 0) == 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LightCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LightType {
    }
}

