/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_6;

import android.hardware.radio.V1_6.SliceServiceType;
import android.hardware.radio.V1_6.SliceStatus;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class SliceInfo {
    public byte sst = 0;
    public int sliceDifferentiator = 0;
    public byte mappedHplmnSst = 0;
    public int mappedHplmnSD = 0;
    public byte status = 0;

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != SliceInfo.class) {
            return false;
        }
        SliceInfo other = (SliceInfo)otherObject;
        if (this.sst != other.sst) {
            return false;
        }
        if (this.sliceDifferentiator != other.sliceDifferentiator) {
            return false;
        }
        if (this.mappedHplmnSst != other.mappedHplmnSst) {
            return false;
        }
        if (this.mappedHplmnSD != other.mappedHplmnSD) {
            return false;
        }
        return this.status == other.status;
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.sst), HidlSupport.deepHashCode(this.sliceDifferentiator), HidlSupport.deepHashCode(this.mappedHplmnSst), HidlSupport.deepHashCode(this.mappedHplmnSD), HidlSupport.deepHashCode(this.status));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".sst = ");
        builder.append(SliceServiceType.toString(this.sst));
        builder.append(", .sliceDifferentiator = ");
        builder.append(this.sliceDifferentiator);
        builder.append(", .mappedHplmnSst = ");
        builder.append(SliceServiceType.toString(this.mappedHplmnSst));
        builder.append(", .mappedHplmnSD = ");
        builder.append(this.mappedHplmnSD);
        builder.append(", .status = ");
        builder.append(SliceStatus.toString(this.status));
        builder.append("}");
        return builder.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(20L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<SliceInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<SliceInfo> _hidl_vec = new ArrayList<SliceInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 20, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            SliceInfo _hidl_vec_element = new SliceInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 20);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.sst = _hidl_blob.getInt8(_hidl_offset + 0L);
        this.sliceDifferentiator = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.mappedHplmnSst = _hidl_blob.getInt8(_hidl_offset + 8L);
        this.mappedHplmnSD = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.status = _hidl_blob.getInt8(_hidl_offset + 16L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(20);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<SliceInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 20);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 20);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt8(_hidl_offset + 0L, this.sst);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.sliceDifferentiator);
        _hidl_blob.putInt8(_hidl_offset + 8L, this.mappedHplmnSst);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.mappedHplmnSD);
        _hidl_blob.putInt8(_hidl_offset + 16L, this.status);
    }
}

