/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.WindowManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SoftInputWindow
extends Dialog {
    private static final boolean DEBUG = false;
    private static final String TAG = "SoftInputWindow";
    final String mName;
    final Callback mCallback;
    final KeyEvent.Callback mKeyEventCallback;
    final KeyEvent.DispatcherState mDispatcherState;
    final int mWindowType;
    final int mGravity;
    final boolean mTakesFocus;
    private final Rect mBounds = new Rect();
    private int mWindowState = 0;

    public void setToken(IBinder token) {
        switch (this.mWindowState) {
            case 0: {
                WindowManager.LayoutParams lp = this.getWindow().getAttributes();
                lp.token = token;
                this.getWindow().setAttributes(lp);
                this.updateWindowState(1);
                this.getWindow().getDecorView().setVisibility(4);
                this.show();
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                throw new IllegalStateException("setToken can be called only once");
            }
            case 4: {
                Log.i(TAG, "Ignoring setToken() because window is already destroyed.");
                return;
            }
        }
        throw new IllegalStateException("Unexpected state=" + this.mWindowState);
    }

    public SoftInputWindow(Context context, String name, int theme, Callback callback, KeyEvent.Callback keyEventCallback, KeyEvent.DispatcherState dispatcherState, int windowType, int gravity, boolean takesFocus) {
        super(context, theme);
        this.mName = name;
        this.mCallback = callback;
        this.mKeyEventCallback = keyEventCallback;
        this.mDispatcherState = dispatcherState;
        this.mWindowType = windowType;
        this.mGravity = gravity;
        this.mTakesFocus = takesFocus;
        this.initDockWindow();
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mDispatcherState.reset();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.getWindow().getDecorView().getHitRect(this.mBounds);
        if (ev.isWithinBoundsNoHistory(this.mBounds.left, this.mBounds.top, this.mBounds.right - 1, this.mBounds.bottom - 1)) {
            return super.dispatchTouchEvent(ev);
        }
        MotionEvent temp = ev.clampNoHistory(this.mBounds.left, this.mBounds.top, this.mBounds.right - 1, this.mBounds.bottom - 1);
        boolean handled = super.dispatchTouchEvent(temp);
        temp.recycle();
        return handled;
    }

    public void setGravity(int gravity) {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.gravity = gravity;
        this.updateWidthHeight(lp);
        this.getWindow().setAttributes(lp);
    }

    public int getGravity() {
        return this.getWindow().getAttributes().gravity;
    }

    private void updateWidthHeight(WindowManager.LayoutParams lp) {
        if (lp.gravity == 48 || lp.gravity == 80) {
            lp.width = -1;
            lp.height = -2;
        } else {
            lp.width = -2;
            lp.height = -1;
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyLongPress(keyCode, event)) {
            return true;
        }
        return super.onKeyLongPress(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyUp(keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyMultiple(keyCode, count, event)) {
            return true;
        }
        return super.onKeyMultiple(keyCode, count, event);
    }

    @Override
    public void onBackPressed() {
        if (this.mCallback != null) {
            this.mCallback.onBackPressed();
        } else {
            super.onBackPressed();
        }
    }

    private void initDockWindow() {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.type = this.mWindowType;
        lp.setTitle(this.mName);
        lp.gravity = this.mGravity;
        this.updateWidthHeight(lp);
        this.getWindow().setAttributes(lp);
        int windowSetFlags = 256;
        int windowModFlags = 266;
        if (!this.mTakesFocus) {
            windowSetFlags |= 8;
        } else {
            windowSetFlags |= 0x20;
            windowModFlags |= 0x20;
        }
        this.getWindow().setFlags(windowSetFlags, windowModFlags);
    }

    @Override
    public void show() {
        switch (this.mWindowState) {
            case 0: {
                throw new IllegalStateException("Window token is not set yet.");
            }
            case 1: 
            case 2: {
                try {
                    super.show();
                    this.updateWindowState(2);
                }
                catch (WindowManager.BadTokenException e) {
                    Log.i(TAG, "Probably the IME window token is already invalidated. show() does nothing.");
                    this.updateWindowState(3);
                }
                return;
            }
            case 3: {
                Log.i(TAG, "Not trying to call show() because it was already rejected once.");
                return;
            }
            case 4: {
                Log.i(TAG, "Ignoring show() because the window is already destroyed.");
                return;
            }
        }
        throw new IllegalStateException("Unexpected state=" + this.mWindowState);
    }

    void dismissForDestroyIfNecessary() {
        switch (this.mWindowState) {
            case 0: 
            case 1: {
                this.updateWindowState(4);
                return;
            }
            case 2: {
                try {
                    this.getWindow().setWindowAnimations(0);
                    this.dismiss();
                }
                catch (WindowManager.BadTokenException e) {
                    Log.i(TAG, "Probably the IME window token is already invalidated. No need to dismiss it.");
                }
                this.updateWindowState(4);
                return;
            }
            case 3: {
                Log.i(TAG, "Not trying to dismiss the window because it is most likely unnecessary.");
                this.updateWindowState(4);
                return;
            }
            case 4: {
                throw new IllegalStateException("dismissForDestroyIfNecessary can be called only once");
            }
        }
        throw new IllegalStateException("Unexpected state=" + this.mWindowState);
    }

    private void updateWindowState(int newState) {
        this.mWindowState = newState;
    }

    private static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "TOKEN_PENDING";
            }
            case 1: {
                return "TOKEN_SET";
            }
            case 2: {
                return "SHOWN_AT_LEAST_ONCE";
            }
            case 3: {
                return "REJECTED_AT_LEAST_ONCE";
            }
            case 4: {
                return "DESTROYED";
            }
        }
        throw new IllegalStateException("Unknown state=" + state);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mName);
        proto.write(1120986464258L, this.mWindowType);
        proto.write(1120986464259L, this.mGravity);
        proto.write(1133871366148L, this.mTakesFocus);
        this.mBounds.dumpDebug(proto, 1146756268037L);
        proto.write(1120986464262L, this.mWindowState);
        proto.end(token);
    }

    public static interface Callback {
        public void onBackPressed();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface SoftInputWindowState {
        public static final int TOKEN_PENDING = 0;
        public static final int TOKEN_SET = 1;
        public static final int SHOWN_AT_LEAST_ONCE = 2;
        public static final int REJECTED_AT_LEAST_ONCE = 3;
        public static final int DESTROYED = 4;
    }
}

