/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Criteria
implements Parcelable {
    public static final int NO_REQUIREMENT = 0;
    public static final int POWER_LOW = 1;
    public static final int POWER_MEDIUM = 2;
    public static final int POWER_HIGH = 3;
    public static final int ACCURACY_FINE = 1;
    public static final int ACCURACY_COARSE = 2;
    public static final int ACCURACY_LOW = 1;
    public static final int ACCURACY_MEDIUM = 2;
    public static final int ACCURACY_HIGH = 3;
    private int mHorizontalAccuracy = 0;
    private int mVerticalAccuracy = 0;
    private int mSpeedAccuracy = 0;
    private int mBearingAccuracy = 0;
    private int mPowerRequirement = 0;
    private boolean mAltitudeRequired = false;
    private boolean mBearingRequired = false;
    private boolean mSpeedRequired = false;
    private boolean mCostAllowed = false;
    public static final Parcelable.Creator<Criteria> CREATOR = new Parcelable.Creator<Criteria>(){

        @Override
        public Criteria createFromParcel(Parcel in) {
            Criteria c = new Criteria();
            c.mHorizontalAccuracy = in.readInt();
            c.mVerticalAccuracy = in.readInt();
            c.mSpeedAccuracy = in.readInt();
            c.mBearingAccuracy = in.readInt();
            c.mPowerRequirement = in.readInt();
            c.mAltitudeRequired = in.readInt() != 0;
            c.mBearingRequired = in.readInt() != 0;
            c.mSpeedRequired = in.readInt() != 0;
            c.mCostAllowed = in.readInt() != 0;
            return c;
        }

        public Criteria[] newArray(int size) {
            return new Criteria[size];
        }
    };

    public Criteria() {
    }

    public Criteria(Criteria criteria) {
        this.mHorizontalAccuracy = criteria.mHorizontalAccuracy;
        this.mVerticalAccuracy = criteria.mVerticalAccuracy;
        this.mSpeedAccuracy = criteria.mSpeedAccuracy;
        this.mBearingAccuracy = criteria.mBearingAccuracy;
        this.mPowerRequirement = criteria.mPowerRequirement;
        this.mAltitudeRequired = criteria.mAltitudeRequired;
        this.mBearingRequired = criteria.mBearingRequired;
        this.mSpeedRequired = criteria.mSpeedRequired;
        this.mCostAllowed = criteria.mCostAllowed;
    }

    public void setHorizontalAccuracy(int accuracy) {
        this.mHorizontalAccuracy = Preconditions.checkArgumentInRange(accuracy, 0, 3, "accuracy");
    }

    public int getHorizontalAccuracy() {
        return this.mHorizontalAccuracy;
    }

    public void setVerticalAccuracy(int accuracy) {
        this.mVerticalAccuracy = Preconditions.checkArgumentInRange(accuracy, 0, 3, "accuracy");
    }

    public int getVerticalAccuracy() {
        return this.mVerticalAccuracy;
    }

    public void setSpeedAccuracy(int accuracy) {
        this.mSpeedAccuracy = Preconditions.checkArgumentInRange(accuracy, 0, 3, "accuracy");
    }

    public int getSpeedAccuracy() {
        return this.mSpeedAccuracy;
    }

    public void setBearingAccuracy(int accuracy) {
        this.mBearingAccuracy = Preconditions.checkArgumentInRange(accuracy, 0, 3, "accuracy");
    }

    public int getBearingAccuracy() {
        return this.mBearingAccuracy;
    }

    public void setAccuracy(int accuracy) {
        Preconditions.checkArgumentInRange(accuracy, 0, 2, "accuracy");
        switch (accuracy) {
            case 0: {
                this.setHorizontalAccuracy(0);
                break;
            }
            case 1: {
                this.setHorizontalAccuracy(3);
                break;
            }
            case 2: {
                this.setHorizontalAccuracy(1);
            }
        }
    }

    public int getAccuracy() {
        if (this.mHorizontalAccuracy >= 3) {
            return 1;
        }
        return 2;
    }

    public void setPowerRequirement(int powerRequirement) {
        this.mPowerRequirement = Preconditions.checkArgumentInRange(powerRequirement, 0, 3, "powerRequirement");
    }

    public int getPowerRequirement() {
        return this.mPowerRequirement;
    }

    public void setCostAllowed(boolean costAllowed) {
        this.mCostAllowed = costAllowed;
    }

    public boolean isCostAllowed() {
        return this.mCostAllowed;
    }

    public void setAltitudeRequired(boolean altitudeRequired) {
        this.mAltitudeRequired = altitudeRequired;
    }

    public boolean isAltitudeRequired() {
        return this.mAltitudeRequired;
    }

    public void setSpeedRequired(boolean speedRequired) {
        this.mSpeedRequired = speedRequired;
    }

    public boolean isSpeedRequired() {
        return this.mSpeedRequired;
    }

    public void setBearingRequired(boolean bearingRequired) {
        this.mBearingRequired = bearingRequired;
    }

    public boolean isBearingRequired() {
        return this.mBearingRequired;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mHorizontalAccuracy);
        parcel.writeInt(this.mVerticalAccuracy);
        parcel.writeInt(this.mSpeedAccuracy);
        parcel.writeInt(this.mBearingAccuracy);
        parcel.writeInt(this.mPowerRequirement);
        parcel.writeInt(this.mAltitudeRequired ? 1 : 0);
        parcel.writeInt(this.mBearingRequired ? 1 : 0);
        parcel.writeInt(this.mSpeedRequired ? 1 : 0);
        parcel.writeInt(this.mCostAllowed ? 1 : 0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Criteria[");
        s.append("power=").append(Criteria.requirementToString(this.mPowerRequirement)).append(", ");
        s.append("accuracy=").append(Criteria.requirementToString(this.mHorizontalAccuracy));
        if (this.mVerticalAccuracy != 0) {
            s.append(", verticalAccuracy=").append(Criteria.requirementToString(this.mVerticalAccuracy));
        }
        if (this.mSpeedAccuracy != 0) {
            s.append(", speedAccuracy=").append(Criteria.requirementToString(this.mSpeedAccuracy));
        }
        if (this.mBearingAccuracy != 0) {
            s.append(", bearingAccuracy=").append(Criteria.requirementToString(this.mBearingAccuracy));
        }
        if (this.mAltitudeRequired || this.mBearingRequired || this.mSpeedRequired) {
            s.append(", required=[");
            if (this.mAltitudeRequired) {
                s.append("altitude, ");
            }
            if (this.mBearingRequired) {
                s.append("bearing, ");
            }
            if (this.mSpeedRequired) {
                s.append("speed, ");
            }
            s.setLength(s.length() - 2);
            s.append("]");
        }
        if (this.mCostAllowed) {
            s.append(", costAllowed");
        }
        s.append(']');
        return s.toString();
    }

    private static String requirementToString(int power) {
        switch (power) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "Medium";
            }
            case 3: {
                return "High";
            }
        }
        return "???";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationAccuracyRequirement {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AccuracyRequirement {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerRequirement {
    }
}

