/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.Geofence;
import android.location.GnssAntennaInfo;
import android.location.GnssCapabilities;
import android.location.GnssMeasurementCorrections;
import android.location.GnssMeasurementRequest;
import android.location.IGeocodeListener;
import android.location.IGnssAntennaInfoListener;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssNmeaListener;
import android.location.IGnssStatusListener;
import android.location.ILocationCallback;
import android.location.ILocationListener;
import android.location.LastLocationRequest;
import android.location.Location;
import android.location.LocationRequest;
import android.location.LocationTime;
import android.location.provider.IProviderRequestListener;
import android.location.provider.ProviderProperties;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.PackageTagsList;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ILocationManager
extends IInterface {
    public Location getLastLocation(String var1, LastLocationRequest var2, String var3, String var4) throws RemoteException;

    public ICancellationSignal getCurrentLocation(String var1, LocationRequest var2, ILocationCallback var3, String var4, String var5, String var6) throws RemoteException;

    public void registerLocationListener(String var1, LocationRequest var2, ILocationListener var3, String var4, String var5, String var6) throws RemoteException;

    public void unregisterLocationListener(ILocationListener var1) throws RemoteException;

    public void registerLocationPendingIntent(String var1, LocationRequest var2, PendingIntent var3, String var4, String var5) throws RemoteException;

    public void unregisterLocationPendingIntent(PendingIntent var1) throws RemoteException;

    public void injectLocation(Location var1) throws RemoteException;

    public void requestListenerFlush(String var1, ILocationListener var2, int var3) throws RemoteException;

    public void requestPendingIntentFlush(String var1, PendingIntent var2, int var3) throws RemoteException;

    public void requestGeofence(Geofence var1, PendingIntent var2, String var3, String var4) throws RemoteException;

    public void removeGeofence(PendingIntent var1) throws RemoteException;

    public boolean geocoderIsPresent() throws RemoteException;

    public void getFromLocation(double var1, double var3, int var5, GeocoderParams var6, IGeocodeListener var7) throws RemoteException;

    public void getFromLocationName(String var1, double var2, double var4, double var6, double var8, int var10, GeocoderParams var11, IGeocodeListener var12) throws RemoteException;

    public GnssCapabilities getGnssCapabilities() throws RemoteException;

    public int getGnssYearOfHardware() throws RemoteException;

    public String getGnssHardwareModelName() throws RemoteException;

    public List<GnssAntennaInfo> getGnssAntennaInfos() throws RemoteException;

    public void registerGnssStatusCallback(IGnssStatusListener var1, String var2, String var3, String var4) throws RemoteException;

    public void unregisterGnssStatusCallback(IGnssStatusListener var1) throws RemoteException;

    public void registerGnssNmeaCallback(IGnssNmeaListener var1, String var2, String var3, String var4) throws RemoteException;

    public void unregisterGnssNmeaCallback(IGnssNmeaListener var1) throws RemoteException;

    public void addGnssMeasurementsListener(GnssMeasurementRequest var1, IGnssMeasurementsListener var2, String var3, String var4, String var5) throws RemoteException;

    public void removeGnssMeasurementsListener(IGnssMeasurementsListener var1) throws RemoteException;

    public void injectGnssMeasurementCorrections(GnssMeasurementCorrections var1) throws RemoteException;

    public void addGnssNavigationMessageListener(IGnssNavigationMessageListener var1, String var2, String var3, String var4) throws RemoteException;

    public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener var1) throws RemoteException;

    public void addGnssAntennaInfoListener(IGnssAntennaInfoListener var1, String var2, String var3, String var4) throws RemoteException;

    public void removeGnssAntennaInfoListener(IGnssAntennaInfoListener var1) throws RemoteException;

    public void addProviderRequestListener(IProviderRequestListener var1) throws RemoteException;

    public void removeProviderRequestListener(IProviderRequestListener var1) throws RemoteException;

    public int getGnssBatchSize() throws RemoteException;

    public void startGnssBatch(long var1, ILocationListener var3, String var4, String var5, String var6) throws RemoteException;

    public void flushGnssBatch() throws RemoteException;

    public void stopGnssBatch() throws RemoteException;

    public boolean hasProvider(String var1) throws RemoteException;

    public List<String> getAllProviders() throws RemoteException;

    public List<String> getProviders(Criteria var1, boolean var2) throws RemoteException;

    public String getBestProvider(Criteria var1, boolean var2) throws RemoteException;

    public ProviderProperties getProviderProperties(String var1) throws RemoteException;

    public boolean isProviderPackage(String var1, String var2, String var3) throws RemoteException;

    public List<String> getProviderPackages(String var1) throws RemoteException;

    public void setExtraLocationControllerPackage(String var1) throws RemoteException;

    public String getExtraLocationControllerPackage() throws RemoteException;

    public void setExtraLocationControllerPackageEnabled(boolean var1) throws RemoteException;

    public boolean isExtraLocationControllerPackageEnabled() throws RemoteException;

    public boolean isProviderEnabledForUser(String var1, int var2) throws RemoteException;

    public boolean isLocationEnabledForUser(int var1) throws RemoteException;

    public void setLocationEnabledForUser(boolean var1, int var2) throws RemoteException;

    public boolean isAdasGnssLocationEnabledForUser(int var1) throws RemoteException;

    public void setAdasGnssLocationEnabledForUser(boolean var1, int var2) throws RemoteException;

    public void addTestProvider(String var1, ProviderProperties var2, List<String> var3, String var4, String var5) throws RemoteException;

    public void removeTestProvider(String var1, String var2, String var3) throws RemoteException;

    public void setTestProviderLocation(String var1, Location var2, String var3, String var4) throws RemoteException;

    public void setTestProviderEnabled(String var1, boolean var2, String var3, String var4) throws RemoteException;

    public LocationTime getGnssTimeMillis() throws RemoteException;

    public void sendExtraCommand(String var1, String var2, Bundle var3) throws RemoteException;

    public String[] getBackgroundThrottlingWhitelist() throws RemoteException;

    public PackageTagsList getIgnoreSettingsAllowlist() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationManager {
        public static final String DESCRIPTOR = "android.location.ILocationManager";
        static final int TRANSACTION_getLastLocation = 1;
        static final int TRANSACTION_getCurrentLocation = 2;
        static final int TRANSACTION_registerLocationListener = 3;
        static final int TRANSACTION_unregisterLocationListener = 4;
        static final int TRANSACTION_registerLocationPendingIntent = 5;
        static final int TRANSACTION_unregisterLocationPendingIntent = 6;
        static final int TRANSACTION_injectLocation = 7;
        static final int TRANSACTION_requestListenerFlush = 8;
        static final int TRANSACTION_requestPendingIntentFlush = 9;
        static final int TRANSACTION_requestGeofence = 10;
        static final int TRANSACTION_removeGeofence = 11;
        static final int TRANSACTION_geocoderIsPresent = 12;
        static final int TRANSACTION_getFromLocation = 13;
        static final int TRANSACTION_getFromLocationName = 14;
        static final int TRANSACTION_getGnssCapabilities = 15;
        static final int TRANSACTION_getGnssYearOfHardware = 16;
        static final int TRANSACTION_getGnssHardwareModelName = 17;
        static final int TRANSACTION_getGnssAntennaInfos = 18;
        static final int TRANSACTION_registerGnssStatusCallback = 19;
        static final int TRANSACTION_unregisterGnssStatusCallback = 20;
        static final int TRANSACTION_registerGnssNmeaCallback = 21;
        static final int TRANSACTION_unregisterGnssNmeaCallback = 22;
        static final int TRANSACTION_addGnssMeasurementsListener = 23;
        static final int TRANSACTION_removeGnssMeasurementsListener = 24;
        static final int TRANSACTION_injectGnssMeasurementCorrections = 25;
        static final int TRANSACTION_addGnssNavigationMessageListener = 26;
        static final int TRANSACTION_removeGnssNavigationMessageListener = 27;
        static final int TRANSACTION_addGnssAntennaInfoListener = 28;
        static final int TRANSACTION_removeGnssAntennaInfoListener = 29;
        static final int TRANSACTION_addProviderRequestListener = 30;
        static final int TRANSACTION_removeProviderRequestListener = 31;
        static final int TRANSACTION_getGnssBatchSize = 32;
        static final int TRANSACTION_startGnssBatch = 33;
        static final int TRANSACTION_flushGnssBatch = 34;
        static final int TRANSACTION_stopGnssBatch = 35;
        static final int TRANSACTION_hasProvider = 36;
        static final int TRANSACTION_getAllProviders = 37;
        static final int TRANSACTION_getProviders = 38;
        static final int TRANSACTION_getBestProvider = 39;
        static final int TRANSACTION_getProviderProperties = 40;
        static final int TRANSACTION_isProviderPackage = 41;
        static final int TRANSACTION_getProviderPackages = 42;
        static final int TRANSACTION_setExtraLocationControllerPackage = 43;
        static final int TRANSACTION_getExtraLocationControllerPackage = 44;
        static final int TRANSACTION_setExtraLocationControllerPackageEnabled = 45;
        static final int TRANSACTION_isExtraLocationControllerPackageEnabled = 46;
        static final int TRANSACTION_isProviderEnabledForUser = 47;
        static final int TRANSACTION_isLocationEnabledForUser = 48;
        static final int TRANSACTION_setLocationEnabledForUser = 49;
        static final int TRANSACTION_isAdasGnssLocationEnabledForUser = 50;
        static final int TRANSACTION_setAdasGnssLocationEnabledForUser = 51;
        static final int TRANSACTION_addTestProvider = 52;
        static final int TRANSACTION_removeTestProvider = 53;
        static final int TRANSACTION_setTestProviderLocation = 54;
        static final int TRANSACTION_setTestProviderEnabled = 55;
        static final int TRANSACTION_getGnssTimeMillis = 56;
        static final int TRANSACTION_sendExtraCommand = 57;
        static final int TRANSACTION_getBackgroundThrottlingWhitelist = 58;
        static final int TRANSACTION_getIgnoreSettingsAllowlist = 59;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILocationManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILocationManager) {
                return (ILocationManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getLastLocation";
                }
                case 2: {
                    return "getCurrentLocation";
                }
                case 3: {
                    return "registerLocationListener";
                }
                case 4: {
                    return "unregisterLocationListener";
                }
                case 5: {
                    return "registerLocationPendingIntent";
                }
                case 6: {
                    return "unregisterLocationPendingIntent";
                }
                case 7: {
                    return "injectLocation";
                }
                case 8: {
                    return "requestListenerFlush";
                }
                case 9: {
                    return "requestPendingIntentFlush";
                }
                case 10: {
                    return "requestGeofence";
                }
                case 11: {
                    return "removeGeofence";
                }
                case 12: {
                    return "geocoderIsPresent";
                }
                case 13: {
                    return "getFromLocation";
                }
                case 14: {
                    return "getFromLocationName";
                }
                case 15: {
                    return "getGnssCapabilities";
                }
                case 16: {
                    return "getGnssYearOfHardware";
                }
                case 17: {
                    return "getGnssHardwareModelName";
                }
                case 18: {
                    return "getGnssAntennaInfos";
                }
                case 19: {
                    return "registerGnssStatusCallback";
                }
                case 20: {
                    return "unregisterGnssStatusCallback";
                }
                case 21: {
                    return "registerGnssNmeaCallback";
                }
                case 22: {
                    return "unregisterGnssNmeaCallback";
                }
                case 23: {
                    return "addGnssMeasurementsListener";
                }
                case 24: {
                    return "removeGnssMeasurementsListener";
                }
                case 25: {
                    return "injectGnssMeasurementCorrections";
                }
                case 26: {
                    return "addGnssNavigationMessageListener";
                }
                case 27: {
                    return "removeGnssNavigationMessageListener";
                }
                case 28: {
                    return "addGnssAntennaInfoListener";
                }
                case 29: {
                    return "removeGnssAntennaInfoListener";
                }
                case 30: {
                    return "addProviderRequestListener";
                }
                case 31: {
                    return "removeProviderRequestListener";
                }
                case 32: {
                    return "getGnssBatchSize";
                }
                case 33: {
                    return "startGnssBatch";
                }
                case 34: {
                    return "flushGnssBatch";
                }
                case 35: {
                    return "stopGnssBatch";
                }
                case 36: {
                    return "hasProvider";
                }
                case 37: {
                    return "getAllProviders";
                }
                case 38: {
                    return "getProviders";
                }
                case 39: {
                    return "getBestProvider";
                }
                case 40: {
                    return "getProviderProperties";
                }
                case 41: {
                    return "isProviderPackage";
                }
                case 42: {
                    return "getProviderPackages";
                }
                case 43: {
                    return "setExtraLocationControllerPackage";
                }
                case 44: {
                    return "getExtraLocationControllerPackage";
                }
                case 45: {
                    return "setExtraLocationControllerPackageEnabled";
                }
                case 46: {
                    return "isExtraLocationControllerPackageEnabled";
                }
                case 47: {
                    return "isProviderEnabledForUser";
                }
                case 48: {
                    return "isLocationEnabledForUser";
                }
                case 49: {
                    return "setLocationEnabledForUser";
                }
                case 50: {
                    return "isAdasGnssLocationEnabledForUser";
                }
                case 51: {
                    return "setAdasGnssLocationEnabledForUser";
                }
                case 52: {
                    return "addTestProvider";
                }
                case 53: {
                    return "removeTestProvider";
                }
                case 54: {
                    return "setTestProviderLocation";
                }
                case 55: {
                    return "setTestProviderEnabled";
                }
                case 56: {
                    return "getGnssTimeMillis";
                }
                case 57: {
                    return "sendExtraCommand";
                }
                case 58: {
                    return "getBackgroundThrottlingWhitelist";
                }
                case 59: {
                    return "getIgnoreSettingsAllowlist";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    LastLocationRequest _arg1 = 0 != data.readInt() ? LastLocationRequest.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    Location _result = this.getLastLocation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    LocationRequest _arg1 = 0 != data.readInt() ? LocationRequest.CREATOR.createFromParcel(data) : null;
                    ILocationCallback _arg2 = ILocationCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    ICancellationSignal _result = this.getCurrentLocation(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    LocationRequest _arg1 = 0 != data.readInt() ? LocationRequest.CREATOR.createFromParcel(data) : null;
                    ILocationListener _arg2 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    this.registerLocationListener(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ILocationListener _arg0 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterLocationListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    LocationRequest _arg1 = 0 != data.readInt() ? LocationRequest.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg2 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.registerLocationPendingIntent(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    this.unregisterLocationPendingIntent(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    Location _arg0 = 0 != data.readInt() ? Location.CREATOR.createFromParcel(data) : null;
                    this.injectLocation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ILocationListener _arg1 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.requestListenerFlush(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.requestPendingIntentFlush(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    Geofence _arg0 = 0 != data.readInt() ? Geofence.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.requestGeofence(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    this.removeGeofence(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.geocoderIsPresent();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    double _arg0 = data.readDouble();
                    double _arg1 = data.readDouble();
                    int _arg2 = data.readInt();
                    GeocoderParams _arg3 = 0 != data.readInt() ? GeocoderParams.CREATOR.createFromParcel(data) : null;
                    IGeocodeListener _arg4 = IGeocodeListener.Stub.asInterface(data.readStrongBinder());
                    this.getFromLocation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    double _arg1 = data.readDouble();
                    double _arg2 = data.readDouble();
                    double _arg3 = data.readDouble();
                    double _arg4 = data.readDouble();
                    int _arg5 = data.readInt();
                    GeocoderParams _arg6 = 0 != data.readInt() ? GeocoderParams.CREATOR.createFromParcel(data) : null;
                    IGeocodeListener _arg7 = IGeocodeListener.Stub.asInterface(data.readStrongBinder());
                    this.getFromLocationName(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    GnssCapabilities _result = this.getGnssCapabilities();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _result = this.getGnssYearOfHardware();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    String _result = this.getGnssHardwareModelName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    List<GnssAntennaInfo> _result = this.getGnssAntennaInfos();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    IGnssStatusListener _arg0 = IGnssStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.registerGnssStatusCallback(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IGnssStatusListener _arg0 = IGnssStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterGnssStatusCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    IGnssNmeaListener _arg0 = IGnssNmeaListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.registerGnssNmeaCallback(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    IGnssNmeaListener _arg0 = IGnssNmeaListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterGnssNmeaCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    GnssMeasurementRequest _arg0 = 0 != data.readInt() ? GnssMeasurementRequest.CREATOR.createFromParcel(data) : null;
                    IGnssMeasurementsListener _arg1 = IGnssMeasurementsListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.addGnssMeasurementsListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    IGnssMeasurementsListener _arg0 = IGnssMeasurementsListener.Stub.asInterface(data.readStrongBinder());
                    this.removeGnssMeasurementsListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    GnssMeasurementCorrections _arg0 = 0 != data.readInt() ? GnssMeasurementCorrections.CREATOR.createFromParcel(data) : null;
                    this.injectGnssMeasurementCorrections(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    IGnssNavigationMessageListener _arg0 = IGnssNavigationMessageListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.addGnssNavigationMessageListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    IGnssNavigationMessageListener _arg0 = IGnssNavigationMessageListener.Stub.asInterface(data.readStrongBinder());
                    this.removeGnssNavigationMessageListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    IGnssAntennaInfoListener _arg0 = IGnssAntennaInfoListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.addGnssAntennaInfoListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    IGnssAntennaInfoListener _arg0 = IGnssAntennaInfoListener.Stub.asInterface(data.readStrongBinder());
                    this.removeGnssAntennaInfoListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    IProviderRequestListener _arg0 = IProviderRequestListener.Stub.asInterface(data.readStrongBinder());
                    this.addProviderRequestListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    IProviderRequestListener _arg0 = IProviderRequestListener.Stub.asInterface(data.readStrongBinder());
                    this.removeProviderRequestListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _result = this.getGnssBatchSize();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    ILocationListener _arg1 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.startGnssBatch(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    this.flushGnssBatch();
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    this.stopGnssBatch();
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.hasProvider(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    List<String> _result = this.getAllProviders();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    Criteria _arg0 = 0 != data.readInt() ? Criteria.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    List<String> _result = this.getProviders(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    Criteria _arg0 = 0 != data.readInt() ? Criteria.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    String _result = this.getBestProvider(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ProviderProperties _result = this.getProviderProperties(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    boolean _result = this.isProviderPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<String> _result = this.getProviderPackages(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.setExtraLocationControllerPackage(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    String _result = this.getExtraLocationControllerPackage();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setExtraLocationControllerPackageEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isExtraLocationControllerPackageEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isProviderEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isLocationEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    this.setLocationEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isAdasGnssLocationEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    this.setAdasGnssLocationEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ProviderProperties _arg1 = 0 != data.readInt() ? ProviderProperties.CREATOR.createFromParcel(data) : null;
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.addTestProvider(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.removeTestProvider(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Location _arg1 = 0 != data.readInt() ? Location.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.setTestProviderLocation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.setTestProviderEnabled(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    LocationTime _result = this.getGnssTimeMillis();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.sendExtraCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_arg2 != null) {
                        reply.writeInt(1);
                        _arg2.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getBackgroundThrottlingWhitelist();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    PackageTagsList _result = this.getIgnoreSettingsAllowlist();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ILocationManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ILocationManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ILocationManager {
            private IBinder mRemote;
            public static ILocationManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Location getLastLocation(String provider, LastLocationRequest request, String packageName, String attributionTag) throws RemoteException {
                Location _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Location location = Stub.getDefaultImpl().getLastLocation(provider, request, packageName, attributionTag);
                        return location;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Location.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal getCurrentLocation(String provider, LocationRequest request, ILocationCallback callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ICancellationSignal iCancellationSignal = Stub.getDefaultImpl().getCurrentLocation(provider, request, callback, packageName, attributionTag, listenerId);
                        return iCancellationSignal;
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLocationListener(String provider, LocationRequest request, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerLocationListener(provider, request, listener, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLocationListener(ILocationListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterLocationListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLocationPendingIntent(String provider, LocationRequest request, PendingIntent pendingIntent, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (pendingIntent != null) {
                        _data.writeInt(1);
                        pendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerLocationPendingIntent(provider, request, pendingIntent, packageName, attributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLocationPendingIntent(PendingIntent pendingIntent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        _data.writeInt(1);
                        pendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterLocationPendingIntent(pendingIntent);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void injectLocation(Location location) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (location != null) {
                        _data.writeInt(1);
                        location.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().injectLocation(location);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestListenerFlush(String provider, ILocationListener listener, int requestCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestListenerFlush(provider, listener, requestCode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPendingIntentFlush(String provider, PendingIntent pendingIntent, int requestCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    if (pendingIntent != null) {
                        _data.writeInt(1);
                        pendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestPendingIntentFlush(provider, pendingIntent, requestCode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestGeofence(Geofence geofence, PendingIntent intent, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (geofence != null) {
                        _data.writeInt(1);
                        geofence.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestGeofence(geofence, intent, packageName, attributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGeofence(PendingIntent intent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeGeofence(intent);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean geocoderIsPresent() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().geocoderIsPresent();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, IGeocodeListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeDouble(latitude);
                    _data.writeDouble(longitude);
                    _data.writeInt(maxResults);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getFromLocation(latitude, longitude, maxResults, params, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, IGeocodeListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(locationName);
                    _data.writeDouble(lowerLeftLatitude);
                    _data.writeDouble(lowerLeftLongitude);
                    _data.writeDouble(upperRightLatitude);
                    _data.writeDouble(upperRightLongitude);
                    _data.writeInt(maxResults);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, params, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GnssCapabilities getGnssCapabilities() throws RemoteException {
                GnssCapabilities _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        GnssCapabilities gnssCapabilities = Stub.getDefaultImpl().getGnssCapabilities();
                        return gnssCapabilities;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? GnssCapabilities.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGnssYearOfHardware() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getGnssYearOfHardware();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getGnssHardwareModelName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getGnssHardwareModelName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<GnssAntennaInfo> getGnssAntennaInfos() throws RemoteException {
                ArrayList<GnssAntennaInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<GnssAntennaInfo> list = Stub.getDefaultImpl().getGnssAntennaInfos();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(GnssAntennaInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerGnssStatusCallback(IGnssStatusListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerGnssStatusCallback(callback, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterGnssStatusCallback(IGnssStatusListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterGnssStatusCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerGnssNmeaCallback(IGnssNmeaListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerGnssNmeaCallback(callback, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterGnssNmeaCallback(IGnssNmeaListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterGnssNmeaCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGnssMeasurementsListener(GnssMeasurementRequest request, IGnssMeasurementsListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addGnssMeasurementsListener(request, listener, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGnssMeasurementsListener(IGnssMeasurementsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeGnssMeasurementsListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void injectGnssMeasurementCorrections(GnssMeasurementCorrections corrections) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (corrections != null) {
                        _data.writeInt(1);
                        corrections.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().injectGnssMeasurementCorrections(corrections);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addGnssNavigationMessageListener(listener, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeGnssNavigationMessageListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGnssAntennaInfoListener(IGnssAntennaInfoListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addGnssAntennaInfoListener(listener, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGnssAntennaInfoListener(IGnssAntennaInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeGnssAntennaInfoListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addProviderRequestListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeProviderRequestListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGnssBatchSize() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getGnssBatchSize();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startGnssBatch(long periodNanos, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(periodNanos);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startGnssBatch(periodNanos, listener, packageName, attributionTag, listenerId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushGnssBatch() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().flushGnssBatch();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopGnssBatch() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopGnssBatch();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasProvider(String provider) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasProvider(provider);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllProviders() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getAllProviders();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getProviders(Criteria criteria, boolean enabledOnly) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (criteria != null) {
                        _data.writeInt(1);
                        criteria.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enabledOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getProviders(criteria, enabledOnly);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getBestProvider(Criteria criteria, boolean enabledOnly) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (criteria != null) {
                        _data.writeInt(1);
                        criteria.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enabledOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getBestProvider(criteria, enabledOnly);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProviderProperties getProviderProperties(String provider) throws RemoteException {
                ProviderProperties _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ProviderProperties providerProperties = Stub.getDefaultImpl().getProviderProperties(provider);
                        return providerProperties;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ProviderProperties.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isProviderPackage(String provider, String packageName, String attributionTag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isProviderPackage(provider, packageName, attributionTag);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getProviderPackages(String provider) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getProviderPackages(provider);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExtraLocationControllerPackage(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setExtraLocationControllerPackage(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getExtraLocationControllerPackage() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getExtraLocationControllerPackage();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExtraLocationControllerPackageEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setExtraLocationControllerPackageEnabled(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isExtraLocationControllerPackageEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isExtraLocationControllerPackageEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isProviderEnabledForUser(String provider, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isProviderEnabledForUser(provider, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLocationEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLocationEnabledForUser(userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLocationEnabledForUser(enabled, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAdasGnssLocationEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isAdasGnssLocationEnabledForUser(userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdasGnssLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAdasGnssLocationEnabledForUser(enabled, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addTestProvider(String name, ProviderProperties properties, List<String> locationTags, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    if (properties != null) {
                        _data.writeInt(1);
                        properties.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStringList(locationTags);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addTestProvider(name, properties, locationTags, packageName, attributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeTestProvider(String provider, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeTestProvider(provider, packageName, attributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestProviderLocation(String provider, Location location, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    if (location != null) {
                        _data.writeInt(1);
                        location.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTestProviderLocation(provider, location, packageName, attributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestProviderEnabled(String provider, boolean enabled, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTestProviderEnabled(provider, enabled, packageName, attributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LocationTime getGnssTimeMillis() throws RemoteException {
                LocationTime _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LocationTime locationTime = Stub.getDefaultImpl().getGnssTimeMillis();
                        return locationTime;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LocationTime.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendExtraCommand(String provider, String command, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeString(command);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendExtraCommand(provider, command, extras);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        extras.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getBackgroundThrottlingWhitelist() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getBackgroundThrottlingWhitelist();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageTagsList getIgnoreSettingsAllowlist() throws RemoteException {
                PackageTagsList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PackageTagsList packageTagsList = Stub.getDefaultImpl().getIgnoreSettingsAllowlist();
                        return packageTagsList;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PackageTagsList.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ILocationManager {
        @Override
        public Location getLastLocation(String provider, LastLocationRequest request, String packageName, String attributionTag) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal getCurrentLocation(String provider, LocationRequest request, ILocationCallback callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
            return null;
        }

        @Override
        public void registerLocationListener(String provider, LocationRequest request, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void unregisterLocationListener(ILocationListener listener) throws RemoteException {
        }

        @Override
        public void registerLocationPendingIntent(String provider, LocationRequest request, PendingIntent pendingIntent, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void unregisterLocationPendingIntent(PendingIntent pendingIntent) throws RemoteException {
        }

        @Override
        public void injectLocation(Location location) throws RemoteException {
        }

        @Override
        public void requestListenerFlush(String provider, ILocationListener listener, int requestCode) throws RemoteException {
        }

        @Override
        public void requestPendingIntentFlush(String provider, PendingIntent pendingIntent, int requestCode) throws RemoteException {
        }

        @Override
        public void requestGeofence(Geofence geofence, PendingIntent intent, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void removeGeofence(PendingIntent intent) throws RemoteException {
        }

        @Override
        public boolean geocoderIsPresent() throws RemoteException {
            return false;
        }

        @Override
        public void getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, IGeocodeListener listener) throws RemoteException {
        }

        @Override
        public void getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, IGeocodeListener listener) throws RemoteException {
        }

        @Override
        public GnssCapabilities getGnssCapabilities() throws RemoteException {
            return null;
        }

        @Override
        public int getGnssYearOfHardware() throws RemoteException {
            return 0;
        }

        @Override
        public String getGnssHardwareModelName() throws RemoteException {
            return null;
        }

        @Override
        public List<GnssAntennaInfo> getGnssAntennaInfos() throws RemoteException {
            return null;
        }

        @Override
        public void registerGnssStatusCallback(IGnssStatusListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void unregisterGnssStatusCallback(IGnssStatusListener callback) throws RemoteException {
        }

        @Override
        public void registerGnssNmeaCallback(IGnssNmeaListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void unregisterGnssNmeaCallback(IGnssNmeaListener callback) throws RemoteException {
        }

        @Override
        public void addGnssMeasurementsListener(GnssMeasurementRequest request, IGnssMeasurementsListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void removeGnssMeasurementsListener(IGnssMeasurementsListener listener) throws RemoteException {
        }

        @Override
        public void injectGnssMeasurementCorrections(GnssMeasurementCorrections corrections) throws RemoteException {
        }

        @Override
        public void addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) throws RemoteException {
        }

        @Override
        public void addGnssAntennaInfoListener(IGnssAntennaInfoListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void removeGnssAntennaInfoListener(IGnssAntennaInfoListener listener) throws RemoteException {
        }

        @Override
        public void addProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
        }

        @Override
        public void removeProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
        }

        @Override
        public int getGnssBatchSize() throws RemoteException {
            return 0;
        }

        @Override
        public void startGnssBatch(long periodNanos, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void flushGnssBatch() throws RemoteException {
        }

        @Override
        public void stopGnssBatch() throws RemoteException {
        }

        @Override
        public boolean hasProvider(String provider) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getAllProviders() throws RemoteException {
            return null;
        }

        @Override
        public List<String> getProviders(Criteria criteria, boolean enabledOnly) throws RemoteException {
            return null;
        }

        @Override
        public String getBestProvider(Criteria criteria, boolean enabledOnly) throws RemoteException {
            return null;
        }

        @Override
        public ProviderProperties getProviderProperties(String provider) throws RemoteException {
            return null;
        }

        @Override
        public boolean isProviderPackage(String provider, String packageName, String attributionTag) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getProviderPackages(String provider) throws RemoteException {
            return null;
        }

        @Override
        public void setExtraLocationControllerPackage(String packageName) throws RemoteException {
        }

        @Override
        public String getExtraLocationControllerPackage() throws RemoteException {
            return null;
        }

        @Override
        public void setExtraLocationControllerPackageEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isExtraLocationControllerPackageEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isProviderEnabledForUser(String provider, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isLocationEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isAdasGnssLocationEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setAdasGnssLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public void addTestProvider(String name, ProviderProperties properties, List<String> locationTags, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void removeTestProvider(String provider, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void setTestProviderLocation(String provider, Location location, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void setTestProviderEnabled(String provider, boolean enabled, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public LocationTime getGnssTimeMillis() throws RemoteException {
            return null;
        }

        @Override
        public void sendExtraCommand(String provider, String command, Bundle extras) throws RemoteException {
        }

        @Override
        public String[] getBackgroundThrottlingWhitelist() throws RemoteException {
            return null;
        }

        @Override
        public PackageTagsList getIgnoreSettingsAllowlist() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

