/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class LastLocationRequest
implements Parcelable {
    private final boolean mHiddenFromAppOps;
    private final boolean mAdasGnssBypass;
    private final boolean mLocationSettingsIgnored;
    public static final Parcelable.Creator<LastLocationRequest> CREATOR = new Parcelable.Creator<LastLocationRequest>(){

        @Override
        public LastLocationRequest createFromParcel(Parcel in) {
            return new LastLocationRequest(in.readBoolean(), in.readBoolean(), in.readBoolean());
        }

        public LastLocationRequest[] newArray(int size) {
            return new LastLocationRequest[size];
        }
    };

    private LastLocationRequest(boolean hiddenFromAppOps, boolean adasGnssBypass, boolean locationSettingsIgnored) {
        this.mHiddenFromAppOps = hiddenFromAppOps;
        this.mAdasGnssBypass = adasGnssBypass;
        this.mLocationSettingsIgnored = locationSettingsIgnored;
    }

    public boolean isHiddenFromAppOps() {
        return this.mHiddenFromAppOps;
    }

    public boolean isAdasGnssBypass() {
        return this.mAdasGnssBypass;
    }

    public boolean isLocationSettingsIgnored() {
        return this.mLocationSettingsIgnored;
    }

    public boolean isBypass() {
        return this.mAdasGnssBypass || this.mLocationSettingsIgnored;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeBoolean(this.mHiddenFromAppOps);
        parcel.writeBoolean(this.mAdasGnssBypass);
        parcel.writeBoolean(this.mLocationSettingsIgnored);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastLocationRequest that = (LastLocationRequest)o;
        return this.mHiddenFromAppOps == that.mHiddenFromAppOps && this.mAdasGnssBypass == that.mAdasGnssBypass && this.mLocationSettingsIgnored == that.mLocationSettingsIgnored;
    }

    public int hashCode() {
        return Objects.hash(this.mHiddenFromAppOps, this.mAdasGnssBypass, this.mLocationSettingsIgnored);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("LastLocationRequest[");
        if (this.mHiddenFromAppOps) {
            s.append("hiddenFromAppOps, ");
        }
        if (this.mAdasGnssBypass) {
            s.append("adasGnssBypass, ");
        }
        if (this.mLocationSettingsIgnored) {
            s.append("settingsBypass, ");
        }
        if (s.length() > "LastLocationRequest[".length()) {
            s.setLength(s.length() - 2);
        }
        s.append(']');
        return s.toString();
    }

    public static class Builder {
        private boolean mHiddenFromAppOps;
        private boolean mAdasGnssBypass;
        private boolean mLocationSettingsIgnored;

        public Builder() {
            this.mHiddenFromAppOps = false;
            this.mAdasGnssBypass = false;
            this.mLocationSettingsIgnored = false;
        }

        public Builder(LastLocationRequest lastLocationRequest) {
            this.mHiddenFromAppOps = lastLocationRequest.mHiddenFromAppOps;
            this.mAdasGnssBypass = lastLocationRequest.mAdasGnssBypass;
            this.mLocationSettingsIgnored = lastLocationRequest.mLocationSettingsIgnored;
        }

        @RequiresPermission(value="android.permission.UPDATE_APP_OPS_STATS")
        public Builder setHiddenFromAppOps(boolean hiddenFromAppOps) {
            this.mHiddenFromAppOps = hiddenFromAppOps;
            return this;
        }

        @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
        public Builder setAdasGnssBypass(boolean adasGnssBypass) {
            this.mAdasGnssBypass = adasGnssBypass;
            return this;
        }

        @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
        public Builder setLocationSettingsIgnored(boolean locationSettingsIgnored) {
            this.mLocationSettingsIgnored = locationSettingsIgnored;
            return this;
        }

        public LastLocationRequest build() {
            return new LastLocationRequest(this.mHiddenFromAppOps, this.mAdasGnssBypass, this.mLocationSettingsIgnored);
        }
    }
}

