/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.audio.policy.configuration.V7_0.AudioUsage;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.audiopolicy.AudioProductStrategy;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AudioAttributes
implements Parcelable {
    private static final String TAG = "AudioAttributes";
    public static final int CONTENT_TYPE_UNKNOWN = 0;
    public static final int CONTENT_TYPE_SPEECH = 1;
    public static final int CONTENT_TYPE_MUSIC = 2;
    public static final int CONTENT_TYPE_MOVIE = 3;
    public static final int CONTENT_TYPE_SONIFICATION = 4;
    private static final int USAGE_INVALID = -1;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_MEDIA = 1;
    public static final int USAGE_VOICE_COMMUNICATION = 2;
    public static final int USAGE_VOICE_COMMUNICATION_SIGNALLING = 3;
    public static final int USAGE_ALARM = 4;
    public static final int USAGE_NOTIFICATION = 5;
    public static final int USAGE_NOTIFICATION_RINGTONE = 6;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_REQUEST = 7;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_INSTANT = 8;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_DELAYED = 9;
    public static final int USAGE_NOTIFICATION_EVENT = 10;
    public static final int USAGE_ASSISTANCE_ACCESSIBILITY = 11;
    public static final int USAGE_ASSISTANCE_NAVIGATION_GUIDANCE = 12;
    public static final int USAGE_ASSISTANCE_SONIFICATION = 13;
    public static final int USAGE_GAME = 14;
    public static final int USAGE_VIRTUAL_SOURCE = 15;
    public static final int USAGE_ASSISTANT = 16;
    @SystemApi
    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.MODIFY_AUDIO_ROUTING"})
    public static final int USAGE_CALL_ASSISTANT = 17;
    private static final int SYSTEM_USAGE_OFFSET = 1000;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int USAGE_EMERGENCY = 1000;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int USAGE_SAFETY = 1001;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int USAGE_VEHICLE_STATUS = 1002;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int USAGE_ANNOUNCEMENT = 1003;
    public static final int SUPPRESSIBLE_NOTIFICATION = 1;
    public static final int SUPPRESSIBLE_CALL = 2;
    public static final int SUPPRESSIBLE_NEVER = 3;
    public static final int SUPPRESSIBLE_ALARM = 4;
    public static final int SUPPRESSIBLE_MEDIA = 5;
    public static final int SUPPRESSIBLE_SYSTEM = 6;
    public static final SparseIntArray SUPPRESSIBLE_USAGES = new SparseIntArray();
    public static final int[] SDK_USAGES;
    public static final int FLAG_AUDIBILITY_ENFORCED = 1;
    public static final int FLAG_SECURE = 2;
    public static final int FLAG_SCO = 4;
    @SystemApi
    public static final int FLAG_BEACON = 8;
    public static final int FLAG_HW_AV_SYNC = 16;
    @SystemApi
    public static final int FLAG_HW_HOTWORD = 32;
    @SystemApi
    public static final int FLAG_BYPASS_INTERRUPTION_POLICY = 64;
    @SystemApi
    public static final int FLAG_BYPASS_MUTE = 128;
    public static final int FLAG_LOW_LATENCY = 256;
    public static final int FLAG_DEEP_BUFFER = 512;
    public static final int FLAG_NO_MEDIA_PROJECTION = 1024;
    public static final int FLAG_MUTE_HAPTIC = 2048;
    public static final int FLAG_NO_SYSTEM_CAPTURE = 4096;
    public static final int FLAG_CAPTURE_PRIVATE = 8192;
    private static final int FLAG_ALL = 14335;
    private static final int FLAG_ALL_PUBLIC = 273;
    private static final int FLAG_ALL_API_SET = 465;
    public static final int ALLOW_CAPTURE_BY_ALL = 1;
    public static final int ALLOW_CAPTURE_BY_SYSTEM = 2;
    public static final int ALLOW_CAPTURE_BY_NONE = 3;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mUsage = 0;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mContentType = 0;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mSource = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mFlags = 0;
    private HashSet<String> mTags;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String mFormattedTags;
    private Bundle mBundle;
    public static final int FLATTEN_TAGS = 1;
    private static final int ATTR_PARCEL_IS_NULL_BUNDLE = -1977;
    private static final int ATTR_PARCEL_IS_VALID_BUNDLE = 1980;
    private static final int ALL_PARCEL_FLAGS = 1;
    public static final Parcelable.Creator<AudioAttributes> CREATOR;
    private static final Map<String, Integer> sXsdStringToUsage;

    private AudioAttributes() {
    }

    public int getContentType() {
        return this.mContentType;
    }

    public int getUsage() {
        if (AudioAttributes.isSystemUsage(this.mUsage)) {
            return 0;
        }
        return this.mUsage;
    }

    @SystemApi
    public int getSystemUsage() {
        return this.mUsage;
    }

    @SystemApi
    public int getCapturePreset() {
        return this.mSource;
    }

    public int getFlags() {
        return this.mFlags & 0x111;
    }

    @SystemApi
    public int getAllFlags() {
        return this.mFlags & 0x37FF;
    }

    @SystemApi
    public Bundle getBundle() {
        if (this.mBundle == null) {
            return this.mBundle;
        }
        return new Bundle(this.mBundle);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.mTags);
    }

    public boolean areHapticChannelsMuted() {
        return (this.mFlags & 0x800) != 0;
    }

    public int getAllowedCapturePolicy() {
        if ((this.mFlags & 0x1000) == 4096) {
            return 3;
        }
        if ((this.mFlags & 0x400) == 1024) {
            return 2;
        }
        return 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUsage);
        dest.writeInt(this.mContentType);
        dest.writeInt(this.mSource);
        dest.writeInt(this.mFlags);
        dest.writeInt(flags & 1);
        if ((flags & 1) == 0) {
            String[] tagsArray = new String[this.mTags.size()];
            this.mTags.toArray(tagsArray);
            dest.writeStringArray(tagsArray);
        } else if ((flags & 1) == 1) {
            dest.writeString(this.mFormattedTags);
        }
        if (this.mBundle == null) {
            dest.writeInt(-1977);
        } else {
            dest.writeInt(1980);
            dest.writeBundle(this.mBundle);
        }
    }

    private AudioAttributes(Parcel in) {
        this.mUsage = in.readInt();
        this.mContentType = in.readInt();
        this.mSource = in.readInt();
        this.mFlags = in.readInt();
        boolean hasFlattenedTags = (in.readInt() & 1) == 1;
        this.mTags = new HashSet();
        if (hasFlattenedTags) {
            this.mFormattedTags = new String(in.readString());
            this.mTags.add(this.mFormattedTags);
        } else {
            String[] tagsArray = in.readStringArray();
            for (int i = tagsArray.length - 1; i >= 0; --i) {
                this.mTags.add(tagsArray[i]);
            }
            this.mFormattedTags = TextUtils.join((CharSequence)";", this.mTags);
        }
        switch (in.readInt()) {
            case -1977: {
                this.mBundle = null;
                break;
            }
            case 1980: {
                this.mBundle = new Bundle(in.readBundle());
                break;
            }
            default: {
                Log.e(TAG, "Illegal value unmarshalling AudioAttributes, can't initialize bundle");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioAttributes that = (AudioAttributes)o;
        return this.mContentType == that.mContentType && this.mFlags == that.mFlags && this.mSource == that.mSource && this.mUsage == that.mUsage && this.mFormattedTags.equals(that.mFormattedTags);
    }

    public int hashCode() {
        return Objects.hash(this.mContentType, this.mFlags, this.mSource, this.mUsage, this.mFormattedTags, this.mBundle);
    }

    public String toString() {
        return new String("AudioAttributes: usage=" + this.usageToString() + " content=" + this.contentTypeToString() + " flags=0x" + Integer.toHexString(this.mFlags).toUpperCase() + " tags=" + this.mFormattedTags + " bundle=" + (this.mBundle == null ? "null" : this.mBundle.toString()));
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10E00000001L, this.mUsage);
        proto.write(1159641169922L, this.mContentType);
        proto.write(1120986464259L, this.mFlags);
        for (String t : this.mFormattedTags.split(";")) {
            if ((t = t.trim()) == "") continue;
            proto.write(2237677961220L, t);
        }
        proto.end(token);
    }

    public String usageToString() {
        return AudioAttributes.usageToString(this.mUsage);
    }

    public static String usageToString(int usage) {
        switch (usage) {
            case 0: {
                return "USAGE_UNKNOWN";
            }
            case 1: {
                return "USAGE_MEDIA";
            }
            case 2: {
                return "USAGE_VOICE_COMMUNICATION";
            }
            case 3: {
                return "USAGE_VOICE_COMMUNICATION_SIGNALLING";
            }
            case 4: {
                return "USAGE_ALARM";
            }
            case 5: {
                return "USAGE_NOTIFICATION";
            }
            case 6: {
                return "USAGE_NOTIFICATION_RINGTONE";
            }
            case 7: {
                return "USAGE_NOTIFICATION_COMMUNICATION_REQUEST";
            }
            case 8: {
                return "USAGE_NOTIFICATION_COMMUNICATION_INSTANT";
            }
            case 9: {
                return "USAGE_NOTIFICATION_COMMUNICATION_DELAYED";
            }
            case 10: {
                return "USAGE_NOTIFICATION_EVENT";
            }
            case 11: {
                return "USAGE_ASSISTANCE_ACCESSIBILITY";
            }
            case 12: {
                return "USAGE_ASSISTANCE_NAVIGATION_GUIDANCE";
            }
            case 13: {
                return "USAGE_ASSISTANCE_SONIFICATION";
            }
            case 14: {
                return "USAGE_GAME";
            }
            case 16: {
                return "USAGE_ASSISTANT";
            }
            case 17: {
                return "USAGE_CALL_ASSISTANT";
            }
            case 1000: {
                return "USAGE_EMERGENCY";
            }
            case 1001: {
                return "USAGE_SAFETY";
            }
            case 1002: {
                return "USAGE_VEHICLE_STATUS";
            }
            case 1003: {
                return "USAGE_ANNOUNCEMENT";
            }
        }
        return "unknown usage " + usage;
    }

    public static String usageToXsdString(int usage) {
        switch (usage) {
            case 0: {
                return AudioUsage.AUDIO_USAGE_UNKNOWN.toString();
            }
            case 1: {
                return AudioUsage.AUDIO_USAGE_MEDIA.toString();
            }
            case 2: {
                return AudioUsage.AUDIO_USAGE_VOICE_COMMUNICATION.toString();
            }
            case 3: {
                return AudioUsage.AUDIO_USAGE_VOICE_COMMUNICATION_SIGNALLING.toString();
            }
            case 4: {
                return AudioUsage.AUDIO_USAGE_ALARM.toString();
            }
            case 5: {
                return AudioUsage.AUDIO_USAGE_NOTIFICATION.toString();
            }
            case 6: {
                return AudioUsage.AUDIO_USAGE_NOTIFICATION_TELEPHONY_RINGTONE.toString();
            }
            case 11: {
                return AudioUsage.AUDIO_USAGE_ASSISTANCE_ACCESSIBILITY.toString();
            }
            case 12: {
                return AudioUsage.AUDIO_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE.toString();
            }
            case 13: {
                return AudioUsage.AUDIO_USAGE_ASSISTANCE_SONIFICATION.toString();
            }
            case 14: {
                return AudioUsage.AUDIO_USAGE_GAME.toString();
            }
            case 15: {
                return AudioUsage.AUDIO_USAGE_VIRTUAL_SOURCE.toString();
            }
            case 16: {
                return AudioUsage.AUDIO_USAGE_ASSISTANT.toString();
            }
            case 17: {
                return AudioUsage.AUDIO_USAGE_CALL_ASSISTANT.toString();
            }
            case 1000: {
                return AudioUsage.AUDIO_USAGE_EMERGENCY.toString();
            }
            case 1001: {
                return AudioUsage.AUDIO_USAGE_SAFETY.toString();
            }
            case 1002: {
                return AudioUsage.AUDIO_USAGE_VEHICLE_STATUS.toString();
            }
            case 1003: {
                return AudioUsage.AUDIO_USAGE_ANNOUNCEMENT.toString();
            }
        }
        Log.w(TAG, "Unknown usage value " + usage);
        return AudioUsage.AUDIO_USAGE_UNKNOWN.toString();
    }

    public static int xsdStringToUsage(String xsdUsage) {
        if (sXsdStringToUsage.containsKey(xsdUsage)) {
            return sXsdStringToUsage.get(xsdUsage);
        }
        Log.w(TAG, "Usage name not found in AudioUsage enum: " + xsdUsage);
        return 0;
    }

    public String contentTypeToString() {
        switch (this.mContentType) {
            case 0: {
                return new String("CONTENT_TYPE_UNKNOWN");
            }
            case 1: {
                return new String("CONTENT_TYPE_SPEECH");
            }
            case 2: {
                return new String("CONTENT_TYPE_MUSIC");
            }
            case 3: {
                return new String("CONTENT_TYPE_MOVIE");
            }
            case 4: {
                return new String("CONTENT_TYPE_SONIFICATION");
            }
        }
        return new String("unknown content type " + this.mContentType);
    }

    private static int usageForStreamType(int streamType) {
        switch (streamType) {
            case 0: {
                return 2;
            }
            case 1: 
            case 7: {
                return 13;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 10: {
                return 11;
            }
        }
        return 0;
    }

    @SystemApi
    public static boolean isSystemUsage(int usage) {
        return usage == 17 || usage == 1000 || usage == 1001 || usage == 1002 || usage == 1003;
    }

    public int getVolumeControlStream() {
        return AudioAttributes.toVolumeStreamType(true, this);
    }

    @UnsupportedAppUsage
    public static int toLegacyStreamType(AudioAttributes aa) {
        return AudioAttributes.toVolumeStreamType(false, aa);
    }

    private static int toVolumeStreamType(boolean fromGetVolumeControlStream, AudioAttributes aa) {
        if ((aa.getFlags() & 1) == 1) {
            return fromGetVolumeControlStream ? 1 : 7;
        }
        if ((aa.getAllFlags() & 4) == 4) {
            return fromGetVolumeControlStream ? 0 : 6;
        }
        if ((aa.getAllFlags() & 8) == 8) {
            return fromGetVolumeControlStream ? 3 : 9;
        }
        if (AudioProductStrategy.getAudioProductStrategies().size() > 0) {
            return AudioProductStrategy.getLegacyStreamTypeForStrategyWithAudioAttributes(aa);
        }
        switch (aa.getUsage()) {
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 2: 
            case 17: {
                return 0;
            }
            case 3: {
                return fromGetVolumeControlStream ? 0 : 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
            case 11: {
                return 10;
            }
            case 0: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: {
                return 3;
            }
        }
        if (fromGetVolumeControlStream) {
            throw new IllegalArgumentException("Unknown usage value " + aa.getUsage() + " in audio attributes");
        }
        return 3;
    }

    public static int capturePolicyToFlags(int capturePolicy, int flags) {
        switch (capturePolicy) {
            case 3: {
                flags |= 0x1400;
                break;
            }
            case 2: {
                flags |= 0x400;
                flags &= 0xFFFFEFFF;
                break;
            }
            case 1: {
                flags &= 0xFFFFEBFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown allow playback capture policy");
            }
        }
        return flags;
    }

    static {
        SUPPRESSIBLE_USAGES.put(5, 1);
        SUPPRESSIBLE_USAGES.put(6, 2);
        SUPPRESSIBLE_USAGES.put(7, 2);
        SUPPRESSIBLE_USAGES.put(8, 1);
        SUPPRESSIBLE_USAGES.put(9, 1);
        SUPPRESSIBLE_USAGES.put(10, 1);
        SUPPRESSIBLE_USAGES.put(11, 3);
        SUPPRESSIBLE_USAGES.put(2, 3);
        SUPPRESSIBLE_USAGES.put(3, 3);
        SUPPRESSIBLE_USAGES.put(4, 4);
        SUPPRESSIBLE_USAGES.put(1, 5);
        SUPPRESSIBLE_USAGES.put(12, 5);
        SUPPRESSIBLE_USAGES.put(14, 5);
        SUPPRESSIBLE_USAGES.put(16, 5);
        SUPPRESSIBLE_USAGES.put(17, 3);
        SUPPRESSIBLE_USAGES.put(0, 5);
        SUPPRESSIBLE_USAGES.put(13, 6);
        SDK_USAGES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        CREATOR = new Parcelable.Creator<AudioAttributes>(){

            @Override
            public AudioAttributes createFromParcel(Parcel p) {
                return new AudioAttributes(p);
            }

            public AudioAttributes[] newArray(int size) {
                return new AudioAttributes[size];
            }
        };
        sXsdStringToUsage = new HashMap<String, Integer>();
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_UNKNOWN.toString(), 0);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_UNKNOWN.toString(), 0);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_MEDIA.toString(), 1);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_VOICE_COMMUNICATION.toString(), 2);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_VOICE_COMMUNICATION_SIGNALLING.toString(), 3);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_ALARM.toString(), 4);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_NOTIFICATION.toString(), 5);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_NOTIFICATION_TELEPHONY_RINGTONE.toString(), 6);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_ASSISTANCE_ACCESSIBILITY.toString(), 11);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE.toString(), 12);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_ASSISTANCE_SONIFICATION.toString(), 13);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_GAME.toString(), 14);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_VIRTUAL_SOURCE.toString(), 15);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_ASSISTANT.toString(), 16);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_CALL_ASSISTANT.toString(), 17);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_EMERGENCY.toString(), 1000);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_SAFETY.toString(), 1001);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_VEHICLE_STATUS.toString(), 1002);
        sXsdStringToUsage.put(AudioUsage.AUDIO_USAGE_ANNOUNCEMENT.toString(), 1003);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttributeContentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttributeUsage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttributeSdkUsage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttributeSystemUsage {
    }

    public static class Builder {
        private int mUsage = -1;
        private int mSystemUsage = -1;
        private int mContentType = 0;
        private int mSource = -1;
        private int mFlags = 0;
        private boolean mMuteHapticChannels = true;
        private HashSet<String> mTags = new HashSet();
        private Bundle mBundle;
        private int mPrivacySensitive = -1;
        private static final int PRIVACY_SENSITIVE_DEFAULT = -1;
        private static final int PRIVACY_SENSITIVE_DISABLED = 0;
        private static final int PRIVACY_SENSITIVE_ENABLED = 1;

        public Builder() {
        }

        public Builder(AudioAttributes aa) {
            this.mUsage = aa.mUsage;
            this.mContentType = aa.mContentType;
            this.mFlags = aa.getAllFlags();
            this.mTags = (HashSet)aa.mTags.clone();
            this.mMuteHapticChannels = aa.areHapticChannelsMuted();
        }

        public AudioAttributes build() {
            AudioAttributes aa = new AudioAttributes();
            aa.mContentType = this.mContentType;
            if (this.mUsage == -1) {
                if (this.mSystemUsage == -1) {
                    aa.mUsage = 0;
                } else {
                    aa.mUsage = this.mSystemUsage;
                }
            } else if (this.mSystemUsage == -1) {
                aa.mUsage = this.mUsage;
            } else {
                throw new IllegalArgumentException("Cannot set both usage and system usage on same builder");
            }
            aa.mSource = this.mSource;
            aa.mFlags = this.mFlags;
            if (this.mMuteHapticChannels) {
                aa.mFlags |= 2048;
            }
            if (this.mPrivacySensitive == -1) {
                if (this.mSource == 7 || this.mSource == 5) {
                    aa.mFlags |= 8192;
                } else {
                    aa.mFlags &= -8193;
                }
            } else if (this.mPrivacySensitive == 1) {
                aa.mFlags |= 8192;
            } else {
                aa.mFlags &= -8193;
            }
            aa.mTags = (HashSet)this.mTags.clone();
            aa.mFormattedTags = TextUtils.join((CharSequence)";", this.mTags);
            if (this.mBundle != null) {
                aa.mBundle = new Bundle(this.mBundle);
            }
            if (this.mSource != 6 && (this.mFlags & 0x20) == 32) {
                aa.mFlags &= -33;
            }
            return aa;
        }

        public Builder setUsage(int usage) {
            switch (usage) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.mUsage = usage;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid usage " + usage);
                }
            }
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
        public Builder setSystemUsage(int systemUsage) {
            if (!AudioAttributes.isSystemUsage(systemUsage)) {
                throw new IllegalArgumentException("Invalid system usage " + systemUsage);
            }
            this.mSystemUsage = systemUsage;
            return this;
        }

        public Builder setContentType(int contentType) {
            switch (contentType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mContentType = contentType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid content type " + contentType);
                }
            }
            return this;
        }

        public Builder setFlags(int flags) {
            this.mFlags |= (flags &= 0x1D1);
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.CAPTURE_AUDIO_HOTWORD")
        public Builder setHotwordModeEnabled(boolean enable) {
            this.mFlags = enable ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
            return this;
        }

        public Builder setAllowedCapturePolicy(int capturePolicy) {
            this.mFlags = AudioAttributes.capturePolicyToFlags(capturePolicy, this.mFlags);
            return this;
        }

        public Builder replaceFlags(int flags) {
            this.mFlags = flags & 0x37FF;
            return this;
        }

        @SystemApi
        public Builder addBundle(Bundle bundle) {
            if (bundle == null) {
                throw new IllegalArgumentException("Illegal null bundle");
            }
            if (this.mBundle == null) {
                this.mBundle = new Bundle(bundle);
            } else {
                this.mBundle.putAll(bundle);
            }
            return this;
        }

        @UnsupportedAppUsage
        public Builder addTag(String tag) {
            this.mTags.add(tag);
            return this;
        }

        public Builder setLegacyStreamType(int streamType) {
            if (streamType == 10) {
                throw new IllegalArgumentException("STREAM_ACCESSIBILITY is not a legacy stream type that was used for audio playback");
            }
            this.setInternalLegacyStreamType(streamType);
            return this;
        }

        @UnsupportedAppUsage
        public Builder setInternalLegacyStreamType(int streamType) {
            AudioAttributes attributes;
            this.mContentType = 0;
            this.mUsage = 0;
            if (AudioProductStrategy.getAudioProductStrategies().size() > 0 && (attributes = AudioProductStrategy.getAudioAttributesForStrategyWithLegacyStreamType(streamType)) != null) {
                this.mUsage = attributes.mUsage;
                this.mContentType = attributes.mContentType;
                this.mFlags = attributes.getAllFlags();
                this.mMuteHapticChannels = attributes.areHapticChannelsMuted();
                this.mTags = attributes.mTags;
                this.mBundle = attributes.mBundle;
                this.mSource = attributes.mSource;
            }
            if (this.mContentType == 0) {
                switch (streamType) {
                    case 0: {
                        this.mContentType = 1;
                        break;
                    }
                    case 7: {
                        this.mFlags |= 1;
                    }
                    case 1: {
                        this.mContentType = 4;
                        break;
                    }
                    case 2: {
                        this.mContentType = 4;
                        break;
                    }
                    case 3: {
                        this.mContentType = 2;
                        break;
                    }
                    case 4: {
                        this.mContentType = 4;
                        break;
                    }
                    case 5: {
                        this.mContentType = 4;
                        break;
                    }
                    case 6: {
                        this.mContentType = 1;
                        this.mFlags |= 4;
                        break;
                    }
                    case 8: {
                        this.mContentType = 4;
                        break;
                    }
                    case 9: {
                        this.mContentType = 4;
                        this.mFlags |= 8;
                        break;
                    }
                    case 10: {
                        this.mContentType = 1;
                        break;
                    }
                    default: {
                        Log.e(AudioAttributes.TAG, "Invalid stream type " + streamType + " for AudioAttributes");
                    }
                }
            }
            if (this.mUsage == 0) {
                this.mUsage = AudioAttributes.usageForStreamType(streamType);
            }
            return this;
        }

        @SystemApi
        public Builder setCapturePreset(int preset) {
            switch (preset) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    this.mSource = preset;
                    break;
                }
                default: {
                    Log.e(AudioAttributes.TAG, "Invalid capture preset " + preset + " for AudioAttributes");
                }
            }
            return this;
        }

        @SystemApi
        public Builder setInternalCapturePreset(int preset) {
            if (preset == 1999 || preset == 8 || preset == 1998 || preset == 3 || preset == 2 || preset == 4 || preset == 1997) {
                this.mSource = preset;
            } else {
                this.setCapturePreset(preset);
            }
            return this;
        }

        public Builder setHapticChannelsMuted(boolean muted) {
            this.mMuteHapticChannels = muted;
            return this;
        }

        public Builder setPrivacySensitive(boolean privacySensitive) {
            this.mPrivacySensitive = privacySensitive ? 1 : 0;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CapturePolicy {
    }
}

