/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioFormat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.stream.Collectors;

public class AudioProfile {
    public static final int AUDIO_ENCAPSULATION_TYPE_NONE = 0;
    public static final int AUDIO_ENCAPSULATION_TYPE_IEC61937 = 1;
    private final int mFormat;
    private final int[] mSamplingRates;
    private final int[] mChannelMasks;
    private final int[] mChannelIndexMasks;
    private final int mEncapsulationType;

    AudioProfile(int format, int[] samplingRates, int[] channelMasks, int[] channelIndexMasks, int encapsulationType) {
        this.mFormat = format;
        this.mSamplingRates = samplingRates;
        this.mChannelMasks = channelMasks;
        this.mChannelIndexMasks = channelIndexMasks;
        this.mEncapsulationType = encapsulationType;
    }

    public int getFormat() {
        return this.mFormat;
    }

    public int[] getChannelMasks() {
        return this.mChannelMasks;
    }

    public int[] getChannelIndexMasks() {
        return this.mChannelIndexMasks;
    }

    public int[] getSampleRates() {
        return this.mSamplingRates;
    }

    public int getEncapsulationType() {
        return this.mEncapsulationType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(AudioFormat.toLogFriendlyEncoding(this.mFormat));
        if (this.mSamplingRates != null && this.mSamplingRates.length > 0) {
            sb.append(", sampling rates=").append(Arrays.toString(this.mSamplingRates));
        }
        if (this.mChannelMasks != null && this.mChannelMasks.length > 0) {
            sb.append(", channel masks=").append(AudioProfile.toHexString(this.mChannelMasks));
        }
        if (this.mChannelIndexMasks != null && this.mChannelIndexMasks.length > 0) {
            sb.append(", channel index masks=").append(Arrays.toString(this.mChannelIndexMasks));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String toHexString(int[] ints) {
        if (ints == null || ints.length == 0) {
            return "";
        }
        return Arrays.stream(ints).mapToObj(anInt -> String.format("0x%02X", anInt)).collect(Collectors.joining(", "));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapsulationType {
    }
}

