/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaRoute2Info;
import android.media.RoutingSessionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaRouter2Manager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaRouter2Manager";

    public void notifySessionCreated(int var1, RoutingSessionInfo var2) throws RemoteException;

    public void notifySessionUpdated(RoutingSessionInfo var1) throws RemoteException;

    public void notifySessionReleased(RoutingSessionInfo var1) throws RemoteException;

    public void notifyPreferredFeaturesChanged(String var1, List<String> var2) throws RemoteException;

    public void notifyRoutesAdded(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRoutesRemoved(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRoutesChanged(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRequestFailed(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaRouter2Manager {
        static final int TRANSACTION_notifySessionCreated = 1;
        static final int TRANSACTION_notifySessionUpdated = 2;
        static final int TRANSACTION_notifySessionReleased = 3;
        static final int TRANSACTION_notifyPreferredFeaturesChanged = 4;
        static final int TRANSACTION_notifyRoutesAdded = 5;
        static final int TRANSACTION_notifyRoutesRemoved = 6;
        static final int TRANSACTION_notifyRoutesChanged = 7;
        static final int TRANSACTION_notifyRequestFailed = 8;

        public Stub() {
            this.attachInterface(this, IMediaRouter2Manager.DESCRIPTOR);
        }

        public static IMediaRouter2Manager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaRouter2Manager.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaRouter2Manager) {
                return (IMediaRouter2Manager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifySessionCreated";
                }
                case 2: {
                    return "notifySessionUpdated";
                }
                case 3: {
                    return "notifySessionReleased";
                }
                case 4: {
                    return "notifyPreferredFeaturesChanged";
                }
                case 5: {
                    return "notifyRoutesAdded";
                }
                case 6: {
                    return "notifyRoutesRemoved";
                }
                case 7: {
                    return "notifyRoutesChanged";
                }
                case 8: {
                    return "notifyRequestFailed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaRouter2Manager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    RoutingSessionInfo _arg1 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifySessionCreated(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    RoutingSessionInfo _arg0 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifySessionUpdated(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    RoutingSessionInfo _arg0 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifySessionReleased(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    this.notifyPreferredFeaturesChanged(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    this.notifyRoutesAdded(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    this.notifyRoutesRemoved(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    this.notifyRoutesChanged(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.notifyRequestFailed(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IMediaRouter2Manager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IMediaRouter2Manager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IMediaRouter2Manager {
            private IBinder mRemote;
            public static IMediaRouter2Manager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaRouter2Manager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionCreated(int requestId, RoutingSessionInfo session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeInt(requestId);
                    if (session != null) {
                        _data.writeInt(1);
                        session.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySessionCreated(requestId, session);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionUpdated(RoutingSessionInfo session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    if (session != null) {
                        _data.writeInt(1);
                        session.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySessionUpdated(session);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionReleased(RoutingSessionInfo session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    if (session != null) {
                        _data.writeInt(1);
                        session.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySessionReleased(session);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPreferredFeaturesChanged(String packageName, List<String> preferredFeatures) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(preferredFeatures);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyPreferredFeaturesChanged(packageName, preferredFeatures);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesAdded(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRoutesAdded(routes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesRemoved(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRoutesRemoved(routes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesChanged(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRoutesChanged(routes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRequestFailed(int requestId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRequestFailed(requestId, reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaRouter2Manager {
        @Override
        public void notifySessionCreated(int requestId, RoutingSessionInfo session) throws RemoteException {
        }

        @Override
        public void notifySessionUpdated(RoutingSessionInfo session) throws RemoteException {
        }

        @Override
        public void notifySessionReleased(RoutingSessionInfo session) throws RemoteException {
        }

        @Override
        public void notifyPreferredFeaturesChanged(String packageName, List<String> preferredFeatures) throws RemoteException {
        }

        @Override
        public void notifyRoutesAdded(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRoutesRemoved(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRoutesChanged(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRequestFailed(int requestId, int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

