/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TranscodingRequestParcel;
import android.media.TranscodingSessionParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITranscodingClient
extends IInterface {
    public static final String DESCRIPTOR = "android$media$ITranscodingClient".replace('$', '.');

    public boolean submitRequest(TranscodingRequestParcel var1, TranscodingSessionParcel var2) throws RemoteException;

    public boolean cancelSession(int var1) throws RemoteException;

    public boolean getSessionWithId(int var1, TranscodingSessionParcel var2) throws RemoteException;

    public boolean addClientUid(int var1, int var2) throws RemoteException;

    public int[] getClientUids(int var1) throws RemoteException;

    public void unregister() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITranscodingClient {
        static final int TRANSACTION_submitRequest = 1;
        static final int TRANSACTION_cancelSession = 2;
        static final int TRANSACTION_getSessionWithId = 3;
        static final int TRANSACTION_addClientUid = 4;
        static final int TRANSACTION_getClientUids = 5;
        static final int TRANSACTION_unregister = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITranscodingClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITranscodingClient) {
                return (ITranscodingClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    TranscodingRequestParcel _arg0 = 0 != data.readInt() ? TranscodingRequestParcel.CREATOR.createFromParcel(data) : null;
                    TranscodingSessionParcel _arg1 = new TranscodingSessionParcel();
                    boolean _result = this.submitRequest(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.cancelSession(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    TranscodingSessionParcel _arg1 = new TranscodingSessionParcel();
                    boolean _result = this.getSessionWithId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.addClientUid(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int[] _result = this.getClientUids(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.unregister();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITranscodingClient impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITranscodingClient getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITranscodingClient {
            private IBinder mRemote;
            public static ITranscodingClient sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean submitRequest(TranscodingRequestParcel request, TranscodingSessionParcel session) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().submitRequest(request, session);
                        return bl;
                    }
                    _reply.readException();
                    boolean bl = _result = 0 != _reply.readInt();
                    if (0 != _reply.readInt()) {
                        session.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancelSession(int sessionId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().cancelSession(sessionId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSessionWithId(int sessionId, TranscodingSessionParcel session) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getSessionWithId(sessionId, session);
                        return bl;
                    }
                    _reply.readException();
                    boolean bl = _result = 0 != _reply.readInt();
                    if (0 != _reply.readInt()) {
                        session.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addClientUid(int sessionId, int clientUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(clientUid);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addClientUid(sessionId, clientUid);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getClientUids(int sessionId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getClientUids(sessionId);
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregister() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregister();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITranscodingClient {
        @Override
        public boolean submitRequest(TranscodingRequestParcel request, TranscodingSessionParcel session) throws RemoteException {
            return false;
        }

        @Override
        public boolean cancelSession(int sessionId) throws RemoteException {
            return false;
        }

        @Override
        public boolean getSessionWithId(int sessionId, TranscodingSessionParcel session) throws RemoteException {
            return false;
        }

        @Override
        public boolean addClientUid(int sessionId, int clientUid) throws RemoteException {
            return false;
        }

        @Override
        public int[] getClientUids(int sessionId) throws RemoteException {
            return null;
        }

        @Override
        public void unregister() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

