/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TranscodingResultParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface ITranscodingClientCallback
extends IInterface {
    public static final String DESCRIPTOR = "android$media$ITranscodingClientCallback".replace('$', '.');

    public ParcelFileDescriptor openFileDescriptor(String var1, String var2) throws RemoteException;

    public void onTranscodingStarted(int var1) throws RemoteException;

    public void onTranscodingPaused(int var1) throws RemoteException;

    public void onTranscodingResumed(int var1) throws RemoteException;

    public void onTranscodingFinished(int var1, TranscodingResultParcel var2) throws RemoteException;

    public void onTranscodingFailed(int var1, int var2) throws RemoteException;

    public void onAwaitNumberOfSessionsChanged(int var1, int var2, int var3) throws RemoteException;

    public void onProgressUpdate(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITranscodingClientCallback {
        static final int TRANSACTION_openFileDescriptor = 1;
        static final int TRANSACTION_onTranscodingStarted = 2;
        static final int TRANSACTION_onTranscodingPaused = 3;
        static final int TRANSACTION_onTranscodingResumed = 4;
        static final int TRANSACTION_onTranscodingFinished = 5;
        static final int TRANSACTION_onTranscodingFailed = 6;
        static final int TRANSACTION_onAwaitNumberOfSessionsChanged = 7;
        static final int TRANSACTION_onProgressUpdate = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITranscodingClientCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITranscodingClientCallback) {
                return (ITranscodingClientCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ParcelFileDescriptor _result = this.openFileDescriptor(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onTranscodingStarted(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onTranscodingPaused(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onTranscodingResumed(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    TranscodingResultParcel _arg1 = 0 != data.readInt() ? TranscodingResultParcel.CREATOR.createFromParcel(data) : null;
                    this.onTranscodingFinished(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onTranscodingFailed(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onAwaitNumberOfSessionsChanged(_arg0, _arg1, _arg2);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onProgressUpdate(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITranscodingClientCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITranscodingClientCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITranscodingClientCallback {
            private IBinder mRemote;
            public static ITranscodingClientCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openFileDescriptor(String fileUri, String mode) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(fileUri);
                    _data.writeString(mode);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParcelFileDescriptor parcelFileDescriptor = Stub.getDefaultImpl().openFileDescriptor(fileUri, mode);
                        return parcelFileDescriptor;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranscodingStarted(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranscodingStarted(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranscodingPaused(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranscodingPaused(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranscodingResumed(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranscodingResumed(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranscodingFinished(int sessionId, TranscodingResultParcel result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranscodingFinished(sessionId, result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranscodingFailed(int sessionId, int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(errorCode);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranscodingFailed(sessionId, errorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAwaitNumberOfSessionsChanged(int sessionId, int oldAwaitNumber, int newAwaitNumber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(oldAwaitNumber);
                    _data.writeInt(newAwaitNumber);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAwaitNumberOfSessionsChanged(sessionId, oldAwaitNumber, newAwaitNumber);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProgressUpdate(int sessionId, int progress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(progress);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProgressUpdate(sessionId, progress);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITranscodingClientCallback {
        @Override
        public ParcelFileDescriptor openFileDescriptor(String fileUri, String mode) throws RemoteException {
            return null;
        }

        @Override
        public void onTranscodingStarted(int sessionId) throws RemoteException {
        }

        @Override
        public void onTranscodingPaused(int sessionId) throws RemoteException {
        }

        @Override
        public void onTranscodingResumed(int sessionId) throws RemoteException {
        }

        @Override
        public void onTranscodingFinished(int sessionId, TranscodingResultParcel result) throws RemoteException {
        }

        @Override
        public void onTranscodingFailed(int sessionId, int errorCode) throws RemoteException {
        }

        @Override
        public void onAwaitNumberOfSessionsChanged(int sessionId, int oldAwaitNumber, int newAwaitNumber) throws RemoteException {
        }

        @Override
        public void onProgressUpdate(int sessionId, int progress) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

